/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.parser.steps;

import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.runtime.standalone.text.DefaultNutsTexts;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNutsTextNodeParser;
import net.thevpc.nuts.runtime.standalone.text.parser.steps.ParserStep;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;

public class NewLineParserStep
extends ParserStep {
    StringBuilder start = new StringBuilder();
    private NutsSession session;

    public NewLineParserStep(char c, NutsSession session) {
        this.start.append(c);
        this.session = session;
    }

    @Override
    public void consume(char c, DefaultNutsTextNodeParser.State state, boolean wasNewLine) {
        if (c == '\n') {
            this.start.append(c);
        } else {
            state.applyPopReplay(c);
        }
    }

    @Override
    public void appendChild(ParserStep tt) {
        throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"unsupported", (Object[])new Object[0]));
    }

    @Override
    public NutsText toText() {
        DefaultNutsTexts factory0 = (DefaultNutsTexts)NutsTexts.of((NutsSession)this.session);
        return factory0.ofPlain(this.start.toString());
    }

    @Override
    public void end(DefaultNutsTextNodeParser.State p) {
        p.applyPop();
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("NewLine(" + CoreStringUtils.dblQuote(this.start.toString()));
        return sb.append(")").toString();
    }
}

