/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.parser.steps;

import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTerminalCommand;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.runtime.standalone.text.DefaultNutsTexts;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNutsTextNodeParser;
import net.thevpc.nuts.runtime.standalone.text.parser.steps.ParserStep;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;

public class AntiQuote3ParserStep
extends ParserStep {
    StringBuilder start = new StringBuilder();
    StringBuilder end = new StringBuilder();
    StringBuilder value = new StringBuilder();
    int maxSize = 3;
    private static final int START_QUOTES = 0;
    private static final int CONTENT = 1;
    private static final int CONTENT_ANTISLASH = 2;
    private static final int CONTENT_ANTISLASH_TIC1 = 3;
    private static final int CONTENT_ANTISLASH_TIC2 = 4;
    private static final int END_QUOTES = 20;
    int status = 0;
    char antiQuote;
    boolean spreadLines;
    NutsSession session;
    boolean exitOnBrace;

    public AntiQuote3ParserStep(char c, boolean spreadLines, NutsSession session, boolean exitOnBrace) {
        this.antiQuote = c;
        this.start.append(this.antiQuote);
        this.spreadLines = spreadLines;
        this.session = session;
        this.exitOnBrace = exitOnBrace;
    }

    @Override
    public void consume(char c, DefaultNutsTextNodeParser.State p, boolean wasNewLine) {
        switch (this.status) {
            case 0: {
                if (c == this.antiQuote) {
                    if (this.start.length() < this.maxSize) {
                        this.start.append(c);
                    } else {
                        this.start.append(c);
                        p.applyDropReplacePreParsedPlain(this.start.toString(), this.exitOnBrace);
                    }
                } else if (this.start.length() == this.maxSize) {
                    switch (c) {
                        case '\\': {
                            this.status = 2;
                            break;
                        }
                        default: {
                            this.value.append(c);
                            this.status = 1;
                            break;
                        }
                    }
                } else {
                    this.start.append(c);
                    p.applyDropReplacePreParsedPlain(this.start.toString(), this.exitOnBrace);
                }
                return;
            }
            case 1: {
                if (c == this.antiQuote) {
                    this.status = 20;
                    this.end.append(c);
                    if (this.end.length() >= this.start.length()) {
                        p.applyPop();
                        return;
                    }
                } else {
                    switch (c) {
                        case '\\': {
                            this.status = 2;
                            break;
                        }
                        default: {
                            this.value.append(c);
                        }
                    }
                }
                return;
            }
            case 2: {
                if (c == this.antiQuote) {
                    this.status = 3;
                } else {
                    this.value.append('\\');
                    this.value.append(c);
                    this.status = 1;
                }
                return;
            }
            case 3: {
                if (c == this.antiQuote) {
                    this.status = 4;
                } else {
                    this.value.append('\\');
                    this.value.append('`');
                    this.value.append(c);
                    this.status = 1;
                }
                return;
            }
            case 4: {
                if (c == this.antiQuote) {
                    this.value.append("```");
                    this.status = 1;
                } else {
                    this.value.append('\\');
                    this.value.append('`');
                    this.value.append('`');
                    this.value.append(c);
                    this.status = 1;
                }
                return;
            }
            case 20: {
                if (c == this.antiQuote) {
                    this.end.append(c);
                } else if (this.end.length() == this.maxSize) {
                    p.applyPopReplay(c);
                } else {
                    switch (c) {
                        case '\\': {
                            this.value.append((CharSequence)this.end);
                            this.end.delete(0, this.end.length());
                            this.status = 2;
                            break;
                        }
                        default: {
                            this.value.append((CharSequence)this.end);
                            this.end.delete(0, this.end.length());
                            this.value.append(c);
                            this.status = 1;
                        }
                    }
                }
                return;
            }
        }
        throw new IllegalArgumentException("unexpected");
    }

    @Override
    public void appendChild(ParserStep tt) {
        throw new UnsupportedOperationException("unsupported operation: appendChild");
    }

    @Override
    public NutsText toText() {
        StringBuilder value2 = new StringBuilder(this.getPartialValue());
        char[] dst = new char[value2.length()];
        value2.getChars(0, value2.length(), dst, 0);
        DefaultNutsTexts factory0 = (DefaultNutsTexts)NutsTexts.of((NutsSession)this.session);
        int i = 0;
        int endOffset = -1;
        if (dst.length > 0 && dst[i] == '!') {
            ++i;
        }
        while (i < dst.length) {
            if (Character.isWhitespace(dst[i])) {
                endOffset = i;
                break;
            }
            if (!Character.isAlphabetic(dst[i]) && !Character.isDigit(dst[i]) && dst[i] != '-' && dst[i] != '_') {
                endOffset = i;
                break;
            }
            ++i;
        }
        if (endOffset == -1) {
            endOffset = dst.length;
        }
        StringBuilder w = new StringBuilder();
        for (i = endOffset; i < dst.length && Character.isWhitespace(dst[i]); ++i) {
            w.append(dst[i]);
        }
        String cmd = new String(dst, 0, endOffset);
        String value = new String(dst, i, dst.length - i);
        if (cmd.startsWith("!")) {
            String cmd0 = cmd.substring(1);
            String start2 = this.start.toString() + "!";
            switch (cmd) {
                case "!anchor": {
                    return factory0.createAnchor(start2, w.toString(), this.end.toString(), value);
                }
                case "!link": {
                    return factory0.createLink(start2, w.toString(), this.end.toString(), (NutsText)factory0.ofPlain(value));
                }
            }
            NutsTerminalCommand ntc = NutsTerminalCommand.of((String)cmd0, (String)value);
            return factory0.createCommand(start2, ntc, w.toString(), this.end.toString());
        }
        if (value.isEmpty()) {
            if (w.length() > 0 && cmd.length() > 0) {
                return factory0.createCode(this.start.toString(), cmd, w.toString(), this.end.toString(), value);
            }
            return factory0.createCode(this.start.toString(), "", "", this.end.toString(), cmd + w.toString() + value);
        }
        return factory0.createCode(this.start.toString(), cmd, w.toString(), this.end.toString(), value);
    }

    private String getPartialValue() {
        StringBuilder value2 = new StringBuilder(this.value);
        switch (this.status) {
            case 2: {
                value2.append('\\');
                break;
            }
            case 3: {
                value2.append("\\`");
                break;
            }
            case 4: {
                value2.append("\\``");
            }
        }
        return value2.toString();
    }

    @Override
    public void end(DefaultNutsTextNodeParser.State p) {
        if (!this.isComplete()) {
            while (this.end.length() < this.start.length()) {
                this.end.append(this.antiQuote);
            }
        }
        p.applyPop();
    }

    @Override
    public boolean isComplete() {
        return this.status == 20 && this.end.length() == this.start.length();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Quoted(" + CoreStringUtils.dblQuote(this.start.toString()));
        sb.append(",");
        sb.append(CoreStringUtils.dblQuote(this.getPartialValue()));
        sb.append(",status=").append(this.status == 0 ? "EXPECT_START" : (this.status == 1 ? "EXPECT_CONTENT" : (this.status == 2 ? "EXPECT_END" : String.valueOf(this.status))));
        sb.append(",end=");
        sb.append((CharSequence)this.end);
        sb.append(this.isComplete() ? "" : ",incomplete");
        return sb.append(")").toString();
    }
}

