/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextList;
import net.thevpc.nuts.NutsTextType;
import net.thevpc.nuts.runtime.standalone.text.parser.AbstractNutsText;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNutsTextPlain;

public class DefaultNutsTextList
extends AbstractNutsText
implements NutsTextList {
    private final List<NutsText> children = new ArrayList<NutsText>();

    public DefaultNutsTextList(NutsSession session, NutsText ... children) {
        super(session);
        if (children != null) {
            for (NutsText c : children) {
                if (c == null) continue;
                this.children.add(c);
            }
        }
    }

    @Override
    public boolean isEmpty() {
        for (NutsText child : this.children) {
            if (child.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public NutsTextType getType() {
        return NutsTextType.LIST;
    }

    public int size() {
        return this.children.size();
    }

    public NutsText get(int index) {
        return this.children.get(index);
    }

    public List<NutsText> getChildren() {
        return new ArrayList<NutsText>(this.children);
    }

    public NutsText simplify() {
        if (this.isEmpty()) {
            return new DefaultNutsTextPlain(this.getSession(), "");
        }
        if (this.size() == 1) {
            return this.get(0);
        }
        return this;
    }

    public Iterator<NutsText> iterator() {
        return this.children.iterator();
    }

    public int hashCode() {
        return Objects.hash(this.children);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNutsTextList nutsTexts = (DefaultNutsTextList)o;
        return Objects.equals(this.children, nutsTexts.children);
    }

    @Override
    public String filteredText() {
        StringBuilder sb = new StringBuilder();
        for (NutsText child : this.children) {
            sb.append(child.filteredText());
        }
        return sb.toString();
    }
}

