/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.parser;

import java.util.Objects;
import net.thevpc.nuts.NutsCodeHighlighter;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextCode;
import net.thevpc.nuts.NutsTextType;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.runtime.standalone.text.DefaultNutsTexts;
import net.thevpc.nuts.runtime.standalone.text.parser.NutsTextSpecialBase;

public class DefaultNutsTextCode
extends NutsTextSpecialBase
implements NutsTextCode {
    private final String text;

    public DefaultNutsTextCode(NutsSession session, String start, String kind, String separator, String end, String text) {
        super(session, start, kind, kind != null && kind.length() > 0 && text != null && text.length() > 0 && (separator == null || separator.isEmpty()) ? " " : separator, end);
        this.text = text;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public NutsText highlight(NutsSession session) {
        NutsTexts txt = NutsTexts.of((NutsSession)session);
        NutsCodeHighlighter t = ((DefaultNutsTexts)txt).setSession(session).resolveCodeHighlighter(this.getKind());
        return t.stringToText(this.text, txt, session);
    }

    public NutsTextType getType() {
        return NutsTextType.CODE;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultNutsTextCode that = (DefaultNutsTextCode)o;
        return Objects.equals(this.text, that.text);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.text);
    }

    @Override
    public String filteredText() {
        return this.text == null ? "" : this.text;
    }
}

