/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.highlighter;

import java.io.StringReader;
import java.util.ArrayList;
import net.thevpc.nuts.NutsCodeHighlighter;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.util.collections.EvictingQueue;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StreamTokenizerExt;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class XmlCodeHighlighter
implements NutsCodeHighlighter {
    private final NutsWorkspace ws;

    public XmlCodeHighlighter(NutsWorkspace ws) {
        this.ws = ws;
    }

    public String getId() {
        return "xml";
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        String s = (String)context.getConstraints();
        if (s == null) {
            return 10;
        }
        switch (s) {
            case "xml": 
            case "xsl": 
            case "text/xml": 
            case "text/html": 
            case "html": 
            case "sgml": {
                return 10;
            }
        }
        return -1;
    }

    public NutsText stringToText(String text, NutsTexts txt, NutsSession session) {
        int s;
        StreamTokenizerExt st = new StreamTokenizerExt(new StringReader(text), session);
        st.xmlComments(true);
        st.doNotParseNumbers();
        st.wordChars(48, 57);
        st.wordChars(46, 46);
        st.wordChars(45, 45);
        ArrayList<Object> nodes = new ArrayList<Object>();
        EvictingQueue<String> last = new EvictingQueue<String>(3);
        while ((s = st.nextToken()) != -1) {
            switch (s) {
                case -11: {
                    nodes.add(txt.ofPlain(st.image));
                    break;
                }
                case -10: {
                    nodes.add(txt.applyStyles((NutsText)txt.ofPlain(st.image), new NutsTextStyle[]{NutsTextStyle.comments()}));
                    break;
                }
                case -9: 
                case -8: 
                case -7: 
                case -6: 
                case -5: 
                case -4: {
                    nodes.add(txt.applyStyles((NutsText)txt.ofPlain(st.image), new NutsTextStyle[]{NutsTextStyle.number()}));
                    break;
                }
                case -3: {
                    if (last.size() > 0 && ((String)last.get(last.size() - 1)).equals("<")) {
                        nodes.add(this.formatNodeName(st.image, txt));
                        break;
                    }
                    if (last.size() > 1 && ((String)last.get(last.size() - 2)).equals("<") && ((String)last.get(last.size() - 1)).equals("/")) {
                        nodes.add(this.formatNodeName(st.image, txt));
                        break;
                    }
                    if (last.size() > 1 && ((String)last.get(last.size() - 2)).equals("<") && ((String)last.get(last.size() - 1)).equals("?")) {
                        nodes.add(this.formatNodeName(st.image, txt));
                        break;
                    }
                    if (st.image.equals("true") || st.image.equals("false")) {
                        nodes.add(this.formatNodeName(st.image, txt));
                        break;
                    }
                    nodes.add(txt.ofPlain(st.image));
                    break;
                }
                case 39: {
                    nodes.add(this.formatNodeString(st.image, txt));
                    break;
                }
                case 34: {
                    nodes.add(this.formatNodeString(st.image, txt));
                    break;
                }
                case 38: 
                case 60: 
                case 61: 
                case 62: {
                    nodes.add(txt.applyStyles((NutsText)txt.ofPlain(st.image), new NutsTextStyle[]{NutsTextStyle.separator()}));
                    break;
                }
                default: {
                    nodes.add(txt.applyStyles((NutsText)txt.ofPlain(st.image), new NutsTextStyle[]{NutsTextStyle.separator()}));
                }
            }
            last.add(st.image == null ? "" : st.image);
        }
        return txt.ofList(nodes).simplify();
    }

    public NutsText tokenToText(String text, String nodeType, NutsTexts txt, NutsSession session) {
        switch (NutsUtilStrings.trim((String)nodeType).toLowerCase()) {
            case "name": {
                return this.formatNodeName(text, txt);
            }
            case "attribute": {
                return this.formatNodeName(text, txt);
            }
            case "string": {
                return this.formatNodeString(text, txt);
            }
            case "<": 
            case "<?": 
            case "</": 
            case ">": 
            case "&": 
            case "=": 
            case "separator": {
                return this.formatNodeSeparator(text, txt);
            }
        }
        return txt.ofPlain(text);
    }

    public NutsText formatNodeName(String text, NutsTexts txt) {
        return txt.applyStyles((NutsText)txt.ofPlain(text), new NutsTextStyle[]{NutsTextStyle.keyword()});
    }

    public NutsText formatNodeString(String text, NutsTexts txt) {
        return txt.applyStyles((NutsText)txt.ofPlain(text), new NutsTextStyle[]{NutsTextStyle.string()});
    }

    public NutsText formatNodeSeparator(String text, NutsTexts txt) {
        return txt.applyStyles((NutsText)txt.ofPlain(text), new NutsTextStyle[]{NutsTextStyle.separator()});
    }
}

