/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.highlighter;

import java.util.ArrayList;
import java.util.Arrays;
import net.thevpc.nuts.NutsCodeHighlighter;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextPlain;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTextType;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.text.highlighter.StringReaderExtUtils;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringReaderExt;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class JsonCodeHighlighter
implements NutsCodeHighlighter {
    private NutsWorkspace ws;

    public JsonCodeHighlighter(NutsWorkspace ws) {
        this.ws = ws;
    }

    public String getId() {
        return "json";
    }

    public NutsText tokenToText(String text, String nodeType, NutsTexts txt, NutsSession session) {
        return txt.ofPlain(text);
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        String s = (String)context.getConstraints();
        if (s == null) {
            return 10;
        }
        switch (s) {
            case "json": 
            case "application/json": 
            case "text/json": {
                return 10;
            }
        }
        return -1;
    }

    public NutsText stringToText(String text, NutsTexts txt, NutsSession session) {
        ArrayList<Object> all = new ArrayList<Object>();
        StringReaderExt ar = new StringReaderExt(text);
        block15: while (ar.hasNext()) {
            NutsText[] d;
            switch (ar.peekChar()) {
                case ':': 
                case '{': 
                case '}': {
                    all.add(txt.ofStyled(String.valueOf(ar.nextChar()), NutsTextStyle.separator()));
                    continue block15;
                }
                case '\'': {
                    all.addAll(Arrays.asList(StringReaderExtUtils.readJSSimpleQuotes(session, ar)));
                    continue block15;
                }
                case '\"': {
                    all.addAll(Arrays.asList(StringReaderExtUtils.readJSDoubleQuotesString(session, ar)));
                    continue block15;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    all.addAll(Arrays.asList(StringReaderExtUtils.readNumber(session, ar)));
                    continue block15;
                }
                case '-': 
                case '.': {
                    d = StringReaderExtUtils.readNumber(session, ar);
                    if (d != null) {
                        all.addAll(Arrays.asList(d));
                        continue block15;
                    }
                    all.add(txt.ofStyled(String.valueOf(ar.nextChar()), NutsTextStyle.separator()));
                    continue block15;
                }
                case '/': {
                    if (ar.peekChars("//")) {
                        all.addAll(Arrays.asList(StringReaderExtUtils.readSlashSlashComments(session, ar)));
                        continue block15;
                    }
                    if (ar.peekChars("/*")) {
                        all.addAll(Arrays.asList(StringReaderExtUtils.readSlashStarComments(session, ar)));
                        continue block15;
                    }
                    all.add(txt.ofStyled(String.valueOf(ar.nextChar()), NutsTextStyle.separator()));
                    continue block15;
                }
            }
            if (Character.isWhitespace(ar.peekChar())) {
                all.addAll(Arrays.asList(StringReaderExtUtils.readSpaces(session, ar)));
                continue;
            }
            d = StringReaderExtUtils.readJSIdentifier(session, ar);
            if (d != null) {
                if (d.length == 1 && d[0].getType() == NutsTextType.PLAIN) {
                    String txt2;
                    switch (txt2 = ((NutsTextPlain)d[0]).getText()) {
                        case "true": 
                        case "false": {
                            d[0] = txt.applyStyles(d[0], new NutsTextStyle[]{NutsTextStyle.bool()});
                        }
                    }
                }
                all.addAll(Arrays.asList(d));
                continue;
            }
            all.add(txt.ofStyled(String.valueOf(ar.nextChar()), NutsTextStyle.separator()));
        }
        return txt.ofList(all.toArray(new NutsText[0]));
    }
}

