/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text;

import java.io.IOException;
import java.io.OutputStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTerminalMode;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsUnsupportedEnumException;
import net.thevpc.nuts.runtime.standalone.io.outputstream.BaseTransparentFilterOutputStream;
import net.thevpc.nuts.runtime.standalone.io.terminal.NutsTerminalModeOp;
import net.thevpc.nuts.runtime.standalone.io.terminal.NutsTerminalModeOpUtils;
import net.thevpc.nuts.runtime.standalone.text.ExtendedFormatAware;
import net.thevpc.nuts.runtime.standalone.text.FormatOutputStream;
import net.thevpc.nuts.runtime.standalone.text.RawOutputStream;
import net.thevpc.nuts.spi.NutsSystemTerminalBase;

public class UnescapeOutputStream
extends BaseTransparentFilterOutputStream
implements ExtendedFormatAware {
    private NutsSession session;
    private NutsSystemTerminalBase term;

    public UnescapeOutputStream(OutputStream out, NutsSystemTerminalBase term, NutsSession session) {
        super(out);
        this.session = session;
        this.term = term;
        NutsTerminalModeOp t = NutsTerminalModeOpUtils.resolveNutsTerminalModeOp(out);
        if (t.in() != NutsTerminalMode.FORMATTED && t.in() != NutsTerminalMode.FILTERED) {
            throw new IllegalArgumentException("Illegal Formatted");
        }
    }

    @Override
    public NutsTerminalModeOp getModeOp() {
        return NutsTerminalModeOp.UNESCAPE;
    }

    public OutputStream getOut() {
        return this.out;
    }

    private String filterThanEscape(String b) throws IOException {
        NutsTexts txt = NutsTexts.of((NutsSession)this.session);
        String filtered = txt.builder().append((Object)b).filteredText();
        return txt.ofPlain(filtered).toString();
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(this.filterThanEscape(Character.toString((char)b)).getBytes());
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        byte[] bytes = this.filterThanEscape(new String(b, off, len)).getBytes();
        this.out.write(bytes, 0, bytes.length);
    }

    @Override
    public ExtendedFormatAware convert(NutsTerminalModeOp other) {
        if (other == null || other == this.getModeOp()) {
            return this;
        }
        switch (other) {
            case NOP: {
                if (this.out instanceof ExtendedFormatAware) {
                    return ((ExtendedFormatAware)((Object)this.out)).convert(NutsTerminalModeOp.NOP);
                }
                return new RawOutputStream(this.out, this.term, this.session);
            }
            case FORMAT: {
                if (this.out instanceof ExtendedFormatAware) {
                    return ((ExtendedFormatAware)((Object)this.out)).convert(NutsTerminalModeOp.FORMAT);
                }
                return new FormatOutputStream(this.out, this.term, this.session);
            }
            case FILTER: {
                if (this.out instanceof ExtendedFormatAware) {
                    return ((ExtendedFormatAware)((Object)this.out)).convert(NutsTerminalModeOp.FILTER);
                }
                return this;
            }
            case ESCAPE: {
                return (ExtendedFormatAware)((Object)this.out);
            }
            case UNESCAPE: {
                return (ExtendedFormatAware)((Object)this.out);
            }
        }
        throw new NutsUnsupportedEnumException(this.session, (Enum)other);
    }
}

