/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUnsupportedEnumException;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.io.terminal.NutsTerminalModeOp;
import net.thevpc.nuts.runtime.standalone.text.EscapeOutputStream;
import net.thevpc.nuts.runtime.standalone.text.ExtendedFormatAware;
import net.thevpc.nuts.runtime.standalone.text.ExtendedFormatAwarePrintWriter;
import net.thevpc.nuts.runtime.standalone.text.FilterFormatOutputStream;
import net.thevpc.nuts.runtime.standalone.text.FormatOutputStream;
import net.thevpc.nuts.spi.NutsSystemTerminalBase;

public class SimpleWriterOutputStream
extends OutputStream
implements ExtendedFormatAware {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private final Writer writer;
    private final CharsetDecoder decoder;
    private final boolean writeImmediately;
    private final ByteBuffer decoderIn = ByteBuffer.allocate(128);
    private final CharBuffer decoderOut;
    private final NutsWorkspace ws;
    private final NutsSession session;
    private final NutsSystemTerminalBase term;

    public SimpleWriterOutputStream(Writer writer, CharsetDecoder decoder, NutsSystemTerminalBase term, NutsSession session) {
        this(writer, decoder, 1024, false, term, session);
    }

    public SimpleWriterOutputStream(Writer writer, CharsetDecoder decoder, int bufferSize, boolean writeImmediately, NutsSystemTerminalBase term, NutsSession session) {
        this.session = session;
        this.ws = session.getWorkspace();
        this.writer = writer;
        this.decoder = decoder;
        this.term = term;
        this.writeImmediately = writeImmediately;
        this.decoderOut = CharBuffer.allocate(bufferSize);
    }

    public SimpleWriterOutputStream(Writer writer, Charset charset, int bufferSize, boolean writeImmediately, NutsSystemTerminalBase term, NutsSession session) {
        this(writer, charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith("?"), bufferSize, writeImmediately, term, session);
    }

    public SimpleWriterOutputStream(Writer writer, Charset charset, NutsSystemTerminalBase term, NutsSession session) {
        this(writer, charset, 1024, false, term, session);
    }

    public SimpleWriterOutputStream(Writer writer, String charsetName, int bufferSize, boolean writeImmediately, NutsSystemTerminalBase term, NutsSession session) {
        this(writer, Charset.forName(charsetName), bufferSize, writeImmediately, term, session);
    }

    public SimpleWriterOutputStream(Writer writer, String charsetName, NutsSystemTerminalBase term, NutsSession session) {
        this(writer, charsetName, 1024, false, term, session);
    }

    public SimpleWriterOutputStream(Writer writer, NutsSystemTerminalBase term, NutsSession session) {
        this(writer, Charset.defaultCharset(), 1024, false, term, session);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int c = Math.min(len, this.decoderIn.remaining());
            this.decoderIn.put(b, off, c);
            this.processInput(false);
            len -= c;
            off += c;
        }
        if (this.writeImmediately) {
            this.flushOutput();
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void flush() throws IOException {
        this.flushOutput();
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.processInput(true);
        this.flushOutput();
        this.writer.close();
    }

    private void processInput(boolean endOfInput) throws IOException {
        CoderResult coderResult;
        this.decoderIn.flip();
        while ((coderResult = this.decoder.decode(this.decoderIn, this.decoderOut, endOfInput)).isOverflow()) {
            this.flushOutput();
        }
        if (!coderResult.isUnderflow()) {
            throw new IOException("unexpected coder result");
        }
        this.decoderIn.compact();
    }

    private void flushOutput() throws IOException {
        if (this.decoderOut.position() > 0) {
            this.writer.write(this.decoderOut.array(), 0, this.decoderOut.position());
            this.decoderOut.rewind();
        }
    }

    @Override
    public NutsTerminalModeOp getModeOp() {
        if (this.writer instanceof ExtendedFormatAware) {
            return ((ExtendedFormatAware)((Object)this.writer)).getModeOp();
        }
        return NutsTerminalModeOp.NOP;
    }

    @Override
    public ExtendedFormatAware convert(NutsTerminalModeOp other) {
        if (other == null || other == this.getModeOp()) {
            return this;
        }
        if (this.writer instanceof ExtendedFormatAwarePrintWriter) {
            return ((ExtendedFormatAwarePrintWriter)this.writer).convert(other);
        }
        switch (other) {
            case NOP: {
                return this;
            }
            case FORMAT: {
                return new FormatOutputStream(this, this.term, this.session);
            }
            case FILTER: {
                return new FilterFormatOutputStream(this, this.term, this.session);
            }
            case ESCAPE: {
                return new EscapeOutputStream(this, this.term, this.session);
            }
            case UNESCAPE: {
                return new EscapeOutputStream(this, this.term, this.session);
            }
        }
        throw new NutsUnsupportedEnumException(this.session, (Enum)other);
    }
}

