/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text;

import java.io.IOException;
import java.io.OutputStream;
import net.thevpc.nuts.NutsOutputStreamTransparentAdapter;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.io.outputstream.OutputStreamHelper;
import net.thevpc.nuts.runtime.standalone.text.FormatOutputStreamSupport;
import net.thevpc.nuts.spi.NutsSystemTerminalBase;

public class RenderedOutputStream
extends OutputStream
implements NutsOutputStreamTransparentAdapter {
    FormatOutputStreamSupport h;
    OutputStream out;
    NutsSession session;
    NutsWorkspace ws;
    NutsSystemTerminalBase terminal;

    public RenderedOutputStream(OutputStream out, NutsSystemTerminalBase terminal, boolean filtered, NutsSession session) {
        this.out = out;
        this.session = session;
        this.ws = session.getWorkspace();
        this.terminal = terminal;
        this.h = new FormatOutputStreamSupport(new OutputStreamHelper(out, session), session, terminal, filtered);
    }

    public NutsSystemTerminalBase getTerminal() {
        return this.terminal;
    }

    public OutputStream baseOutputStream() {
        return this.out;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.h.processBytes(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.h.processByte(b);
    }

    @Override
    public void flush() throws IOException {
        this.h.flush();
        super.flush();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{h=" + this.h + "o=" + this.out + '}';
    }

    @Override
    public void close() throws IOException {
        try (OutputStream ostream = this.out;){
            this.flush();
        }
    }
}

