/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text;

import java.io.OutputStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUnsupportedEnumException;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.io.outputstream.BaseTransparentFilterOutputStream;
import net.thevpc.nuts.runtime.standalone.io.terminal.NutsTerminalModeOp;
import net.thevpc.nuts.runtime.standalone.text.EscapeOutputStream;
import net.thevpc.nuts.runtime.standalone.text.ExtendedFormatAware;
import net.thevpc.nuts.runtime.standalone.text.FilterFormatOutputStream;
import net.thevpc.nuts.runtime.standalone.text.FormatOutputStream;
import net.thevpc.nuts.runtime.standalone.text.UnescapeOutputStream;
import net.thevpc.nuts.spi.NutsSystemTerminalBase;

public class RawOutputStream
extends BaseTransparentFilterOutputStream
implements ExtendedFormatAware {
    private NutsSession session;
    private NutsWorkspace ws;
    private NutsSystemTerminalBase term;

    public RawOutputStream(OutputStream out, NutsSystemTerminalBase term, NutsSession session) {
        super(out);
        this.session = session;
        this.term = term;
        this.ws = session.getWorkspace();
    }

    @Override
    public NutsTerminalModeOp getModeOp() {
        return NutsTerminalModeOp.NOP;
    }

    @Override
    public ExtendedFormatAware convert(NutsTerminalModeOp other) {
        if (other == null || other == this.getModeOp()) {
            return this;
        }
        switch (other) {
            case NOP: {
                return this;
            }
            case FORMAT: {
                return new FormatOutputStream(this.out, this.term, this.session);
            }
            case FILTER: {
                return new FilterFormatOutputStream(this.out, this.term, this.session);
            }
            case ESCAPE: {
                return new EscapeOutputStream(this, this.term, this.session);
            }
            case UNESCAPE: {
                return new UnescapeOutputStream(this, this.term, this.session);
            }
        }
        throw new NutsUnsupportedEnumException(this.session, (Enum)other);
    }
}

