/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextList;
import net.thevpc.nuts.NutsTextNumbering;
import net.thevpc.nuts.NutsTextPlain;
import net.thevpc.nuts.NutsTextStyles;
import net.thevpc.nuts.NutsTextType;
import net.thevpc.nuts.NutsTextWriteConfiguration;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.runtime.standalone.text.AbstractNutsTextNodeWriter;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNutsTextAnchor;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNutsTextCode;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNutsTextCommand;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNutsTextLink;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNutsTextStyled;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNutsTextTitle;

public class NutsTextNodeWriterStringer
extends AbstractNutsTextNodeWriter {
    private OutputStream out;
    private NutsSession session;

    public NutsTextNodeWriterStringer(OutputStream out, NutsSession session) {
        this.out = out;
        this.session = session;
    }

    public static String toString(NutsText n, NutsSession ws) {
        if (n == null) {
            return "";
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        new NutsTextNodeWriterStringer(bos, ws).writeNode(n, new NutsTextWriteConfiguration());
        return bos.toString();
    }

    @Override
    public void writeNode(NutsText node) {
        this.writeNode(node, this.getWriteConfiguration());
    }

    @Override
    public void writeRaw(byte[] buf, int off, int len) {
        this.writeRaw(new String(buf, off, len));
    }

    @Override
    public void writeRaw(char[] buf, int off, int len) {
        this.writeRaw(new String(buf, off, len));
    }

    @Override
    public boolean flush() {
        try {
            this.out.flush();
        }
        catch (IOException ex) {
            throw new NutsIOException(this.session, (Throwable)ex);
        }
        return true;
    }

    public void writeNode(NutsText node, NutsTextWriteConfiguration ctx) {
        if (node == null) {
            return;
        }
        if (ctx == null) {
            ctx = new NutsTextWriteConfiguration();
        }
        switch (node.getType()) {
            case PLAIN: {
                NutsTextPlain p = (NutsTextPlain)node;
                if (ctx.isFiltered()) {
                    this.writeRaw(p.getText());
                    break;
                }
                this.writeEscaped(p.getText());
                break;
            }
            case LIST: {
                NutsTextList s = (NutsTextList)node;
                for (NutsText n : s) {
                    this.writeNode(n, ctx);
                }
                break;
            }
            case STYLED: {
                DefaultNutsTextStyled s = (DefaultNutsTextStyled)node;
                if (ctx.isFiltered()) {
                    this.writeNode(s.getChild(), ctx);
                    break;
                }
                NutsTextStyles styles = s.getStyles();
                if (s.getChild().getType() == NutsTextType.PLAIN) {
                    this.writeRaw("##:" + styles.id() + ":");
                    this.writeNode(s.getChild(), ctx);
                    this.writeRaw("##");
                    this.writeRaw('\u001e');
                    break;
                }
                this.writeRaw("##{" + styles.id() + ":");
                this.writeNode(s.getChild(), ctx);
                this.writeRaw("}##");
                this.writeRaw('\u001e');
                break;
            }
            case TITLE: {
                DefaultNutsTextTitle s = (DefaultNutsTextTitle)node;
                if (!ctx.isFiltered()) {
                    this.writeRaw(s.getStart());
                }
                if (ctx.isTitleNumberEnabled()) {
                    NutsTextNumbering seq = ctx.getTitleNumberSequence();
                    if (seq == null) {
                        seq = NutsTexts.of((NutsSession)this.session).ofNumbering();
                        ctx.setTitleNumberSequence(seq);
                    }
                    NutsTextNumbering a = seq.newLevel(s.getTextStyleCode().length());
                    String ts = a.toString() + " ";
                    this.writeRaw(ts);
                }
                this.writeNode(s.getChild(), ctx);
                break;
            }
            case COMMAND: {
                DefaultNutsTextCommand s = (DefaultNutsTextCommand)node;
                if (ctx.isFiltered()) break;
                this.writeRaw(s.getStart());
                this.writeEscapedSpecial(s.getCommand().getName());
                if (!NutsBlankable.isBlank((String)s.getCommand().getArgs())) {
                    this.writeEscapedSpecial(" ");
                    this.writeEscapedSpecial(s.getCommand().getArgs());
                }
                this.writeRaw(s.getEnd());
                this.writeRaw('\u001e');
                break;
            }
            case ANCHOR: {
                DefaultNutsTextAnchor s = (DefaultNutsTextAnchor)node;
                if (ctx.isFiltered()) break;
                this.writeRaw(s.getStart());
                this.writeRaw(s.getKind());
                this.writeRaw(s.getSeparator());
                this.writeEscapedSpecial(s.getValue());
                this.writeRaw(s.getEnd());
                this.writeRaw('\u001e');
                break;
            }
            case LINK: {
                DefaultNutsTextLink s = (DefaultNutsTextLink)node;
                if (!ctx.isFiltered()) {
                    this.writeRaw(s.getStart());
                    this.writeRaw(s.getKind());
                    this.writeRaw(s.getSeparator());
                    this.writeNode(s.getChild());
                    this.writeRaw(s.getEnd());
                    this.writeRaw('\u001e');
                    break;
                }
                this.writeNode(s.getChild());
                break;
            }
            case CODE: {
                DefaultNutsTextCode s = (DefaultNutsTextCode)node;
                if (!ctx.isFiltered()) {
                    this.writeRaw(s.getStart());
                    this.writeRaw(s.getKind());
                    this.writeRaw(s.getSeparator());
                    this.writeEscapedSpecial(s.getText());
                    this.writeRaw(s.getEnd());
                    this.writeRaw('\u001e');
                    break;
                }
                this.writeRaw(s.getText());
                break;
            }
            default: {
                throw new UnsupportedOperationException("invalid node type : " + node.getClass().getSimpleName());
            }
        }
    }

    public final void writeEscapedSpecial(String rawString) {
        char[] cc = rawString.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < cc.length; ++i) {
            if (i <= cc.length - 3 && cc[i] == '`' && cc[i + 1] == '`' && cc[i + 2] == '`') {
                sb.append('\\');
            }
            sb.append(cc[i]);
        }
        this.writeRaw(sb.toString());
    }

    public final void writeEscaped(String rawString) {
        char[] cc = rawString.toCharArray();
        StringBuilder sb = new StringBuilder();
        block5: for (int i = 0; i < cc.length; ++i) {
            switch (cc[i]) {
                case '\u001e': 
                case '\\': {
                    sb.append('\\');
                    sb.append(cc[i]);
                    continue block5;
                }
                case '`': {
                    if (i < cc.length - 3) {
                        if (cc[i] == '`' && cc[i + 1] == '`' && cc[i + 2] == '`') {
                            sb.append('\\');
                            sb.append(cc[i]);
                            continue block5;
                        }
                        sb.append(cc[i]);
                        continue block5;
                    }
                    if (i < cc.length - 1) {
                        if (cc[i] == '`' && cc[i + 1] == '`') {
                            sb.append('\\');
                            sb.append(cc[i]);
                            continue block5;
                        }
                        sb.append(cc[i]);
                        continue block5;
                    }
                    sb.append('\\');
                    sb.append(cc[i]);
                    continue block5;
                }
                case '#': {
                    if (i < cc.length - 1 && cc[i + 1] != cc[i]) {
                        sb.append(cc[i]);
                        continue block5;
                    }
                    sb.append('\\');
                    sb.append(cc[i]);
                    continue block5;
                }
                default: {
                    sb.append(cc[i]);
                }
            }
        }
        this.writeRaw(sb.toString());
    }

    public final void writeRaw(char rawChar) {
        this.writeRaw(String.valueOf(rawChar));
    }

    public final void writeRaw(String rawString) {
        try {
            this.out.write(rawString.getBytes());
        }
        catch (IOException ex) {
            throw new NutsIOException(this.session, (Throwable)ex);
        }
    }

    private void writeStyledStart(NutsTextStyles styles, boolean complex) {
        StringBuilder sb = new StringBuilder();
        if (complex) {
            sb.append("##{");
        } else {
            sb.append("##:");
        }
        sb.append(styles.id());
        sb.append(":");
        this.writeRaw(sb.toString());
    }
}

