/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text;

import java.io.OutputStream;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextCode;
import net.thevpc.nuts.NutsTextLink;
import net.thevpc.nuts.NutsTextList;
import net.thevpc.nuts.NutsTextNumbering;
import net.thevpc.nuts.NutsTextPlain;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTextStyles;
import net.thevpc.nuts.NutsTextWriteConfiguration;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.runtime.standalone.io.outputstream.OutputHelper;
import net.thevpc.nuts.runtime.standalone.io.outputstream.OutputStreamHelper;
import net.thevpc.nuts.runtime.standalone.io.printstream.NutsPrintStreamHelper;
import net.thevpc.nuts.runtime.standalone.text.AbstractNutsTextNodeWriter;
import net.thevpc.nuts.runtime.standalone.text.DefaultNutsTexts;
import net.thevpc.nuts.runtime.standalone.text.RenderedRawStream;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNutsTextCommand;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNutsTextStyled;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNutsTextTitle;
import net.thevpc.nuts.spi.NutsSystemTerminalBase;

public class NutsTextNodeWriterRenderer
extends AbstractNutsTextNodeWriter {
    private byte[] buffer = new byte[1024];
    private int bufferSize = 0;
    private boolean enableBuffering = false;
    private byte[] later = null;
    private OutputHelper rawOutput;
    private RenderedRawStream renderedRawStream = new RenderedRawStream(){

        @Override
        public OutputHelper baseOutput() {
            return NutsTextNodeWriterRenderer.this.rawOutput;
        }

        @Override
        public void writeRaw(byte[] buf, int off, int len) {
            NutsTextNodeWriterRenderer.this.writeRaw(new String(buf, off, len));
        }

        @Override
        public void writeLater(byte[] buf) {
            NutsTextNodeWriterRenderer.this.writeLater(buf);
        }
    };
    private NutsSession session;
    private NutsSystemTerminalBase term;

    public NutsTextNodeWriterRenderer(NutsPrintStream rawOutput, NutsSession session) {
        this(new NutsPrintStreamHelper(rawOutput), session, rawOutput.getTerminal());
    }

    public NutsTextNodeWriterRenderer(OutputStream rawOutput, NutsSession session, NutsSystemTerminalBase term) {
        this(new OutputStreamHelper(rawOutput, session), session, term);
    }

    public NutsTextNodeWriterRenderer(OutputHelper rawOutput, NutsSession session, NutsSystemTerminalBase term) {
        this.rawOutput = rawOutput;
        this.session = session;
        this.term = term;
    }

    @Override
    public void writeNode(NutsText node) {
        this.writeNode(node, this.getWriteConfiguration());
    }

    @Override
    public final void writeRaw(byte[] buf, int off, int len) {
        this.rawOutput.write(buf, off, len);
    }

    @Override
    public void writeRaw(char[] buf, int off, int len) {
        this.writeRaw(new String(this.buffer, off, len));
    }

    @Override
    public final boolean flush() {
        if (this.bufferSize > 0) {
            this.rawOutput.write(this.buffer, 0, this.bufferSize);
            this.bufferSize = 0;
            return true;
        }
        this.rawOutput.flush();
        return false;
    }

    public void writeNode(NutsText node, NutsTextWriteConfiguration ctx) {
        this.writeNode(NutsTextStyles.of((NutsTextStyle[])new NutsTextStyle[0]), node, ctx);
    }

    private void writeNode(NutsTextStyles formats, NutsText node, NutsTextWriteConfiguration ctx) {
        if (formats == null) {
            formats = NutsTextStyles.of((NutsTextStyle[])new NutsTextStyle[0]);
        }
        switch (node.getType()) {
            case PLAIN: {
                NutsTextPlain p = (NutsTextPlain)node;
                this.writeRaw(formats, p.getText(), ctx.isFiltered());
                break;
            }
            case LIST: {
                NutsTextList s = (NutsTextList)node;
                for (NutsText n : s) {
                    this.writeNode(formats, n, ctx);
                }
                break;
            }
            case STYLED: {
                DefaultNutsTextStyled s = (DefaultNutsTextStyled)node;
                NutsTextStyles styles = s.getStyles();
                NutsTextStyles format = NutsTexts.of((NutsSession)this.session).getTheme().toBasicStyles(styles, this.session);
                NutsTextStyles s2 = formats.append(format);
                this.writeNode(s2, s.getChild(), ctx);
                break;
            }
            case TITLE: {
                DefaultNutsTextTitle s = (DefaultNutsTextTitle)node;
                DefaultNutsTexts factory0 = (DefaultNutsTexts)NutsTexts.of((NutsSession)this.session);
                NutsTextStyles s2 = formats.append(NutsTexts.of((NutsSession)this.session).getTheme().toBasicStyles(NutsTextStyles.of((NutsTextStyle)NutsTextStyle.title((int)s.getLevel())), this.session));
                if (ctx.isTitleNumberEnabled()) {
                    NutsTextNumbering seq = ctx.getTitleNumberSequence();
                    if (seq == null) {
                        seq = NutsTexts.of((NutsSession)this.session).ofNumbering();
                        ctx.setTitleNumberSequence(seq);
                    }
                    NutsTextNumbering a = seq.newLevel(s.getLevel());
                    NutsTextList sWithTitle = factory0.ofList(new NutsText[]{NutsTexts.of((NutsSession)this.session).ofPlain(a.toString() + " "), s.getChild()});
                    this.writeNode(s2, (NutsText)sWithTitle, ctx);
                    break;
                }
                this.writeNode(s2, s.getChild(), ctx);
                break;
            }
            case COMMAND: {
                DefaultNutsTextCommand s = (DefaultNutsTextCommand)node;
                if (this.term == null || ctx.isFiltered()) break;
                this.term.run(s.getCommand(), this.session);
                break;
            }
            case ANCHOR: {
                break;
            }
            case LINK: {
                DefaultNutsTexts factory0 = (DefaultNutsTexts)NutsTexts.of((NutsSession)this.session);
                this.writeNode(formats, factory0.createStyledOrPlain(((NutsTextLink)node).getChild(), NutsTextStyles.of((NutsTextStyle)NutsTextStyle.underlined()), true), ctx);
                this.writeRaw(formats, "see: " + ((NutsTextLink)node).getChild(), ctx.isFiltered());
                break;
            }
            case CODE: {
                NutsTextCode node1 = (NutsTextCode)node;
                if (ctx.isFiltered()) {
                    this.writeRaw(formats, node1.getText(), true);
                    break;
                }
                NutsText cn = node1.highlight(this.session);
                this.writeNode(formats, cn, ctx);
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported NutsTextNode type " + node.getClass().getSimpleName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeRaw(NutsTextStyles format, String rawString, boolean filterFormat) {
        if (!filterFormat && format != null) {
            if (rawString.length() > 0) {
                if (format.isPlain()) {
                    this.writeRaw(rawString);
                } else {
                    this.flush();
                    this.term.setStyles(format, this.session);
                    try {
                        this.writeRaw(rawString);
                    }
                    finally {
                        this.term.setStyles(null, this.session);
                    }
                }
            }
        } else if (rawString.length() > 0) {
            this.writeRaw(rawString);
        }
    }

    public final void writeRaw(String rawString) {
        this.flushLater();
        byte[] b = rawString.getBytes();
        if (this.enableBuffering) {
            if (b.length + this.bufferSize < this.buffer.length) {
                System.arraycopy(b, 0, this.buffer, this.bufferSize, b.length);
                this.bufferSize += b.length;
            } else {
                this.flush();
                if (b.length >= this.buffer.length) {
                    this.rawOutput.write(b, 0, b.length);
                } else {
                    System.arraycopy(b, 0, this.buffer, this.bufferSize, b.length);
                    this.bufferSize += b.length;
                }
            }
        } else {
            this.rawOutput.write(b, 0, b.length);
        }
    }

    public final void writeLater(byte[] later) {
        this.later = later;
        this.rawOutput.flush();
    }

    public final void flushLater() {
        byte[] b = this.later;
        if (b != null) {
            this.later = null;
            if (this.enableBuffering) {
                if (b.length + this.bufferSize < this.buffer.length) {
                    System.arraycopy(b, 0, this.buffer, this.bufferSize, b.length);
                    this.bufferSize += b.length;
                } else {
                    this.flush();
                    if (b.length >= this.buffer.length) {
                        this.rawOutput.write(b, 0, b.length);
                    } else {
                        System.arraycopy(b, 0, this.buffer, this.bufferSize, b.length);
                        this.bufferSize += b.length;
                    }
                }
            } else {
                this.rawOutput.write(b, 0, b.length);
                this.rawOutput.flush();
            }
        }
    }

    public String toString() {
        return "Printer(" + this.rawOutput + (this.later != null ? ";withLater" : "") + ")";
    }
}

