/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text;

import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextList;
import net.thevpc.nuts.NutsTextNumbering;
import net.thevpc.nuts.NutsTextPlain;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTextStyles;
import net.thevpc.nuts.NutsTextWriteConfiguration;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNutsTextAnchor;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNutsTextCode;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNutsTextLink;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNutsTextStyled;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNutsTextTitle;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;

public class NutsTextNodeWriterRaw {
    private final NutsSession session;
    private final List<NutsText> items = new ArrayList<NutsText>();
    private NutsTextWriteConfiguration config;

    public NutsTextNodeWriterRaw(NutsSession session) {
        this.session = session;
    }

    public NutsTextWriteConfiguration getWriteConfiguration() {
        return this.config;
    }

    public NutsTextNodeWriterRaw setWriteConfiguration(NutsTextWriteConfiguration config) {
        this.config = config;
        return this;
    }

    public List<NutsText> getItems() {
        return this.items;
    }

    public void flattenNode(NutsText node) {
        this.flattenNode(node, this.getWriteConfiguration());
    }

    public void flattenNode(NutsText node, NutsTextWriteConfiguration ctx) {
        this.flattenNode(node, ctx, null);
    }

    private void flattenNode(NutsText node, NutsTextWriteConfiguration ctx, NutsTextStyles style) {
        if (node == null) {
            return;
        }
        if (ctx == null) {
            ctx = new NutsTextWriteConfiguration();
        }
        switch (node.getType()) {
            case PLAIN: {
                NutsTextPlain p = (NutsTextPlain)node;
                String text = p.getText();
                for (String line : CoreStringUtils.splitOnNewlines(text)) {
                    boolean newline;
                    boolean bl = newline = line.startsWith("\n") || line.startsWith("\r");
                    if (newline || ctx.isFiltered() || style == null || style.isPlain()) {
                        this.items.add((NutsText)NutsTexts.of((NutsSession)this.session).ofPlain(line));
                        continue;
                    }
                    this.items.add((NutsText)NutsTexts.of((NutsSession)this.session).ofStyled(line, style));
                }
                break;
            }
            case LIST: {
                NutsTextList s = (NutsTextList)node;
                for (NutsText n : s) {
                    this.flattenNode(n, ctx, style);
                }
                break;
            }
            case STYLED: {
                DefaultNutsTextStyled s = (DefaultNutsTextStyled)node;
                if (ctx.isFiltered()) {
                    this.flattenNode(s.getChild(), ctx, style);
                    break;
                }
                NutsTextStyles ss = s.getStyles();
                style = style == null ? ss : style.append(ss);
                this.flattenNode(s.getChild(), ctx, style);
                break;
            }
            case TITLE: {
                DefaultNutsTextTitle s = (DefaultNutsTextTitle)node;
                if (ctx.isTitleNumberEnabled()) {
                    NutsTextNumbering seq = ctx.getTitleNumberSequence();
                    if (seq == null) {
                        seq = NutsTexts.of((NutsSession)this.session).ofNumbering();
                        ctx.setTitleNumberSequence(seq);
                    }
                    NutsTextNumbering a = seq.newLevel(s.getTextStyleCode().length());
                    String ts = a.toString() + " ";
                    this.flattenNode((NutsText)NutsTexts.of((NutsSession)this.session).ofPlain(ts), ctx, NutsTextStyles.of((NutsTextStyle)NutsTextStyle.title((int)s.getLevel())));
                }
                this.flattenNode(s.getChild(), ctx, NutsTextStyles.of((NutsTextStyle)NutsTextStyle.title((int)s.getLevel())));
                break;
            }
            case COMMAND: {
                break;
            }
            case ANCHOR: {
                DefaultNutsTextAnchor s = (DefaultNutsTextAnchor)node;
                break;
            }
            case LINK: {
                DefaultNutsTextLink s = (DefaultNutsTextLink)node;
                if (!ctx.isFiltered()) {
                    this.flattenNode(s.getChild(), ctx, NutsTextStyles.of((NutsTextStyle)NutsTextStyle.primary1()));
                    break;
                }
                this.flattenNode(s.getChild(), ctx, style);
                break;
            }
            case CODE: {
                DefaultNutsTextCode s = (DefaultNutsTextCode)node;
                if (!ctx.isFiltered()) {
                    this.flattenNode(s.highlight(this.session), ctx, null);
                    break;
                }
                this.flattenNode((NutsText)NutsTexts.of((NutsSession)this.session).ofPlain(s.getText()), ctx, style);
                break;
            }
            default: {
                throw new UnsupportedOperationException("invalid node type : " + node.getClass().getSimpleName());
            }
        }
    }
}

