/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text;

import java.io.Reader;
import java.io.StringReader;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextBuilder;
import net.thevpc.nuts.NutsTexts;

public class NutsImmutableString
implements NutsString {
    private final String value;
    private final transient NutsSession session;

    public NutsImmutableString(NutsSession session, String value) {
        this.session = session;
        this.value = value == null ? "" : value;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NutsImmutableString that = (NutsImmutableString)o;
        return this.value.equals(that.value);
    }

    public String toString() {
        return this.value;
    }

    public NutsImmutableString immutable() {
        return this;
    }

    public String filteredText() {
        return NutsTexts.of((NutsSession)this.session).parser().filterText(this.value);
    }

    public int textLength() {
        return this.filteredText().length();
    }

    public NutsText toText() {
        return NutsTexts.of((NutsSession)this.session).parser().parse((Reader)new StringReader(this.value));
    }

    public boolean isEmpty() {
        return this.textLength() == 0;
    }

    public NutsTextBuilder builder() {
        return NutsTexts.of((NutsSession)this.session).builder().append((Object)this);
    }

    public boolean isBlank() {
        return NutsBlankable.isBlank((String)this.filteredText());
    }
}

