/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text;

import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextParser;
import net.thevpc.nuts.NutsTextVisitor;
import net.thevpc.nuts.NutsTextWriteConfiguration;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.io.outputstream.OutputHelper;
import net.thevpc.nuts.runtime.standalone.text.NutsTextNodeWriter;
import net.thevpc.nuts.runtime.standalone.text.NutsTextNodeWriterRenderer;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNutsTextNodeParser;
import net.thevpc.nuts.spi.NutsSystemTerminalBase;

public class FormatOutputStreamSupport {
    private NutsTextNodeWriter nodeWriter;
    private NutsTextParser parser;
    private boolean formatEnabled = true;
    private NutsSession session;
    private NutsWorkspace ws;
    private NutsTextWriteConfiguration writeConfiguration = new NutsTextWriteConfiguration();
    private NutsTextVisitor nutsTextNodeVisitor = node -> this.nodeWriter.writeNode(node);

    public FormatOutputStreamSupport() {
    }

    public FormatOutputStreamSupport(OutputHelper rawOutput, NutsSession session, NutsSystemTerminalBase term, boolean filtered) {
        this.session = session;
        this.ws = session.getWorkspace();
        this.parser = new DefaultNutsTextNodeParser(session);
        this.nodeWriter = new NutsTextNodeWriterRenderer(rawOutput, session, term).setWriteConfiguration(this.writeConfiguration.setFiltered(false));
        this.writeConfiguration.setFiltered(filtered);
    }

    public NutsTextParser getParser() {
        return this.parser;
    }

    public FormatOutputStreamSupport setParser(NutsTextParser parser) {
        this.parser = parser == null ? new DefaultNutsTextNodeParser(this.session) : parser;
        return this;
    }

    public boolean isFormatEnabled() {
        return this.formatEnabled;
    }

    public FormatOutputStreamSupport setFormatEnabled(boolean formatEnabled) {
        this.formatEnabled = formatEnabled;
        this.writeConfiguration.setFiltered(!formatEnabled);
        return this;
    }

    public void processByte(int oneByte) {
        this.processBytes(new byte[]{(byte)oneByte}, 0, 1);
    }

    public void processBytes(byte[] buf, int off, int len) {
        if (!this.isFormatEnabled()) {
            this.nodeWriter.writeRaw(buf, off, len);
        } else {
            this.parser.parseIncremental(buf, off, len, new NutsTextVisitor(){

                public void visit(NutsText node) {
                    FormatOutputStreamSupport.this.nutsTextNodeVisitor.visit(node);
                }
            });
        }
    }

    public void processChars(char[] buf, int off, int len) {
        if (!this.isFormatEnabled()) {
            this.nodeWriter.writeRaw(buf, off, len);
        } else {
            this.parser.parseIncremental(buf, off, len, new NutsTextVisitor(){

                public void visit(NutsText node) {
                    FormatOutputStreamSupport.this.nutsTextNodeVisitor.visit(node);
                }
            });
        }
    }

    public void reset() {
        this.flush();
    }

    public void flush() {
        this.nodeWriter.flush();
        this.parser.parseRemaining(this.nutsTextNodeVisitor);
        this.nodeWriter.flush();
    }

    public boolean isIncomplete() {
        return this.parser.isIncomplete();
    }

    public String toString() {
        return "FormatOutputStreamSupport(" + this.parser.toString() + ";" + this.nodeWriter + ")";
    }
}

