/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text;

import java.io.OutputStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUnsupportedEnumException;
import net.thevpc.nuts.runtime.standalone.io.terminal.NutsTerminalModeOp;
import net.thevpc.nuts.runtime.standalone.text.EscapeOutputStream;
import net.thevpc.nuts.runtime.standalone.text.ExtendedFormatAware;
import net.thevpc.nuts.runtime.standalone.text.FormatOutputStream;
import net.thevpc.nuts.runtime.standalone.text.RawOutputStream;
import net.thevpc.nuts.runtime.standalone.text.RenderedOutputStream;
import net.thevpc.nuts.runtime.standalone.text.UnescapeOutputStream;
import net.thevpc.nuts.spi.NutsSystemTerminalBase;

public class FilterFormatOutputStream
extends RenderedOutputStream
implements ExtendedFormatAware {
    public FilterFormatOutputStream(OutputStream out, NutsSystemTerminalBase term, NutsSession session) {
        super(out, term, true, session);
    }

    @Override
    public NutsTerminalModeOp getModeOp() {
        return NutsTerminalModeOp.FILTER;
    }

    @Override
    public ExtendedFormatAware convert(NutsTerminalModeOp other) {
        if (other == null || other == this.getModeOp()) {
            return this;
        }
        switch (other) {
            case NOP: {
                if (this.out instanceof ExtendedFormatAware) {
                    NutsTerminalModeOp m = ((ExtendedFormatAware)((Object)this.out)).getModeOp();
                    return (ExtendedFormatAware)((Object)this.out);
                }
                return new RawOutputStream(this.out, this.getTerminal(), this.session);
            }
            case FORMAT: {
                return new FormatOutputStream(this.out, this.getTerminal(), this.session);
            }
            case FILTER: {
                return this;
            }
            case ESCAPE: {
                return new EscapeOutputStream(this, this.getTerminal(), this.session);
            }
            case UNESCAPE: {
                return new UnescapeOutputStream(this, this.getTerminal(), this.session);
            }
        }
        throw new NutsUnsupportedEnumException(this.session, (Enum)other);
    }
}

