/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Locale;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsUnsupportedEnumException;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.io.terminal.NutsTerminalModeOp;
import net.thevpc.nuts.runtime.standalone.text.EscapeOutputStream;
import net.thevpc.nuts.runtime.standalone.text.ExtendedFormatAware;
import net.thevpc.nuts.runtime.standalone.text.FilterFormatOutputStream;
import net.thevpc.nuts.runtime.standalone.text.FormatOutputStream;
import net.thevpc.nuts.runtime.standalone.text.SimpleWriterOutputStream;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsSessionAware;
import net.thevpc.nuts.spi.NutsSystemTerminalBase;

public class ExtendedFormatAwarePrintWriter
extends PrintWriter
implements ExtendedFormatAware,
NutsSessionAware {
    private final NutsWorkspace ws;
    private NutsSession session;
    private final NutsSystemTerminalBase term;
    private Object base = null;

    public ExtendedFormatAwarePrintWriter(Writer out, NutsSystemTerminalBase term, NutsSession session) {
        super(out);
        this.base = out;
        this.session = session;
        this.term = term;
        this.ws = session.getWorkspace();
    }

    public ExtendedFormatAwarePrintWriter(Writer out, boolean autoFlush, NutsSystemTerminalBase term, NutsSession session) {
        super(out, autoFlush);
        this.base = out;
        this.session = session;
        this.term = term;
        this.ws = session.getWorkspace();
    }

    public ExtendedFormatAwarePrintWriter(OutputStream out, NutsSystemTerminalBase term, NutsSession session) {
        super(out);
        this.base = out;
        this.session = session;
        this.term = term;
        this.ws = session.getWorkspace();
    }

    public ExtendedFormatAwarePrintWriter(OutputStream out, boolean autoFlush, NutsSystemTerminalBase term, NutsSession session) {
        super(out, autoFlush);
        this.base = out;
        this.session = session;
        this.term = term;
        this.ws = session.getWorkspace();
    }

    public void setSession(NutsSession session) {
        this.session = NutsWorkspaceUtils.bindSession(this.ws, session);
    }

    @Override
    public NutsTerminalModeOp getModeOp() {
        if (this.base instanceof ExtendedFormatAware) {
            return ((ExtendedFormatAware)this.base).getModeOp();
        }
        return NutsTerminalModeOp.NOP;
    }

    @Override
    public ExtendedFormatAware convert(NutsTerminalModeOp other) {
        if (other == null || other == this.getModeOp()) {
            return this;
        }
        if (this.base instanceof ExtendedFormatAware) {
            return ((ExtendedFormatAware)this.base).convert(other);
        }
        switch (other) {
            case NOP: {
                return this;
            }
            case FORMAT: {
                return new FormatOutputStream(new SimpleWriterOutputStream(this, this.term, this.session), this.term, this.session);
            }
            case FILTER: {
                return new FilterFormatOutputStream(new SimpleWriterOutputStream(this, this.term, this.session), this.term, this.session);
            }
            case ESCAPE: {
                return new EscapeOutputStream(new SimpleWriterOutputStream(this, this.term, this.session), this.term, this.session);
            }
            case UNESCAPE: {
                return new EscapeOutputStream(new SimpleWriterOutputStream(this, this.term, this.session), this.term, this.session);
            }
        }
        throw new NutsUnsupportedEnumException(this.session, (Enum)other);
    }

    @Override
    public void flush() {
        super.flush();
    }

    @Override
    public PrintWriter format(String format, Object ... args) {
        return this.format(null, format, args);
    }

    @Override
    public ExtendedFormatAwarePrintWriter format(Locale l, String format, Object ... args) {
        if (l == null) {
            this.print(NutsTexts.of((NutsSession)this.session).setSession(this.session).toText((Object)NutsMessage.cstyle((String)format, (Object[])args)));
        } else {
            NutsSession s2 = this.session.copy().setLocale(l.toString());
            this.print(NutsTexts.of((NutsSession)s2).toText((Object)NutsMessage.cstyle((String)format, (Object[])args)));
        }
        return this;
    }
}

