/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text;

import java.io.IOException;
import java.io.OutputStream;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTerminalMode;
import net.thevpc.nuts.NutsUnsupportedEnumException;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.io.outputstream.BaseTransparentFilterOutputStream;
import net.thevpc.nuts.runtime.standalone.io.terminal.NutsTerminalModeOp;
import net.thevpc.nuts.runtime.standalone.io.terminal.NutsTerminalModeOpUtils;
import net.thevpc.nuts.runtime.standalone.text.ExtendedFormatAware;
import net.thevpc.nuts.runtime.standalone.text.FormatOutputStream;
import net.thevpc.nuts.runtime.standalone.text.RawOutputStream;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNutsTextNodeParser;
import net.thevpc.nuts.spi.NutsSystemTerminalBase;

public class EscapeOutputStream
extends BaseTransparentFilterOutputStream
implements ExtendedFormatAware {
    NutsWorkspace ws;
    NutsSession session;
    NutsSystemTerminalBase term;

    public EscapeOutputStream(OutputStream out, NutsSystemTerminalBase term, NutsSession session) {
        super(out);
        this.session = session;
        this.term = term;
        this.ws = session.getWorkspace();
        NutsTerminalModeOp t = NutsTerminalModeOpUtils.resolveNutsTerminalModeOp(out);
        if (t.in() != NutsTerminalMode.FORMATTED && t.in() != NutsTerminalMode.FILTERED) {
            throw new NutsIllegalArgumentException(session, NutsMessage.plain((String)"illegal Formatted"));
        }
    }

    public OutputStream getOut() {
        return this.out;
    }

    @Override
    public NutsTerminalModeOp getModeOp() {
        return NutsTerminalModeOp.ESCAPE;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(DefaultNutsTextNodeParser.escapeText0(Character.toString((char)b)).getBytes());
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        byte[] bytes = DefaultNutsTextNodeParser.escapeText0(new String(b, off, len)).getBytes();
        this.out.write(bytes, 0, bytes.length);
    }

    @Override
    public ExtendedFormatAware convert(NutsTerminalModeOp other) {
        if (other == null || other == this.getModeOp()) {
            return this;
        }
        switch (other) {
            case NOP: {
                if (this.out instanceof ExtendedFormatAware) {
                    return ((ExtendedFormatAware)((Object)this.out)).convert(NutsTerminalModeOp.NOP);
                }
                return new RawOutputStream(this.out, this.term, this.session);
            }
            case FORMAT: {
                if (this.out instanceof ExtendedFormatAware) {
                    return ((ExtendedFormatAware)((Object)this.out)).convert(NutsTerminalModeOp.FORMAT);
                }
                return new FormatOutputStream(this.out, this.term, this.session);
            }
            case FILTER: {
                if (this.out instanceof ExtendedFormatAware) {
                    return ((ExtendedFormatAware)((Object)this.out)).convert(NutsTerminalModeOp.FILTER);
                }
                return this;
            }
            case ESCAPE: {
                return this;
            }
            case UNESCAPE: {
                return (ExtendedFormatAware)((Object)this.out);
            }
        }
        throw new NutsUnsupportedEnumException(this.session, (Enum)other);
    }
}

