/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Formatter;
import java.util.Locale;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCodeHighlighter;
import net.thevpc.nuts.NutsEnum;
import net.thevpc.nuts.NutsFormattable;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStreamMetadata;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTerminalCommand;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextAnchor;
import net.thevpc.nuts.NutsTextBuilder;
import net.thevpc.nuts.NutsTextCode;
import net.thevpc.nuts.NutsTextCommand;
import net.thevpc.nuts.NutsTextFormatStyle;
import net.thevpc.nuts.NutsTextFormatTheme;
import net.thevpc.nuts.NutsTextLink;
import net.thevpc.nuts.NutsTextList;
import net.thevpc.nuts.NutsTextNumbering;
import net.thevpc.nuts.NutsTextParser;
import net.thevpc.nuts.NutsTextPlain;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTextStyleType;
import net.thevpc.nuts.NutsTextStyled;
import net.thevpc.nuts.NutsTextStyles;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsUnsupportedEnumException;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.text.DefaultNutsTextManagerModel;
import net.thevpc.nuts.runtime.standalone.text.DefaultNutsTextNodeBuilder;
import net.thevpc.nuts.runtime.standalone.text.DefaultNutsTitleNumberSequence;
import net.thevpc.nuts.runtime.standalone.text.highlighter.CustomStyleCodeHighlighter;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNutsTextAnchor;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNutsTextCode;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNutsTextCommand;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNutsTextLink;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNutsTextList;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNutsTextNodeParser;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNutsTextPlain;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNutsTextStyled;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNutsTextTitle;
import net.thevpc.nuts.runtime.standalone.util.CoreNumberUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsTexts
implements NutsTexts {
    private final NutsWorkspace ws;
    private final DefaultNutsTextManagerModel shared;
    private NutsSession session;

    public DefaultNutsTexts(NutsSession session) {
        this.session = session;
        this.ws = session.getWorkspace();
        this.shared = NutsWorkspaceExt.of((NutsWorkspace)this.ws).getModel().textModel;
    }

    private void checkSession() {
        NutsWorkspaceUtils.checkSession(this.ws, this.getSession());
    }

    private NutsText _NutsMessage_toString(NutsMessage m) {
        Object[] params;
        this.checkSession();
        NutsTextFormatStyle style = m.getStyle();
        if (style == null) {
            style = NutsTextFormatStyle.JSTYLE;
        }
        if ((params = m.getParams()) == null) {
            params = new Object[]{};
        }
        String msg = m.getMessage();
        String sLocale = this.getSession() == null ? null : this.getSession().getLocale();
        Locale locale = NutsBlankable.isBlank((String)sLocale) ? null : new Locale(sLocale);
        Object[] args2 = new Object[params.length];
        NutsTexts txt = NutsTexts.of((NutsSession)this.getSession());
        for (int i = 0; i < args2.length; ++i) {
            Object a = params[i];
            args2[i] = a == null ? null : (a instanceof Number || a instanceof Date || a instanceof Temporal ? a : txt.toText(a).toString());
        }
        switch (style) {
            case CSTYLE: {
                StringBuilder sb = new StringBuilder();
                new Formatter(sb, locale).format(msg, args2);
                return txt.parse(sb.toString());
            }
            case JSTYLE: {
                return txt.parse(MessageFormat.format(msg, args2));
            }
            case PLAIN: {
                return txt.ofPlain(msg);
            }
            case FORMATTED: {
                return txt.parse(msg);
            }
        }
        throw new NutsUnsupportedEnumException(this.getSession(), (Enum)style);
    }

    public NutsText title(NutsText t, int level) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            sb.append("#");
        }
        sb.append(")");
        return this.createTitle(sb.toString(), level, t, true);
    }

    public NutsText fg(String t, int level) {
        return this.fg((NutsText)this.ofPlain(t), level);
    }

    public NutsText fg(NutsText t, int level) {
        NutsTextStyle textStyle = NutsTextStyle.primary((int)level);
        return this.createStyled("##:p" + level + ":", "##", t, NutsTextStyles.of((NutsTextStyle)textStyle), true);
    }

    public NutsSession getSession() {
        return this.session;
    }

    public DefaultNutsTexts setSession(NutsSession session) {
        this.session = NutsWorkspaceUtils.bindSession(this.ws, session);
        return this;
    }

    public NutsTextBuilder builder() {
        this.checkSession();
        return new DefaultNutsTextNodeBuilder(this.getSession());
    }

    public NutsText ofBlank() {
        return this.ofPlain("");
    }

    public NutsText toText(Object t) {
        this.checkSession();
        if (t == null) {
            return this.ofBlank();
        }
        if (t instanceof NutsText) {
            return (NutsText)t;
        }
        if (t instanceof NutsFormattable) {
            return ((NutsFormattable)t).formatter().setSession(this.getSession()).setNtf(true).format().toText();
        }
        if (t instanceof NutsMessage) {
            return this._NutsMessage_toString((NutsMessage)t);
        }
        if (t instanceof NutsString) {
            return ((NutsString)t).toText();
        }
        if (t instanceof InputStream) {
            String q = NutsStreamMetadata.of((Object)((InputStream)t)).getName();
            if (q == null) {
                q = t.toString();
            }
            return this.ofStyled(q, NutsTextStyle.path());
        }
        if (t instanceof OutputStream || t instanceof Writer) {
            return this.ofStyled(t.toString(), NutsTextStyle.path());
        }
        if (t instanceof Enum) {
            if (t instanceof NutsEnum) {
                return this.ofStyled(((NutsEnum)t).id(), NutsTextStyle.option());
            }
            return this.ofStyled(((Enum)t).name(), NutsTextStyle.option());
        }
        if (t instanceof Number) {
            return this.ofStyled(t.toString(), NutsTextStyle.number());
        }
        if (t instanceof Date || t instanceof Temporal) {
            return this.ofStyled(t.toString(), NutsTextStyle.date());
        }
        if (t instanceof Boolean) {
            return this.ofStyled(t.toString(), NutsTextStyle.bool());
        }
        if (t instanceof Path || t instanceof File || t instanceof URL) {
            return this.ofStyled(t.toString(), NutsTextStyle.path());
        }
        if (t instanceof Throwable) {
            return this.applyStyles(this.toText(CoreStringUtils.exceptionToMessage((Throwable)t)), NutsTextStyle.error());
        }
        if (t instanceof NutsEnum) {
            return this.ofStyled(((NutsEnum)t).id(), NutsTextStyle.option());
        }
        return this.ofPlain(t.toString());
    }

    public NutsTextPlain ofPlain(String t) {
        this.checkSession();
        return new DefaultNutsTextPlain(this.getSession(), t);
    }

    public NutsTextList ofList(NutsText ... nodes) {
        return this.ofList(Arrays.asList(nodes));
    }

    public NutsTextList ofList(Collection<NutsText> nodes) {
        this.checkSession();
        if (nodes == null) {
            return new DefaultNutsTextList(this.getSession(), new NutsText[0]);
        }
        return new DefaultNutsTextList(this.getSession(), nodes.toArray(new NutsText[0]));
    }

    public NutsTextStyled ofStyled(String other, NutsTextStyles styles) {
        return this.ofStyled((NutsText)this.ofPlain(other), styles);
    }

    public NutsTextStyled ofStyled(NutsString other, NutsTextStyles styles) {
        this.checkSession();
        return this.ofStyled(other.toText(), styles);
    }

    public NutsTextStyled ofStyled(NutsText other, NutsTextStyles styles) {
        return this.createStyled(other, styles, true);
    }

    public NutsText applyStyles(NutsText other, NutsTextStyles styles) {
        return this.createStyledOrPlain(other, styles, true);
    }

    public NutsText applyStyles(NutsText other, NutsTextStyle ... styles) {
        return this.applyStyles(other, NutsTextStyles.of((NutsTextStyle[])styles));
    }

    public NutsText applyStyles(NutsString other, NutsTextStyles styles) {
        return this.createStyledOrPlain(other.toText(), styles, true);
    }

    public NutsText applyStyles(NutsString other, NutsTextStyle ... styles) {
        return this.applyStyles(other, NutsTextStyles.of((NutsTextStyle[])styles));
    }

    public NutsTextStyled ofStyled(String other, NutsTextStyle styles) {
        return this.ofStyled((NutsText)this.ofPlain(other), styles);
    }

    public NutsTextStyled ofStyled(NutsString other, NutsTextStyle styles) {
        return this.ofStyled(other.toText(), styles);
    }

    public NutsTextStyled ofStyled(NutsText other, NutsTextStyle styles) {
        return this.createStyled(other, NutsTextStyles.of((NutsTextStyle)styles), true);
    }

    public NutsTextCommand ofCommand(NutsTerminalCommand command) {
        this.checkSession();
        return new DefaultNutsTextCommand(this.getSession(), "```!", command, "", "```");
    }

    public NutsTextCode ofCode(String lang, String text) {
        this.checkSession();
        if (text == null) {
            text = "";
        }
        DefaultNutsTexts factory0 = (DefaultNutsTexts)NutsTexts.of((NutsSession)this.session);
        if (text.indexOf(10) >= 0) {
            return factory0.createCode("```", lang, "\n", "```", text);
        }
        return factory0.createCode("```", lang, "", "```", text);
    }

    public NutsTextNumbering ofNumbering() {
        this.checkSession();
        return new DefaultNutsTitleNumberSequence("");
    }

    public NutsTextNumbering ofNumbering(String pattern) {
        this.checkSession();
        return new DefaultNutsTitleNumberSequence(pattern == null || pattern.isEmpty() ? "1.1.1.a.1" : pattern);
    }

    public NutsTextAnchor ofAnchor(String anchorName) {
        return this.createAnchor("```!", "", "```", anchorName);
    }

    public NutsTextLink ofLink(NutsText value) {
        return this.createLink("```!", "", "```", value);
    }

    public NutsTextFormatTheme getTheme() {
        this.checkSession();
        return this.shared.getTheme(this.getSession());
    }

    public NutsTexts setTheme(NutsTextFormatTheme theme) {
        this.checkSession();
        this.shared.setTheme(theme, this.getSession());
        return this;
    }

    public NutsTexts setTheme(String theme) {
        this.checkSession();
        this.shared.setTheme(theme, this.getSession());
        return this;
    }

    public NutsCodeHighlighter getCodeHighlighter(String kind) {
        this.checkSession();
        return this.shared.getCodeHighlighter(kind, this.getSession());
    }

    public NutsTexts addCodeHighlighter(NutsCodeHighlighter format) {
        this.checkSession();
        this.shared.addCodeHighlighter(format, this.getSession());
        return this;
    }

    public NutsTexts removeCodeHighlighter(String id) {
        this.checkSession();
        this.shared.removeCodeHighlighter(id, this.getSession());
        return this;
    }

    public NutsCodeHighlighter[] getCodeHighlighters() {
        this.checkSession();
        return this.shared.getCodeHighlighters(this.getSession());
    }

    public NutsText parse(String t) {
        return t == null ? this.ofBlank() : this.parser().parse((Reader)new StringReader(t));
    }

    public NutsTextParser parser() {
        this.checkSession();
        return new DefaultNutsTextNodeParser(this.getSession());
    }

    public NutsText bg(String t, int level) {
        return this.bg((NutsText)this.ofPlain(t), level);
    }

    public NutsText bg(NutsText t, int variant) {
        NutsTextStyle textStyle = NutsTextStyle.primary((int)variant);
        return this.createStyled("##:s" + variant + ":", "##", t, NutsTextStyles.of((NutsTextStyle)textStyle), true);
    }

    public NutsText comments(String image) {
        return this.fg(image, 4);
    }

    public NutsText literal(String image) {
        return this.fg(image, 1);
    }

    public NutsText stringLiteral(String image) {
        return this.fg(image, 3);
    }

    public NutsText numberLiteral(String image) {
        return this.fg(image, 1);
    }

    public NutsText reservedWord(String image) {
        return this.fg(image, 1);
    }

    public NutsText annotation(String image) {
        return this.fg(image, 3);
    }

    public NutsText separator(String image) {
        return this.fg(image, 6);
    }

    public NutsText commandName(String image) {
        return this.fg(image, 1);
    }

    public NutsText subCommand1Name(String image) {
        return this.fg(image, 2);
    }

    public NutsText subCommand2Name(String image) {
        return this.fg(image, 3);
    }

    public NutsText optionName(String image) {
        return this.fg(image, 4);
    }

    public NutsText userInput(String image) {
        return this.fg(image, 8);
    }

    public NutsCodeHighlighter resolveCodeHighlighter(String kind) {
        NutsCodeHighlighter format;
        this.checkSession();
        if (kind == null) {
            kind = "";
        }
        if ((format = this.getCodeHighlighter(kind)) != null) {
            return format;
        }
        if (kind.length() > 0) {
            try {
                String cc = kind.toUpperCase();
                int x = cc.length();
                while (Character.isDigit(cc.charAt(x - 1))) {
                    --x;
                }
                if (x < cc.length()) {
                    NutsTextStyle found = NutsTextStyle.of((NutsTextStyleType)NutsTextStyleType.valueOf((String)this.expandAlias(kind.toUpperCase().substring(0, x))), (int)CoreNumberUtils.convertToInteger(kind.substring(x), 0));
                    return new CustomStyleCodeHighlighter(found, this.session);
                }
                NutsTextStyle found = NutsTextStyle.of((NutsTextStyleType)NutsTextStyleType.valueOf((String)this.expandAlias(kind.toUpperCase())));
                return new CustomStyleCodeHighlighter(found, this.session);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getCodeHighlighter("plain");
    }

    private String expandAlias(String ss) {
        switch (ss.toUpperCase()) {
            case "BOOL": {
                ss = "BOOLEAN";
                break;
            }
            case "KW": {
                ss = "KEYWORD";
            }
        }
        return ss;
    }

    public NutsText createStyledOrPlain(NutsText child, NutsTextStyles textStyles, boolean completed) {
        if (textStyles == null || textStyles.isPlain()) {
            return child;
        }
        return this.createStyled(child, textStyles, completed);
    }

    public NutsTextStyled createStyled(NutsText child, NutsTextStyles textStyles, boolean completed) {
        if (textStyles == null || textStyles.isPlain()) {
            return this.createStyled("", "", child, textStyles, completed);
        }
        return this.createStyled("##:" + textStyles.id() + ":", "##", child, textStyles, completed);
    }

    public NutsTextStyled createStyled(String start, String end, NutsText child, NutsTextStyles textStyle, boolean completed) {
        if (textStyle == null) {
            textStyle = NutsTextStyles.PLAIN;
        }
        this.checkSession();
        return new DefaultNutsTextStyled(this.getSession(), start, end, child, completed, textStyle);
    }

    public NutsTextCode createCode(String start, String kind, String separator, String end, String text) {
        this.checkSession();
        return new DefaultNutsTextCode(this.getSession(), start, kind, separator, end, text);
    }

    public NutsTextCommand createCommand(String start, NutsTerminalCommand command, String separator, String end) {
        this.checkSession();
        return new DefaultNutsTextCommand(this.getSession(), start, command, separator, end);
    }

    public NutsTextLink createLink(String start, String separator, String end, NutsText value) {
        this.checkSession();
        return new DefaultNutsTextLink(this.getSession(), start, separator, end, value);
    }

    public NutsTextAnchor createAnchor(String start, String separator, String end, String value) {
        this.checkSession();
        return new DefaultNutsTextAnchor(this.getSession(), start, separator, end, value);
    }

    public NutsText createTitle(String start, int level, NutsText child, boolean complete) {
        this.checkSession();
        return new DefaultNutsTextTitle(this.getSession(), start, level, child);
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }
}

