/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStream;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTerminalCommand;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextBuilder;
import net.thevpc.nuts.NutsTextParser;
import net.thevpc.nuts.NutsTextPlain;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTextStyleGenerator;
import net.thevpc.nuts.NutsTextStyled;
import net.thevpc.nuts.NutsTextStyles;
import net.thevpc.nuts.NutsTextType;
import net.thevpc.nuts.NutsTextWriteConfiguration;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.runtime.standalone.text.DefaultNutsTextStyleGenerator;
import net.thevpc.nuts.runtime.standalone.text.NutsImmutableString;
import net.thevpc.nuts.runtime.standalone.text.NutsTextNodeWriterRaw;
import net.thevpc.nuts.runtime.standalone.text.NutsTextNodeWriterStringer;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNutsTextNodeParser;

public class DefaultNutsTextNodeBuilder
implements NutsTextBuilder {
    private final List<NutsText> children = new ArrayList<NutsText>();
    private final NutsSession session;
    private final NutsTexts text1;
    private NutsTextWriteConfiguration writeConfiguration;
    private NutsTextStyleGenerator styleGenerator;
    private boolean flattened = true;

    public DefaultNutsTextNodeBuilder(NutsSession session) {
        this.session = session;
        this.text1 = NutsTexts.of((NutsSession)session);
    }

    public NutsTextStyleGenerator getStyleGenerator() {
        if (this.styleGenerator == null) {
            this.styleGenerator = new DefaultNutsTextStyleGenerator();
        }
        return this.styleGenerator;
    }

    public DefaultNutsTextNodeBuilder setStyleGenerator(NutsTextStyleGenerator styleGenerator) {
        this.styleGenerator = styleGenerator;
        return this;
    }

    public NutsTextWriteConfiguration getConfiguration() {
        return this.writeConfiguration;
    }

    public NutsTextBuilder setConfiguration(NutsTextWriteConfiguration writeConfiguration) {
        this.writeConfiguration = writeConfiguration;
        return this;
    }

    public NutsTextBuilder appendCommand(NutsTerminalCommand command) {
        this.append((NutsText)this.text1.ofCommand(command));
        return this;
    }

    public NutsTextBuilder appendCode(String lang, String text) {
        this.append((NutsText)this.text1.ofCode(lang, text));
        return this;
    }

    public NutsTextBuilder appendHash(Object text) {
        return this.appendHash(text, text);
    }

    public NutsTextBuilder appendRandom(Object text) {
        if (text == null) {
            return this;
        }
        return this.append(text, this.getStyleGenerator().random());
    }

    public NutsTextBuilder appendHash(Object text, Object hash) {
        if (text == null) {
            return this;
        }
        if (hash == null) {
            hash = text;
        }
        return this.append(text, this.getStyleGenerator().hash(hash));
    }

    public NutsTextBuilder append(Object text, NutsTextStyle style) {
        return this.append(text, NutsTextStyles.of((NutsTextStyle)style));
    }

    public NutsTextBuilder append(Object text, NutsTextStyles styles) {
        if (text != null) {
            if (styles.size() == 0) {
                this.append(NutsTexts.of((NutsSession)this.session).toText(text));
            } else {
                this.append(this.text1.applyStyles(NutsTexts.of((NutsSession)this.session).toText(text), styles));
            }
        }
        return this;
    }

    public NutsTextBuilder append(Object node) {
        if (node != null) {
            return this.append(NutsTexts.of((NutsSession)this.session).toText(node));
        }
        return this;
    }

    public NutsTextBuilder append(NutsText node) {
        if (node != null) {
            this.children.add(node);
            this.flattened = false;
        }
        return this;
    }

    public NutsTextBuilder appendJoined(Object separator, Collection<?> others) {
        if (others != null) {
            boolean first = true;
            for (Object other : others) {
                if (other == null) continue;
                if (first) {
                    first = false;
                } else if (separator != null) {
                    this.append(separator);
                }
                this.append(other);
            }
        }
        return this;
    }

    public NutsTextBuilder appendAll(Collection<?> others) {
        if (others != null) {
            for (Object node : others) {
                if (node == null) continue;
                this.append(node);
            }
        }
        return this;
    }

    public NutsText build() {
        if (this.children.size() == 0) {
            return this.text1.ofPlain("");
        }
        if (this.children.size() == 1) {
            return this.children.get(0);
        }
        return this.text1.ofList(this.children).simplify();
    }

    public NutsTextParser parser() {
        return new DefaultNutsTextNodeParser(this.session);
    }

    public List<NutsText> getChildren() {
        return new ArrayList<NutsText>(this.children);
    }

    public NutsText subChildren(int from, int to) {
        if (from < 0) {
            from = 0;
        }
        if (to >= this.size()) {
            to = this.size() - 1;
        }
        if (to <= from) {
            return NutsTexts.of((NutsSession)this.session).ofPlain("");
        }
        return NutsTexts.of((NutsSession)this.session).builder().appendAll(this.children.subList(from, to)).build();
    }

    public NutsText substring(int from, int to) {
        if (to <= from) {
            return NutsTexts.of((NutsSession)this.session).ofPlain("");
        }
        int firstIndex = this.ensureCut(from);
        if (firstIndex < 0) {
            return NutsTexts.of((NutsSession)this.session).ofPlain("");
        }
        int secondIndex = this.ensureCut(to);
        if (secondIndex < 0) {
            return NutsTexts.of((NutsSession)this.session).builder().appendAll(this.children.subList(firstIndex, this.children.size())).build();
        }
        return NutsTexts.of((NutsSession)this.session).builder().appendAll(this.children.subList(firstIndex, secondIndex)).build();
    }

    public NutsTextBuilder insert(int at, NutsText ... newTexts) {
        return this.replaceChildren(at, at + 1, newTexts);
    }

    public NutsTextBuilder replace(int from, int to, NutsText ... newTexts) {
        if (to <= from) {
            return this;
        }
        int firstIndex = this.ensureCut(from);
        if (firstIndex < 0) {
            return this;
        }
        int secondIndex = this.ensureCut(to);
        if (secondIndex < 0) {
            this.replaceChildren(firstIndex, this.children.size(), newTexts);
        }
        this.replaceChildren(firstIndex, secondIndex, newTexts);
        return this;
    }

    public NutsTextBuilder replaceChildren(int from, int to, NutsText ... newTexts) {
        newTexts = newTexts == null ? new NutsText[]{} : (NutsText[])Arrays.stream(newTexts).filter(x -> x != null && !x.isEmpty()).toArray(NutsText[]::new);
        if (from < to) {
            this.children.subList(from, to).clear();
            if (newTexts.length > 0) {
                this.children.addAll(from, Arrays.asList(newTexts));
            }
        }
        return this;
    }

    public int size() {
        return this.children.size();
    }

    public NutsText get(int index) {
        return this.children.get(index);
    }

    public Iterable<NutsText> items() {
        return this.children;
    }

    public NutsTextBuilder flatten() {
        if (!this.flattened) {
            NutsTextNodeWriterRaw ss = new NutsTextNodeWriterRaw(this.session);
            ss.flattenNode(this.build(), this.getConfiguration());
            List<NutsText> i = ss.getItems();
            if (i.isEmpty()) {
                return this;
            }
            this.children.clear();
            this.children.addAll(i);
            this.flattened = true;
        }
        return this;
    }

    public NutsTextBuilder removeAt(int index) {
        this.children.remove(index);
        return this;
    }

    public NutsStream<NutsTextBuilder> lines() {
        final DefaultNutsTextNodeBuilder z = (DefaultNutsTextNodeBuilder)this.copy().flatten();
        return NutsStream.of((Iterator)new Iterator<NutsTextBuilder>(){
            NutsTextBuilder n;

            @Override
            public boolean hasNext() {
                this.n = z.readLine();
                return this.n != null;
            }

            @Override
            public NutsTextBuilder next() {
                return this.n;
            }
        }, (NutsSession)this.session);
    }

    public NutsTextBuilder readLine() {
        if (this.size() == 0) {
            return null;
        }
        ArrayList<NutsText> r = new ArrayList<NutsText>();
        while (this.size() > 0) {
            NutsText t = this.get(0);
            this.removeAt(0);
            if (this.isNewLine(t)) break;
            r.add(t);
        }
        return NutsTexts.of((NutsSession)this.session).builder().appendAll(r);
    }

    private boolean isNewLine(NutsText t) {
        if (t.getType() == NutsTextType.PLAIN) {
            String txt = ((NutsTextPlain)t).getText();
            return txt.equals("\n") || txt.equals("\r\n");
        }
        return false;
    }

    public NutsTextBuilder copy() {
        DefaultNutsTextNodeBuilder c = new DefaultNutsTextNodeBuilder(this.session);
        c.appendAll(this.children);
        c.flattened = this.flattened;
        return c;
    }

    public int ensureCut(int at) {
        if (at <= 0) {
            return 0;
        }
        NutsTexts text = NutsTexts.of((NutsSession)this.session);
        int charPos = 0;
        for (int index = 0; index < this.children.size(); ++index) {
            NutsText c = this.children.get(index);
            int start = charPos;
            int len = c.textLength();
            int end = start + len;
            if (at >= start) {
                if (at == start) {
                    return index;
                }
                if (at == end) {
                    if (index + 1 < this.children.size()) {
                        return index + 1;
                    }
                    return -1;
                }
                if (at > start && at < end) {
                    List rv = c.builder().flatten().getChildren();
                    ArrayList<Object> rv2 = new ArrayList<Object>(rv.size() + 1);
                    int toReturn = -1;
                    for (int i = 0; i < rv.size(); ++i) {
                        String b;
                        String a;
                        String tp;
                        NutsTextPlain p;
                        NutsText child = (NutsText)rv.get(i);
                        start = charPos;
                        len = child.textLength();
                        end = start + len;
                        if (at < start) {
                            rv2.add(child);
                        } else if (at == start) {
                            rv2.add(child);
                            toReturn = i + index;
                        } else if (at >= end) {
                            rv2.add(child);
                        } else if (child.getType() == NutsTextType.PLAIN) {
                            p = (NutsTextPlain)child;
                            tp = p.getText();
                            a = tp.substring(0, at - start);
                            b = tp.substring(at - start);
                            rv2.add(text.ofPlain(a));
                            rv2.add(text.ofPlain(b));
                            toReturn = index + i + 1;
                        } else if (child.getType() == NutsTextType.STYLED) {
                            p = (NutsTextStyled)child;
                            tp = ((NutsTextPlain)p.getChild()).getText();
                            a = tp.substring(0, at - start);
                            b = tp.substring(at - start);
                            rv2.add(text.ofStyled(a, p.getStyles()));
                            rv2.add(text.ofStyled(b, p.getStyles()));
                            toReturn = index + i + 1;
                        }
                        charPos = end;
                    }
                    this.replaceChildren(index, index + 1, rv2.toArray(new NutsText[0]));
                    return toReturn;
                }
            }
            charPos = end;
        }
        return -1;
    }

    public NutsString immutable() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        NutsTextNodeWriterStringer ss = new NutsTextNodeWriterStringer(out, this.session);
        ss.writeNode(this.build(), this.getConfiguration());
        return new NutsImmutableString(this.session, out.toString());
    }

    public String filteredText() {
        StringBuilder sb = new StringBuilder();
        for (NutsText child : this.children) {
            sb.append(child.filteredText());
        }
        return sb.toString();
    }

    public int textLength() {
        return this.immutable().textLength();
    }

    public NutsText toText() {
        return this.build();
    }

    public boolean isEmpty() {
        return this.immutable().isEmpty();
    }

    public NutsTextBuilder builder() {
        return NutsTexts.of((NutsSession)this.session).builder().append((Object)this);
    }

    public String toString() {
        return this.immutable().toString();
    }

    public boolean isBlank() {
        return NutsBlankable.isBlank((String)this.filteredText());
    }
}

