/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCodeHighlighter;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsShellFamily;
import net.thevpc.nuts.NutsTextFormatTheme;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceOptions;
import net.thevpc.nuts.runtime.standalone.elem.DefaultNutsElementFactoryService;
import net.thevpc.nuts.runtime.standalone.elem.NutsElementFactoryService;
import net.thevpc.nuts.runtime.standalone.elem.NutsElementStreamFormat;
import net.thevpc.nuts.runtime.standalone.format.json.DefaultJsonElementFormat;
import net.thevpc.nuts.runtime.standalone.format.xml.DefaultXmlNutsElementStreamFormat;
import net.thevpc.nuts.runtime.standalone.format.yaml.SimpleYaml;
import net.thevpc.nuts.runtime.standalone.text.highlighter.CustomStyleCodeHighlighter;
import net.thevpc.nuts.runtime.standalone.text.theme.DefaultNutsTextFormatTheme;
import net.thevpc.nuts.runtime.standalone.text.theme.NutsTextFormatPropertiesTheme;
import net.thevpc.nuts.runtime.standalone.text.theme.NutsTextFormatThemeWrapper;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsDefaultSupportLevelContext;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsTextManagerModel {
    private final NutsWorkspace ws;
    private final Map<String, String> kindToHighlighter = new HashMap<String, String>();
    private final Map<String, NutsCodeHighlighter> highlighters = new HashMap<String, NutsCodeHighlighter>();
    private final Map<String, NutsCodeHighlighter> _cachedHighlighters = new HashMap<String, NutsCodeHighlighter>();
    private String styleThemeName;
    private NutsTextFormatTheme styleTheme;
    private NutsTextFormatTheme defaultTheme;
    private NutsElementFactoryService elementFactoryService;
    private NutsElementStreamFormat jsonMan;
    private NutsElementStreamFormat yamlMan;
    private NutsElementStreamFormat xmlMan;

    public DefaultNutsTextManagerModel(NutsWorkspace ws) {
        this.ws = ws;
        NutsSession session = NutsWorkspaceUtils.defaultSession(ws);
        List all = session.extensions().createAllSupported(NutsCodeHighlighter.class, null);
        for (NutsCodeHighlighter h : all) {
            this.highlighters.put(h.getId().toLowerCase(), h);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/net/thevpc/nuts/runtime/highlighter-mappings.ini")));){
            String line;
            String group = null;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.length() <= 0) continue;
                if (line.startsWith("[") && line.endsWith("]")) {
                    group = line.substring(1, line.length() - 1).trim();
                    continue;
                }
                if (group == null) continue;
                for (String s : line.split("[,;]")) {
                    s = s.trim();
                    this.kindToHighlighter.put(s, group);
                }
            }
        }
        catch (IOException ex) {
            throw new NutsIOException(session, (Throwable)ex);
        }
    }

    public NutsTextFormatTheme createTheme(String y, NutsSession session) {
        String string = y = y == null ? "" : y.trim();
        if (NutsBlankable.isBlank((String)y)) {
            y = "default";
        }
        if ("default".equals(y)) {
            if (this.defaultTheme == null) {
                this.defaultTheme = session.env().getOsFamily() == NutsOsFamily.WINDOWS ? new NutsTextFormatThemeWrapper(new NutsTextFormatPropertiesTheme("grass", null, session)) : new DefaultNutsTextFormatTheme(this.ws);
            }
            return this.defaultTheme;
        }
        return new NutsTextFormatThemeWrapper(new NutsTextFormatPropertiesTheme(y, null, session));
    }

    public NutsTextFormatTheme getTheme(NutsSession session) {
        if (this.styleTheme == null) {
            if (this.styleThemeName == null) {
                NutsWorkspaceOptions bootOptions = NutsWorkspaceExt.of((NutsWorkspace)this.ws).getModel().bootModel.getBootOptions();
                this.styleThemeName = bootOptions.getTheme();
            }
            this.styleTheme = this.createTheme(this.styleThemeName, session);
        }
        return this.styleTheme;
    }

    public void setTheme(NutsTextFormatTheme styleTheme, NutsSession session) {
        this.styleTheme = styleTheme;
    }

    public void setTheme(String styleThemeName, NutsSession session) {
        if (styleThemeName == null || styleThemeName.trim().isEmpty()) {
            styleThemeName = "default";
        }
        styleThemeName = styleThemeName.trim();
        this.styleTheme = this.createTheme(styleThemeName, session);
        this.styleThemeName = styleThemeName;
    }

    public NutsCodeHighlighter getCodeHighlighter(String highlighterId, NutsSession session) {
        String lc = NutsUtilStrings.trim((String)highlighterId).toLowerCase();
        NutsCodeHighlighter old = this._cachedHighlighters.get(lc);
        if (old != null) {
            return old;
        }
        NutsCodeHighlighter h = this.highlighters.get(lc);
        if (h != null) {
            this._cachedHighlighters.put(lc, h);
            return h;
        }
        int best = -1;
        for (NutsCodeHighlighter hh : this.highlighters.values()) {
            int lvl = hh.getSupportLevel((NutsSupportLevelContext)new NutsDefaultSupportLevelContext(session, (Object)lc));
            if (lvl <= 0 || best >= lvl) continue;
            best = lvl;
            h = hh;
        }
        if (best > 0) {
            this._cachedHighlighters.put(lc, h);
            return h;
        }
        String a = this.kindToHighlighter.get(lc);
        if (a != null && (h = this.highlighters.get(a)) != null) {
            this._cachedHighlighters.put(lc, h);
            return h;
        }
        if ("system".equals(lc)) {
            NutsShellFamily shellFamily = session.env().getShellFamily();
            h = this.getCodeHighlighter(shellFamily.id(), session);
            this._cachedHighlighters.put(lc, h);
            return h;
        }
        if (lc.length() > 0) {
            try {
                NutsTextStyle found = NutsTextStyle.parseLenient((String)lc);
                if (found != null) {
                    h = new CustomStyleCodeHighlighter(found, session);
                    this._cachedHighlighters.put(lc, h);
                    return h;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((h = this.highlighters.get("plain")) != null) {
            return h;
        }
        throw new NutsIllegalArgumentException(session, NutsMessage.plain((String)"not found plain highlighter"));
    }

    private String expandAlias(String ss) {
        switch (ss.toUpperCase()) {
            case "BOOL": {
                ss = "BOOLEAN";
                break;
            }
            case "KW": {
                ss = "KEYWORD";
            }
        }
        return ss;
    }

    public void addCodeHighlighter(NutsCodeHighlighter format, NutsSession session) {
        this.highlighters.put(format.getId(), format);
    }

    public void removeCodeHighlighter(String id, NutsSession session) {
        this.highlighters.remove(id);
    }

    public NutsCodeHighlighter[] getCodeHighlighters(NutsSession session) {
        return this.highlighters.values().toArray(new NutsCodeHighlighter[0]);
    }

    public NutsElementFactoryService getElementFactoryService(NutsSession session) {
        if (this.elementFactoryService == null) {
            this.elementFactoryService = new DefaultNutsElementFactoryService(this.ws, session);
        }
        return this.elementFactoryService;
    }

    public NutsElementStreamFormat getJsonMan(NutsSession session) {
        if (this.jsonMan == null) {
            this.jsonMan = new DefaultJsonElementFormat(this.ws);
        }
        return this.jsonMan;
    }

    public NutsElementStreamFormat getYamlMan(NutsSession session) {
        if (this.yamlMan == null) {
            this.yamlMan = new SimpleYaml(this.ws);
        }
        return this.yamlMan;
    }

    public NutsElementStreamFormat getXmlMan(NutsSession session) {
        if (this.xmlMan == null) {
            this.xmlMan = new DefaultXmlNutsElementStreamFormat();
        }
        return this.xmlMan;
    }

    public NutsWorkspace getWorkspace() {
        return this.ws;
    }
}

