/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.stream;

import java.util.List;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.thevpc.nuts.NutsIterator;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.stream.AbstractNutsStream;
import net.thevpc.nuts.runtime.standalone.util.collections.CoreCollectionUtils;

public class NutsIteratorStream<T>
extends AbstractNutsStream<T> {
    private final NutsIterator<T> o;

    public NutsIteratorStream(NutsSession session, String nutsBase, NutsIterator<T> o) {
        super(session, nutsBase);
        this.o = o;
    }

    @Override
    public List<T> toList() {
        return CoreCollectionUtils.toList(this.o);
    }

    @Override
    public Stream<T> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.o, 16), false);
    }

    public NutsIterator<T> iterator() {
        return this.o;
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + Objects.hashCode(this.o);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NutsIteratorStream other = (NutsIteratorStream)obj;
        return Objects.equals(this.o, other.o);
    }

    public String toString() {
        return "IteratorBasedResult@" + Integer.toHexString(this.hashCode());
    }
}

