/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.stream;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsIterable;
import net.thevpc.nuts.NutsIterator;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStream;
import net.thevpc.nuts.runtime.standalone.stream.NutsCollectionStream;
import net.thevpc.nuts.runtime.standalone.stream.NutsEmptyStream;
import net.thevpc.nuts.runtime.standalone.stream.NutsIterableStream;
import net.thevpc.nuts.runtime.standalone.stream.NutsIteratorStream;
import net.thevpc.nuts.runtime.standalone.stream.NutsJavaStream;
import net.thevpc.nuts.runtime.standalone.stream.NutsListStream;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.spi.NutsStreams;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class DefaultNutsStreams
implements NutsStreams {
    private final NutsSession session;

    public DefaultNutsStreams(NutsSession session) {
        this.session = session;
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }

    public <T> NutsStream<T> createStream(T[] str, Function<NutsElements, NutsElement> descr) {
        this.checkSession();
        String name = null;
        if (str == null) {
            return new NutsEmptyStream(this.getSession(), name);
        }
        return this.createStream(Arrays.asList(str), descr);
    }

    public <T> NutsStream<T> createStream(NutsIterable<T> str) {
        this.checkSession();
        String name = null;
        if (str == null) {
            return new NutsEmptyStream(this.getSession(), name);
        }
        if (str instanceof List) {
            return new NutsListStream(this.getSession(), name, (List)str, e -> str.describe(e));
        }
        if (str instanceof Collection) {
            return new NutsCollectionStream(this.getSession(), name, (Collection)str, e -> str.describe(e));
        }
        return new NutsIterableStream<T>(this.getSession(), name, str);
    }

    public <T> NutsStream<T> createStream(Iterable<T> str, Function<NutsElements, NutsElement> descr) {
        this.checkSession();
        String name = null;
        if (str == null) {
            return new NutsEmptyStream(this.getSession(), name);
        }
        if (str instanceof List) {
            return new NutsListStream(this.getSession(), name, (List)str, descr);
        }
        if (str instanceof Collection) {
            return new NutsCollectionStream(this.getSession(), name, (Collection)str, descr);
        }
        return new NutsIterableStream(this.getSession(), name, NutsIterable.of(str, descr));
    }

    public <T> NutsStream<T> createStream(Iterator<T> str, Function<NutsElements, NutsElement> name) {
        return new NutsIteratorStream(this.session, null, NutsIterator.of(str, name));
    }

    public <T> NutsStream<T> createStream(NutsIterator<T> str) {
        return new NutsIteratorStream<T>(this.session, null, str);
    }

    public <T> NutsStream<T> createStream(Stream<T> str, Function<NutsElements, NutsElement> name) {
        this.checkSession();
        return new NutsJavaStream<T>(this.getSession(), null, str, name);
    }

    public <T> NutsStream<T> createEmptyStream() {
        return new NutsEmptyStream(this.getSession(), null);
    }

    public void checkSession() {
    }

    public NutsSession getSession() {
        return this.session;
    }
}

