/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.stream;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsComparator;
import net.thevpc.nuts.NutsDescribables;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsFunction;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdParser;
import net.thevpc.nuts.NutsIterator;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsPredicate;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStream;
import net.thevpc.nuts.NutsTooManyElementsException;
import net.thevpc.nuts.NutsUnsafeFunction;
import net.thevpc.nuts.runtime.standalone.stream.NutsIteratorStream;
import net.thevpc.nuts.runtime.standalone.util.iter.IteratorBuilder;
import net.thevpc.nuts.runtime.standalone.util.iter.IteratorUtils;

public abstract class AbstractNutsStream<T>
implements NutsStream<T> {
    protected NutsSession session;
    protected String nutsBase;

    public AbstractNutsStream(NutsSession session, String nutsBase) {
        this.session = session;
        this.nutsBase = nutsBase;
    }

    private static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("duplicate key %s", u));
        };
    }

    public List<T> toList() {
        ArrayList list = new ArrayList();
        NutsIterator nutsIterator = this.iterator();
        while (nutsIterator.hasNext()) {
            Object a = nutsIterator.next();
            list.add(a);
        }
        return list;
    }

    public Set<T> toSet() {
        return this.stream().collect(Collectors.toSet());
    }

    public Set<T> toSortedSet() {
        return this.stream().collect(Collectors.toCollection(TreeSet::new));
    }

    public Set<T> toOrderedSet() {
        return this.stream().collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public T first() {
        NutsIterator it = this.iterator();
        if (it.hasNext()) {
            return (T)it.next();
        }
        return null;
    }

    public T last() {
        T t = null;
        NutsIterator it = this.iterator();
        if (it.hasNext()) {
            t = (T)it.next();
        }
        return t;
    }

    public T required() throws NutsNotFoundException {
        NutsIterator it = this.iterator();
        if (it.hasNext()) {
            return (T)it.next();
        }
        NutsId n = NutsIdParser.of((NutsSession)this.session).setLenient(true).parse(this.nutsBase);
        if (n != null) {
            throw new NutsNotFoundException(this.session, n);
        }
        throw new NutsNotFoundException(this.session, null, NutsMessage.cstyle((String)"artifact not found: %s%s", (Object[])new Object[]{this.nutsBase == null ? "<null>" : this.nutsBase}), null);
    }

    public T singleton() {
        NutsIterator it = this.iterator();
        if (it.hasNext()) {
            Object t = it.next();
            if (it.hasNext()) {
                throw new NutsTooManyElementsException(this.session, NutsMessage.cstyle((String)"too many results for %s", (Object[])new Object[]{this.nutsBase}));
            }
            return (T)t;
        }
        NutsId nid = NutsIdParser.of((NutsSession)this.session).setLenient(true).parse(this.nutsBase);
        if (nid != null) {
            throw new NutsNotFoundException(this.session, nid);
        }
        throw new NutsNotFoundException(this.session, null, NutsMessage.cstyle((String)"result not found for %s", (Object[])new Object[]{this.nutsBase}));
    }

    public Stream<T> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 16), false);
    }

    public long count() {
        long count = 0L;
        NutsIterator it = this.iterator();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    public <R> NutsStream<R> map(final NutsFunction<? super T, ? extends R> mapper) {
        return new AbstractNutsStream<R>(this.session, this.nutsBase){

            public NutsIterator<R> iterator() {
                NutsIterator it = AbstractNutsStream.this.iterator();
                return IteratorBuilder.of(it, this.session).map(mapper).build();
            }
        };
    }

    public <R> NutsStream<R> map(Function<? super T, ? extends R> mapper, String name) {
        return this.map(NutsFunction.of(mapper, (String)name));
    }

    public <R> NutsStream<R> map(Function<? super T, ? extends R> mapper, NutsElement name) {
        return this.map(NutsFunction.of(mapper, (NutsElement)name));
    }

    public <R> NutsStream<R> map(Function<? super T, ? extends R> mapper, Function<NutsElements, NutsElement> name) {
        return this.map(NutsFunction.of(mapper, name));
    }

    public <R> NutsStream<R> mapUnsafe(final NutsUnsafeFunction<? super T, ? extends R> mapper, final NutsFunction<Exception, ? extends R> onError) {
        return this.map(new NutsFunction<T, R>(){

            public R apply(T t) {
                try {
                    return mapper.apply(t);
                }
                catch (Exception e) {
                    return onError == null ? null : onError.apply((Object)e);
                }
            }

            public NutsElement describe(NutsElements elems) {
                return mapper.describe(elems);
            }
        });
    }

    public NutsStream<T> sorted() {
        return new AbstractNutsStream<T>(this.session, this.nutsBase){

            public NutsIterator<T> iterator() {
                NutsIterator it = AbstractNutsStream.this.iterator();
                return IteratorUtils.sort(it, null, false);
            }
        };
    }

    public NutsStream<T> sorted(final NutsComparator<T> comp) {
        return new AbstractNutsStream<T>(this.session, this.nutsBase){

            public NutsIterator<T> iterator() {
                NutsIterator it = AbstractNutsStream.this.iterator();
                return IteratorUtils.sort(it, comp, false);
            }
        };
    }

    public NutsStream<T> distinct() {
        return new AbstractNutsStream<T>(this.session, this.nutsBase){

            public NutsIterator<T> iterator() {
                NutsIterator it = AbstractNutsStream.this.iterator();
                return IteratorUtils.distinct(it);
            }
        };
    }

    public <R> NutsStream<T> distinctBy(final NutsFunction<T, R> condition) {
        return new AbstractNutsStream<T>(this.session, this.nutsBase){

            public NutsIterator<T> iterator() {
                NutsIterator it = AbstractNutsStream.this.iterator();
                return IteratorUtils.distinct(it, condition);
            }
        };
    }

    public NutsStream<T> nonNull() {
        return this.filter(Objects::nonNull, "nonNull");
    }

    public NutsStream<T> nonBlank() {
        return this.filter((? super T x) -> {
            if (x == null) {
                return false;
            }
            if (x instanceof CharSequence) {
                return NutsBlankable.isBlank((CharSequence)((CharSequence)x));
            }
            if (x instanceof char[]) {
                return NutsBlankable.isBlank((char[])((char[])x));
            }
            if (x instanceof NutsBlankable) {
                return !((NutsBlankable)x).isBlank();
            }
            return true;
        }, "nonBlank");
    }

    public NutsStream<T> filter(final NutsPredicate<? super T> predicate) {
        NutsDescribables.cast(predicate);
        return new AbstractNutsStream<T>(this.session, this.nutsBase){

            public NutsIterator<T> iterator() {
                NutsIterator it = AbstractNutsStream.this.iterator();
                return IteratorBuilder.of(it, this.session).filter(predicate).build();
            }
        };
    }

    public NutsStream<T> filter(Predicate<? super T> predicate, String name) {
        return this.filter(predicate, (NutsElements e) -> e.ofString(name));
    }

    public NutsStream<T> filter(Predicate<? super T> predicate, NutsElement name) {
        return this.filter(predicate, (NutsElements e) -> name);
    }

    public NutsStream<T> filter(Predicate<? super T> predicate, Function<NutsElements, NutsElement> info) {
        final NutsPredicate p = predicate == null ? null : NutsPredicate.of(predicate, info);
        return new AbstractNutsStream<T>(this.session, this.nutsBase){

            public NutsIterator<T> iterator() {
                NutsIterator it = AbstractNutsStream.this.iterator();
                return IteratorBuilder.of(it, this.session).filter(p).build();
            }
        };
    }

    public NutsStream<T> filterNonNull() {
        return this.filter(Objects::nonNull, "nonNull");
    }

    public NutsStream<T> filterNonBlank() {
        return this.filter((? super T x) -> !NutsBlankable.isBlank((Object)x), "nonBlank");
    }

    public NutsStream<T> coalesce(final NutsIterator<? extends T> other) {
        return new AbstractNutsStream<T>(this.session, this.nutsBase){

            public NutsIterator<T> iterator() {
                NutsIterator it = AbstractNutsStream.this.iterator();
                List iterators = Arrays.asList(it, other);
                return IteratorUtils.coalesce(iterators);
            }
        };
    }

    public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.stream().toArray(generator);
    }

    public <K, U> Map<K, U> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return this.stream().collect(Collectors.toMap(keyMapper, valueMapper));
    }

    public <K, U> Map<K, U> toOrderedMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return this.stream().collect(Collectors.toMap(keyMapper, valueMapper, AbstractNutsStream.throwingMerger(), LinkedHashMap::new));
    }

    public <K, U> Map<K, U> toSortedMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return this.stream().collect(Collectors.toMap(keyMapper, valueMapper, AbstractNutsStream.throwingMerger(), TreeMap::new));
    }

    public <R> NutsStream<R> flatMapIter(final NutsFunction<? super T, ? extends Iterator<? extends R>> mapper) {
        return new AbstractNutsStream<R>(this.session, this.nutsBase){

            public NutsIterator<R> iterator() {
                return IteratorBuilder.of(AbstractNutsStream.this.iterator(), this.session).flatMap(mapper).build();
            }
        };
    }

    public <R> NutsStream<R> flatMapList(final NutsFunction<? super T, ? extends List<? extends R>> mapper) {
        return new AbstractNutsStream<R>(this.session, this.nutsBase){

            public NutsIterator<R> iterator() {
                IteratorBuilder r = IteratorBuilder.of(AbstractNutsStream.this.iterator(), this.session);
                return r.flatMap(NutsFunction.of(t -> ((List)mapper.apply(t)).iterator(), arg_0 -> ((NutsFunction)mapper).describe(arg_0))).build();
            }
        };
    }

    public <R> NutsStream<R> flatMapArray(final NutsFunction<? super T, ? extends R[]> mapper) {
        return new AbstractNutsStream<R>(this.session, this.nutsBase){

            public NutsIterator<R> iterator() {
                return IteratorBuilder.of(AbstractNutsStream.this.iterator(), this.session).flatMap(NutsFunction.of(t -> Arrays.asList((Object[])mapper.apply(t)).iterator(), arg_0 -> ((NutsFunction)mapper).describe(arg_0))).build();
            }
        };
    }

    public <R> NutsStream<R> flatMap(final NutsFunction<? super T, ? extends Stream<? extends R>> mapper) {
        return new AbstractNutsStream<R>(this.session, this.nutsBase){

            public NutsIterator<R> iterator() {
                return IteratorBuilder.of(AbstractNutsStream.this.iterator(), this.session).flatMap(NutsFunction.of(t -> ((Stream)mapper.apply(t)).iterator(), arg_0 -> ((NutsFunction)mapper).describe(arg_0))).build();
            }
        };
    }

    public <R> NutsStream<R> flatMapStream(final NutsFunction<? super T, ? extends NutsStream<? extends R>> mapper) {
        return new AbstractNutsStream<R>(this.session, this.nutsBase){

            public NutsIterator<R> iterator() {
                return IteratorBuilder.of(AbstractNutsStream.this.iterator(), this.session).flatMap(NutsFunction.of(t -> ((NutsStream)mapper.apply(t)).iterator(), arg_0 -> ((NutsFunction)mapper).describe(arg_0))).build();
            }
        };
    }

    public <K> Map<K, List<T>> groupBy(NutsFunction<? super T, ? extends K> classifier) {
        Stream<? super T> it = this.stream();
        return it.collect(Collectors.groupingBy(classifier));
    }

    public <K> NutsStream<Map.Entry<K, List<T>>> groupedBy(NutsFunction<? super T, ? extends K> classifier) {
        Stream<? super T> it = this.stream();
        Set<Map.Entry<K, List<T>>> entries = it.collect(Collectors.groupingBy(classifier)).entrySet();
        return new NutsIteratorStream<Map.Entry<K, List<T>>>(this.session, this.nutsBase, NutsIterator.of(entries.iterator(), e -> e.ofObject().set("type", "GroupBy").set("groupBy", classifier.describe(e)).set("base", this.iterator().describe(e)).build()));
    }

    public Optional<T> findAny() {
        return this.stream().findAny();
    }

    public Optional<T> findFirst() {
        return this.stream().findFirst();
    }

    public DoubleStream flatMapToDouble(NutsFunction<? super T, ? extends DoubleStream> mapper) {
        return this.stream().flatMapToDouble((Function<? super T, DoubleStream>)mapper);
    }

    public IntStream flatMapToInt(NutsFunction<? super T, ? extends IntStream> mapper) {
        return this.stream().flatMapToInt((Function<? super T, IntStream>)mapper);
    }

    public LongStream flatMapToLong(NutsFunction<? super T, ? extends LongStream> mapper) {
        return this.stream().flatMapToLong((Function<? super T, LongStream>)mapper);
    }

    public boolean allMatch(Predicate<? super T> predicate) {
        return this.stream().allMatch(predicate);
    }

    public boolean noneMatch(Predicate<? super T> predicate) {
        return this.stream().noneMatch(predicate);
    }

    public NutsStream<T> limit(long maxSize) {
        return NutsStream.of(this.stream().limit(maxSize), (NutsSession)this.session);
    }

    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        return this.stream().collect(supplier, accumulator, combiner);
    }

    public <R, A> R collect(Collector<? super T, A, R> collector) {
        return this.stream().collect(collector);
    }

    public Optional<T> min(Comparator<? super T> comparator) {
        return this.stream().min(comparator);
    }

    public Optional<T> max(Comparator<? super T> comparator) {
        return this.stream().max(comparator);
    }

    public NutsElement describe(NutsElements elems) {
        return this.iterator().describe(elems);
    }
}

