/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.shell;

import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsShellFamily;
import net.thevpc.nuts.runtime.standalone.app.cmdline.NutsCommandLineShellOptions;
import net.thevpc.nuts.runtime.standalone.shell.BashNutsShellHelper;
import net.thevpc.nuts.runtime.standalone.shell.CshNutsShellHelper;
import net.thevpc.nuts.runtime.standalone.shell.FishNutsShellHelper;
import net.thevpc.nuts.runtime.standalone.shell.KshNutsShellHelper;
import net.thevpc.nuts.runtime.standalone.shell.ReplaceString;
import net.thevpc.nuts.runtime.standalone.shell.ShNutsShellHelper;
import net.thevpc.nuts.runtime.standalone.shell.WinCmdNutsShellHelper;
import net.thevpc.nuts.runtime.standalone.shell.WinPowerShellNutsShellHelper;
import net.thevpc.nuts.runtime.standalone.shell.ZshNutsShellHelper;

public interface NutsShellHelper {
    public static NutsShellHelper of(NutsShellFamily shellFamily) {
        if (shellFamily == null) {
            shellFamily = NutsShellFamily.UNKNOWN;
        }
        switch (shellFamily) {
            case SH: {
                return ShNutsShellHelper.SH;
            }
            case BASH: {
                return BashNutsShellHelper.BASH;
            }
            case CSH: {
                return CshNutsShellHelper.CSH;
            }
            case ZSH: {
                return ZshNutsShellHelper.ZSH;
            }
            case KSH: {
                return KshNutsShellHelper.KSH;
            }
            case FISH: {
                return FishNutsShellHelper.FISH;
            }
            case WIN_CMD: {
                return WinCmdNutsShellHelper.WIN_CMD;
            }
            case WIN_POWER_SHELL: {
                return WinPowerShellNutsShellHelper.WIN_POWER_SHELL;
            }
        }
        switch (NutsOsFamily.getCurrent()) {
            case WINDOWS: {
                return NutsShellHelper.of(NutsShellFamily.WIN_CMD);
            }
        }
        return NutsShellHelper.of(NutsShellFamily.SH);
    }

    public String newlineString();

    public String getExportCommand(String[] var1);

    public String getSetVarCommand(String var1, String var2);

    public String getSetVarStaticCommand(String var1, String var2);

    public String getCallScriptCommand(String var1, String ... var2);

    public boolean isComments(String var1);

    public String toCommentLine(String var1);

    public ReplaceString getShebanSh();

    public String varRef(String var1);

    public String trimComments(String var1);

    public String getPathVarSep();

    public String getSysRcName();

    public String[] parseCommandLineArr(String var1, NutsSession var2);

    public String escapeArgument(String var1, NutsCommandLineShellOptions var2);

    public String escapeArguments(String[] var1, NutsCommandLineShellOptions var2);
}

