/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.shell;

import java.nio.file.Path;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPathPermission;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsShellFamily;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.shell.NutsShellHelper;
import net.thevpc.nuts.runtime.standalone.shell.ScriptBuilder;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.NameBuilder;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.base.BaseSystemNdi;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.util.PathInfo;

public abstract class AbstractScriptBuilder
implements ScriptBuilder {
    private NutsSession session;
    private NutsId anyId;
    private String path;
    private String type;
    private NutsShellFamily shellFamily;

    public AbstractScriptBuilder(NutsShellFamily shellFamily, String type, NutsId anyId, NutsSession session) {
        this.session = session;
        this.shellFamily = shellFamily;
        this.anyId = anyId.builder().setRepository(null).build();
        this.type = type;
    }

    public NutsShellFamily getShellFamily() {
        return this.shellFamily;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsId getAnyId() {
        return this.anyId;
    }

    public String getType() {
        return this.type;
    }

    public String getPath() {
        return this.path;
    }

    public AbstractScriptBuilder setPath(Path path) {
        this.path = path == null ? null : path.toString();
        return this;
    }

    public AbstractScriptBuilder setPath(NutsPath path) {
        this.path = path == null ? null : path.toString();
        return this;
    }

    public AbstractScriptBuilder setPath(String preferredName) {
        this.path = preferredName;
        return this;
    }

    public PathInfo buildAddLine(BaseSystemNdi ndi) {
        return ndi.addFileLine(this.type, this.anyId, NutsPath.of((String)this.path, (NutsSession)this.session), ndi.getCommentLineConfigHeader(), this.buildString(), NutsShellHelper.of(this.getShellFamily()).getShebanSh(), this.shellFamily);
    }

    @Override
    public PathInfo build() {
        NutsDefinition anyIdDef = (NutsDefinition)this.session.search().addId(this.anyId).setLatest(true).setDistinct(true).getResultDefinitions().singleton();
        NutsId anyId = anyIdDef.getId();
        String path = NameBuilder.id(anyId, this.path, "%n", anyIdDef.getDescriptor(), this.session).buildName();
        NutsPath script = NutsPath.of((String)path, (NutsSession)this.session);
        String newContent = this.buildString();
        PathInfo.Status update = CoreIOUtils.tryWrite(newContent.getBytes(), script, this.session);
        script.addPermissions(new NutsPathPermission[]{NutsPathPermission.CAN_EXECUTE});
        return new PathInfo(this.type, anyId, script, update);
    }
}

