/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.session;

import java.util.Map;
import net.thevpc.nuts.NutsContent;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsIndexStore;
import net.thevpc.nuts.NutsIterator;
import net.thevpc.nuts.NutsMapListener;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryConfigManager;
import net.thevpc.nuts.NutsRepositoryListener;
import net.thevpc.nuts.NutsRepositorySecurityManager;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.repository.cmd.NutsRepositorySupportedAction;
import net.thevpc.nuts.runtime.standalone.repository.impl.NutsRepositoryExt;
import net.thevpc.nuts.spi.NutsDeployRepositoryCommand;
import net.thevpc.nuts.spi.NutsFetchContentRepositoryCommand;
import net.thevpc.nuts.spi.NutsFetchDescriptorRepositoryCommand;
import net.thevpc.nuts.spi.NutsPushRepositoryCommand;
import net.thevpc.nuts.spi.NutsRepositorySPI;
import net.thevpc.nuts.spi.NutsRepositoryUndeployCommand;
import net.thevpc.nuts.spi.NutsSearchRepositoryCommand;
import net.thevpc.nuts.spi.NutsSearchVersionsRepositoryCommand;
import net.thevpc.nuts.spi.NutsUpdateRepositoryStatisticsCommand;

public class NutsRepositorySessionAwareImpl
implements NutsRepository,
NutsRepositorySPI,
NutsRepositoryExt {
    private NutsRepository repo;
    private NutsWorkspace ws;
    private NutsSession session;

    public static NutsRepositorySessionAwareImpl of(NutsRepository repo, NutsWorkspace ws, NutsSession session) {
        if (repo == null) {
            return null;
        }
        if (repo instanceof NutsRepositorySessionAwareImpl) {
            NutsRepositorySessionAwareImpl a = (NutsRepositorySessionAwareImpl)repo;
            NutsSession s2 = a.getSession();
            if (s2 == session) {
                return a;
            }
            return new NutsRepositorySessionAwareImpl(a.repo, session.getWorkspace(), session);
        }
        return new NutsRepositorySessionAwareImpl(repo, session.getWorkspace(), session);
    }

    private NutsRepositorySessionAwareImpl(NutsRepository repo, NutsWorkspace ws, NutsSession session) {
        this.repo = repo;
        this.ws = ws;
        this.session = session;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public String getRepositoryType() {
        return this.repo.getRepositoryType();
    }

    public String getUuid() {
        return this.repo.getUuid();
    }

    public String getName() {
        return this.repo.getName();
    }

    public NutsWorkspace getWorkspace() {
        return this.session == null ? this.ws : this.session.getWorkspace();
    }

    public NutsRepository getParentRepository() {
        return NutsRepositorySessionAwareImpl.of(this.repo.getParentRepository(), this.getWorkspace(), this.session);
    }

    public NutsRepositoryConfigManager config() {
        return this.repo.config().setSession(this.session);
    }

    public NutsRepositorySecurityManager security() {
        return this.repo.security().setSession(this.session);
    }

    public NutsRepository removeRepositoryListener(NutsRepositoryListener listener) {
        this.repo.removeRepositoryListener(listener);
        return this;
    }

    public NutsRepository addRepositoryListener(NutsRepositoryListener listener) {
        this.repo.addRepositoryListener(listener);
        return this;
    }

    public NutsRepositoryListener[] getRepositoryListeners() {
        return this.repo.getRepositoryListeners();
    }

    public Map<String, Object> getUserProperties() {
        return this.repo.getUserProperties();
    }

    public NutsRepository addUserPropertyListener(NutsMapListener<String, Object> listener) {
        this.repo.addUserPropertyListener(listener);
        return this;
    }

    public NutsRepository removeUserPropertyListener(NutsMapListener<String, Object> listener) {
        this.repo.removeUserPropertyListener(listener);
        return this;
    }

    public NutsMapListener<String, Object>[] getUserPropertyListeners() {
        return this.repo.getUserPropertyListeners();
    }

    public boolean isEnabled() {
        return this.repo.isEnabled();
    }

    public NutsRepository setEnabled(boolean enabled) {
        return this.repo.setEnabled(enabled);
    }

    private NutsRepositorySPI repoSPI() {
        return (NutsRepositorySPI)this.repo;
    }

    public NutsDeployRepositoryCommand deploy() {
        return this.repoSPI().deploy().setSession(this.getSession());
    }

    public NutsRepositoryUndeployCommand undeploy() {
        return this.repoSPI().undeploy().setSession(this.getSession());
    }

    public NutsPushRepositoryCommand push() {
        return this.repoSPI().push().setSession(this.getSession());
    }

    public NutsFetchDescriptorRepositoryCommand fetchDescriptor() {
        return this.repoSPI().fetchDescriptor().setSession(this.getSession());
    }

    public NutsFetchContentRepositoryCommand fetchContent() {
        return this.repoSPI().fetchContent().setSession(this.getSession());
    }

    public NutsSearchRepositoryCommand search() {
        return this.repoSPI().search().setSession(this.getSession());
    }

    public NutsSearchVersionsRepositoryCommand searchVersions() {
        return this.repoSPI().searchVersions().setSession(this.getSession());
    }

    public NutsUpdateRepositoryStatisticsCommand updateStatistics() {
        return this.repoSPI().updateStatistics().setSession(this.getSession());
    }

    public boolean isAcceptFetchMode(NutsFetchMode mode, NutsSession session) {
        return this.repoSPI().isAcceptFetchMode(mode, session);
    }

    public boolean isSupportedDeploy(NutsSession session) {
        return this.repo.isSupportedDeploy(session);
    }

    public boolean isSupportedDeploy(boolean force, NutsSession session) {
        return this.repo.isSupportedDeploy(force, session);
    }

    private NutsRepositoryExt repoExt() {
        return (NutsRepositoryExt)this.repo;
    }

    @Override
    public NutsIndexStore getIndexStore() {
        return this.repoExt().getIndexStore();
    }

    @Override
    public void pushImpl(NutsPushRepositoryCommand command) {
        this.repoExt().pushImpl(command);
    }

    @Override
    public NutsDescriptor deployImpl(NutsDeployRepositoryCommand command) {
        return this.repoExt().deployImpl(command);
    }

    @Override
    public void undeployImpl(NutsRepositoryUndeployCommand command) {
        this.repoExt().undeployImpl(command);
    }

    @Override
    public void checkAllowedFetch(NutsId id, NutsSession session) {
        this.repoExt().checkAllowedFetch(id, session);
    }

    @Override
    public NutsDescriptor fetchDescriptorImpl(NutsId id, NutsFetchMode fetchMode, NutsSession session) {
        return this.repoExt().fetchDescriptorImpl(id, fetchMode, session);
    }

    @Override
    public NutsIterator<NutsId> searchVersionsImpl(NutsId id, NutsIdFilter idFilter, NutsFetchMode fetchMode, NutsSession session) {
        return this.repoExt().searchVersionsImpl(id, idFilter, fetchMode, session);
    }

    @Override
    public NutsContent fetchContentImpl(NutsId id, NutsDescriptor descriptor, String localPath, NutsFetchMode fetchMode, NutsSession session) {
        return this.repoExt().fetchContentImpl(id, descriptor, localPath, fetchMode, session);
    }

    @Override
    public NutsIterator<NutsId> searchImpl(NutsIdFilter filter, NutsFetchMode fetchMode, NutsSession session) {
        return this.repoExt().searchImpl(filter, fetchMode, session);
    }

    @Override
    public NutsId searchLatestVersion(NutsId id, NutsIdFilter filter, NutsFetchMode fetchMode, NutsSession session) {
        return this.repoExt().searchLatestVersion(id, filter, fetchMode, session);
    }

    @Override
    public boolean acceptAction(NutsId id, NutsRepositorySupportedAction supportedAction, NutsFetchMode mode, NutsSession session) {
        return this.repoExt().acceptAction(id, supportedAction, mode, session);
    }

    @Override
    public NutsPath getIdBasedir(NutsId id, NutsSession session) {
        return this.repoExt().getIdBasedir(id, session);
    }

    @Override
    public String getIdFilename(NutsId id, NutsSession session) {
        return this.repoExt().getIdFilename(id, session);
    }

    public boolean isAvailable(NutsSession session) {
        return this.repo.isAvailable(session);
    }

    public boolean isAvailable(boolean force, NutsSession session) {
        return this.repo.isAvailable(force, session);
    }

    public String toString() {
        return this.repo.toString();
    }

    public boolean isRemote() {
        return this.repo.isRemote();
    }
}

