/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.security;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSecurityException;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.security.NutsAuthenticationAgentProvider;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsAuthenticationAgent;

class WrapperNutsAuthenticationAgent {
    protected NutsWorkspace ws;
    protected NutsAuthenticationAgentProvider provider;
    protected Function<NutsSession, Map<String, String>> envProvider;
    private final Map<String, NutsAuthenticationAgent> cache = new HashMap<String, NutsAuthenticationAgent>();

    public WrapperNutsAuthenticationAgent(NutsWorkspace ws, Function<NutsSession, Map<String, String>> envProvider, NutsAuthenticationAgentProvider agentProvider) {
        this.envProvider = envProvider;
        this.provider = agentProvider;
        this.ws = ws;
    }

    public NutsAuthenticationAgent getCachedAuthenticationAgent(String name, NutsSession session) {
        NutsWorkspaceUtils.checkSession(this.ws, session);
        name = NutsUtilStrings.trim((String)name);
        NutsAuthenticationAgent a = this.cache.get(name);
        if (a == null) {
            a = this.provider.create(name, session);
            this.cache.put(name, a);
            if (!a.getId().equals(name)) {
                this.cache.put(a.getId(), a);
            }
        }
        return a;
    }

    public boolean removeCredentials(char[] credentialsId, NutsSession session) {
        NutsWorkspaceUtils.checkSession(this.ws, session);
        return this.getCachedAuthenticationAgent(this.extractId(credentialsId, session), session).removeCredentials(credentialsId, this.envProvider.apply(session), session);
    }

    public void checkCredentials(char[] credentialsId, char[] password, NutsSession session) {
        NutsWorkspaceUtils.checkSession(this.ws, session);
        this.getCachedAuthenticationAgent(this.extractId(credentialsId, session), session).checkCredentials(credentialsId, password, this.envProvider.apply(session), session);
    }

    protected String extractId(char[] a, NutsSession session) {
        String b = new String(a);
        int x = b.indexOf(58);
        if (x <= 0) {
            if (session.boot().getBootOptions().isRecover()) {
                session.err().println("```error RECOVER MODE : Password could no be parsed due a change in encryption spec. WIll use new default agent```");
                return null;
            }
            throw new NutsSecurityException(session, NutsMessage.plain((String)"credential id must start with authentication agent id"));
        }
        return b.substring(0, x);
    }

    public char[] getCredentials(char[] credentialsId, NutsSession session) {
        return this.getCachedAuthenticationAgent(this.extractId(credentialsId, session), session).getCredentials(credentialsId, this.envProvider.apply(session), session);
    }

    public char[] createCredentials(char[] credentials, boolean allowRetrieve, char[] credentialId, NutsSession session) {
        NutsWorkspaceUtils.checkSession(this.ws, session);
        if (credentialId != null) {
            return this.getCachedAuthenticationAgent(this.extractId(credentialId, session), session).createCredentials(credentials, allowRetrieve, credentialId, this.envProvider.apply(session), session);
        }
        return this.getCachedAuthenticationAgent("", session).createCredentials(credentials, allowRetrieve, credentialId, this.envProvider.apply(session), session);
    }
}

