/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.security;

import java.util.Arrays;
import java.util.Map;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSecurityException;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.spi.NutsAuthenticationAgent;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class PlainNutsAuthenticationAgent
implements NutsAuthenticationAgent {
    private NutsWorkspace ws;

    public String getId() {
        return "plain";
    }

    public void checkCredentials(char[] credentialsId, char[] password, Map<String, String> envProvider, NutsSession session) {
        if (password == null || NutsBlankable.isBlank((String)new String(password))) {
            throw new NutsSecurityException(session, NutsMessage.plain((String)"missing old password"));
        }
        char[] iid = this.extractId(credentialsId, session);
        if (Arrays.equals(iid, password)) {
            return;
        }
        throw new NutsSecurityException(session, NutsMessage.plain((String)"invalid login or password"));
    }

    public char[] getCredentials(char[] credentialsId, Map<String, String> envProvider, NutsSession session) {
        return this.extractId(credentialsId, session);
    }

    public boolean removeCredentials(char[] credentialsId, Map<String, String> envProvider, NutsSession session) {
        this.extractId(credentialsId, session);
        return true;
    }

    public char[] createCredentials(char[] credentials, boolean allowRetrieve, char[] credentialId, Map<String, String> envProvider, NutsSession session) {
        if (credentials == null || NutsBlankable.isBlank((String)new String(credentials))) {
            return null;
        }
        char[] val = credentials;
        String id = this.getId();
        char[] r = new char[id.length() + 1 + val.length];
        System.arraycopy(id.toCharArray(), 0, r, 0, id.length());
        r[id.length()] = 58;
        System.arraycopy(val, 0, r, id.length() + 1, val.length);
        return r;
    }

    public int getSupportLevel(NutsSupportLevelContext authenticationAgent) {
        return 9;
    }

    private char[] extractId(char[] a, NutsSession session) {
        char[] idc;
        if (a != null && !NutsBlankable.isBlank((String)new String(a)) && a.length > (idc = (this.getId() + ":").toCharArray()).length + 1) {
            boolean ok = true;
            for (int i = 0; i < idc.length; ++i) {
                if (a[i] == idc[i]) continue;
                ok = false;
                break;
            }
            if (ok) {
                return Arrays.copyOfRange(a, idc.length, a.length);
            }
        }
        throw new NutsSecurityException(session, NutsMessage.cstyle((String)"credential id must start with '%s:'", (Object[])new Object[]{this.getId()}));
    }
}

