/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.security;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class NutsAuthorizations {
    private final Set<String> allowed = new HashSet<String>();
    private final Set<String> denied = new HashSet<String>();

    public NutsAuthorizations(Collection<String> all) {
        for (String s : all) {
            if (s.startsWith("!")) {
                String ss = s.substring(1);
                if (!NutsAuthorizations.isValidPermission(ss)) continue;
                this.denied.add(ss);
                continue;
            }
            this.allowed.addAll(Arrays.asList(NutsAuthorizations.computePermissions(s)));
        }
    }

    public Boolean explicitAccept(String right) {
        if (this.denied.contains(right)) {
            return false;
        }
        if (this.allowed.contains(right)) {
            return true;
        }
        return null;
    }

    public boolean accept(String right) {
        if (this.denied.contains(right)) {
            return false;
        }
        return this.allowed.contains(right);
    }

    private static String[] computePermissions(String r) {
        if (r == null) {
            return new String[0];
        }
        switch (r) {
            case "fetch-desc": {
                return new String[]{r};
            }
            case "fetch-content": {
                return new String[]{r};
            }
            case "save": {
                return new String[]{r};
            }
            case "auto-install": {
                return new String[]{r};
            }
            case "install": {
                return new String[]{r};
            }
            case "update": {
                return new String[]{r};
            }
            case "uninstall": {
                return new String[]{r};
            }
            case "exec": {
                return new String[]{r};
            }
            case "deploy": {
                return new String[]{r};
            }
            case "undeploy": {
                return new String[]{r};
            }
            case "push": {
                return new String[]{r};
            }
            case "add-repo": {
                return new String[]{r};
            }
            case "remove-repo": {
                return new String[]{r};
            }
            case "set-password": {
                return new String[]{r};
            }
            case "admin": {
                return new String[]{r};
            }
        }
        return new String[0];
    }

    private static boolean isValidPermission(String r) {
        if (r == null) {
            return false;
        }
        switch (r) {
            case "fetch-desc": 
            case "fetch-content": 
            case "save": 
            case "auto-install": 
            case "install": 
            case "update": 
            case "uninstall": 
            case "exec": 
            case "deploy": 
            case "undeploy": 
            case "push": 
            case "add-repo": 
            case "remove-repo": 
            case "set-password": 
            case "admin": {
                return true;
            }
        }
        return false;
    }
}

