/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.security;

import net.thevpc.nuts.NutsAddUserCommand;
import net.thevpc.nuts.NutsRemoveUserCommand;
import net.thevpc.nuts.NutsRepositorySecurityManager;
import net.thevpc.nuts.NutsSecurityException;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUpdateUserCommand;
import net.thevpc.nuts.NutsUser;
import net.thevpc.nuts.runtime.standalone.security.DefaultNutsRepositorySecurityModel;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsAuthenticationAgent;

public class DefaultNutsRepositorySecurityManager
implements NutsRepositorySecurityManager {
    private DefaultNutsRepositorySecurityModel model;
    private NutsSession session;

    public DefaultNutsRepositorySecurityManager(DefaultNutsRepositorySecurityModel model) {
        this.model = model;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsRepositorySecurityManager setSession(NutsSession session) {
        this.session = NutsWorkspaceUtils.bindSession(this.model.getWorkspace(), session);
        return this;
    }

    public DefaultNutsRepositorySecurityModel getModel() {
        return this.model;
    }

    public NutsRepositorySecurityManager checkAllowed(String right, String operationName) {
        this.checkSession(this.session);
        this.model.checkAllowed(right, operationName, this.session);
        return this;
    }

    private void checkSession(NutsSession session1) {
        NutsWorkspaceUtils.checkSession(this.model.getWorkspace(), session1);
    }

    public NutsAddUserCommand addUser(String name) {
        this.checkSession(this.session);
        return this.model.addUser(name, this.session);
    }

    public NutsUpdateUserCommand updateUser(String name) {
        this.checkSession(this.session);
        return this.model.updateUser(name, this.session).setSession(this.session);
    }

    public NutsRemoveUserCommand removeUser(String name) {
        this.checkSession(this.session);
        return this.model.removeUser(name, this.session).setSession(this.session);
    }

    public boolean isAllowed(String right) {
        this.checkSession(this.session);
        return this.model.isAllowed(right, this.session);
    }

    public NutsUser[] findUsers() {
        this.checkSession(this.session);
        return this.model.findUsers(this.session);
    }

    public NutsUser getEffectiveUser(String username) {
        this.checkSession(this.session);
        return this.model.getEffectiveUser(username, this.session);
    }

    public NutsAuthenticationAgent getAuthenticationAgent(String id) {
        this.checkSession(this.session);
        return this.model.getAuthenticationAgent(id, this.session);
    }

    public NutsRepositorySecurityManager setAuthenticationAgent(String authenticationAgent) {
        this.checkSession(this.session);
        this.model.setAuthenticationAgent(authenticationAgent, this.session);
        return this;
    }

    public NutsRepositorySecurityManager checkCredentials(char[] credentialsId, char[] password) throws NutsSecurityException {
        this.checkSession(this.session);
        this.model.checkCredentials(credentialsId, password, this.session);
        return this;
    }

    public char[] getCredentials(char[] credentialsId) {
        this.checkSession(this.session);
        return this.model.getCredentials(credentialsId, this.session);
    }

    public boolean removeCredentials(char[] credentialsId) {
        this.checkSession(this.session);
        return this.model.removeCredentials(credentialsId, this.session);
    }

    public char[] createCredentials(char[] credentials, boolean allowRetrieve, char[] credentialId) {
        this.checkSession(this.session);
        return this.model.createCredentials(credentials, allowRetrieve, credentialId, this.session);
    }
}

