/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.security;

import java.util.Arrays;
import java.util.Map;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSecurityException;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.io.util.CoreSecurityUtils;
import net.thevpc.nuts.spi.NutsAuthenticationAgent;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public abstract class AbstractNutsAuthenticationAgent
implements NutsAuthenticationAgent {
    private final String name;
    private NutsWorkspace ws;
    private int supportLevel;

    public AbstractNutsAuthenticationAgent(String name, int supportLevel) {
        this.name = name;
        this.supportLevel = supportLevel;
    }

    public String getId() {
        return this.name;
    }

    public boolean removeCredentials(char[] credentialsId, Map<String, String> envProvider, NutsSession session) {
        this.extractId(credentialsId, session);
        return true;
    }

    public int getSupportLevel(NutsSupportLevelContext authenticationAgent) {
        return this.supportLevel;
    }

    public void checkCredentials(char[] credentialsId, char[] password, Map<String, String> envProvider, NutsSession session) {
        if (password == null || NutsBlankable.isBlank((String)new String(password))) {
            throw new NutsSecurityException(session, NutsMessage.plain((String)"missing old password"));
        }
        CredentialsId iid = this.extractId(credentialsId, session);
        switch (iid.type) {
            case 'H': {
                if (!Arrays.equals(iid.value, this.hashChars(password, this.getPassphrase(envProvider), session))) break;
                return;
            }
            case 'B': {
                char[] encPwd = this.encryptChars(password, this.getPassphrase(envProvider), session);
                if (!Arrays.equals(iid.value, encPwd)) break;
                return;
            }
        }
        throw new NutsSecurityException(session, NutsMessage.plain((String)"invalid login or password"));
    }

    private CredentialsId extractId(char[] a, NutsSession session) {
        char[] idc;
        if (a != null && !NutsBlankable.isBlank((String)new String(a)) && a.length > (idc = (this.getId() + ":").toCharArray()).length + 1) {
            boolean ok = true;
            for (int i = 0; i < idc.length; ++i) {
                if (a[i] == idc[i]) continue;
                ok = false;
                break;
            }
            if (ok && (a[idc.length] == 'H' || a[idc.length] == 'B')) {
                return new CredentialsId(a[idc.length], Arrays.copyOfRange(a, idc.length + 1, a.length));
            }
        }
        throw new NutsSecurityException(session, NutsMessage.cstyle((String)"credential id must start with '%s:'", (Object[])new Object[]{this.getId()}));
    }

    public char[] getCredentials(char[] credentialsId, Map<String, String> envProvider, NutsSession session) {
        CredentialsId validCredentialsId = this.extractId(credentialsId, session);
        if (validCredentialsId.type == 'B') {
            return this.decryptChars(validCredentialsId.value, this.getPassphrase(envProvider), session);
        }
        throw new NutsSecurityException(session, NutsMessage.plain((String)"credential is hashed and cannot be retrived"));
    }

    public char[] createCredentials(char[] credentials, boolean allowRetrieve, char[] credentialId, Map<String, String> envProvider, NutsSession session) {
        int type;
        char[] val;
        if (credentials == null || NutsBlankable.isBlank((String)new String(credentials))) {
            return null;
        }
        if (allowRetrieve) {
            val = this.encryptChars(credentials, this.getPassphrase(envProvider), session);
            type = 66;
        } else {
            val = this.hashChars(credentials, this.getPassphrase(envProvider), session);
            type = 72;
        }
        String id = this.getId();
        char[] r = new char[id.length() + 2 + val.length];
        System.arraycopy(id.toCharArray(), 0, r, 0, id.length());
        r[id.length()] = 58;
        r[id.length() + 1] = type;
        System.arraycopy(val, 0, r, id.length() + 2, val.length);
        return r;
    }

    public String getPassphrase(Map<String, String> envProvider) {
        String defVal = CoreSecurityUtils.DEFAULT_PASSPHRASE;
        if (envProvider != null) {
            String r = envProvider.get("nuts.authentication-agent.simple.passphrase");
            if (r == null) {
                r = defVal;
            }
            if (r == null || r.isEmpty()) {
                r = defVal;
            }
            return r;
        }
        return defVal;
    }

    protected abstract char[] decryptChars(char[] var1, String var2, NutsSession var3);

    protected abstract char[] encryptChars(char[] var1, String var2, NutsSession var3);

    protected abstract char[] hashChars(char[] var1, String var2, NutsSession var3);

    private static class CredentialsId {
        char type;
        char[] value;

        public CredentialsId(char type, char[] value) {
            this.type = type;
            this.value = value;
        }
    }
}

