/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.id.filter.NutsIdFilterAnd;
import net.thevpc.nuts.runtime.standalone.id.filter.NutsIdFilterOr;
import net.thevpc.nuts.runtime.standalone.id.filter.NutsPatternIdFilter;

public class CommonRootsByPathHelper {
    private static Set<NutsPath> resolveRootIdAnd(Set<NutsPath> a, Set<NutsPath> b, NutsSession session) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.isEmpty()) {
            return Collections.emptySet();
        }
        if (b.isEmpty()) {
            return Collections.emptySet();
        }
        NutsPath[] aa = a.toArray(new NutsPath[0]);
        NutsPath[] bb = b.toArray(new NutsPath[0]);
        HashSet<NutsPath> h = new HashSet<NutsPath>();
        for (NutsPath path : aa) {
            for (NutsPath nutsPath : bb) {
                h.add(CommonRootsByPathHelper.commonRoot(path, nutsPath, session));
            }
        }
        return CommonRootsByPathHelper.compact(h);
    }

    private static Set<NutsPath> compact(Set<NutsPath> a) {
        HashMap<String, NutsPath> x = new HashMap<String, NutsPath>();
        if (a != null) {
            for (NutsPath t : a) {
                String ts = CommonRootsByPathHelper.pathOf(t);
                NutsPath o = (NutsPath)x.get(ts);
                if (o != null && (CommonRootsByPathHelper.deepOf(o) || !CommonRootsByPathHelper.deepOf(t))) continue;
                x.put(ts, t);
            }
        }
        return new HashSet<NutsPath>(x.values());
    }

    private static boolean deepOf(NutsPath p) {
        return p.getName().equals("*");
    }

    private static String pathOf(NutsPath p) {
        if (p.getName().equals("*")) {
            p = p.getParent();
        }
        if (p == null) {
            return "";
        }
        return p.toString();
    }

    private static Set<NutsPath> resolveRootIdOr(Set<NutsPath> a, Set<NutsPath> b) {
        NutsPath o;
        String ts;
        HashMap<String, NutsPath> x = new HashMap<String, NutsPath>();
        if (a != null) {
            for (NutsPath t : a) {
                ts = CommonRootsByPathHelper.pathOf(t);
                o = (NutsPath)x.get(ts);
                if (o != null && (CommonRootsByPathHelper.deepOf(o) || !CommonRootsByPathHelper.deepOf(t))) continue;
                x.put(ts, t);
            }
        }
        if (b != null) {
            for (NutsPath t : b) {
                ts = CommonRootsByPathHelper.pathOf(t);
                o = (NutsPath)x.get(ts);
                if (o != null && (CommonRootsByPathHelper.deepOf(o) || !CommonRootsByPathHelper.deepOf(t))) continue;
                x.put(ts, t);
            }
        }
        return new HashSet<NutsPath>(x.values());
    }

    private static NutsPath commonRoot(NutsPath a, NutsPath b, NutsSession session) {
        String b_path;
        boolean b_deep;
        String a_path;
        boolean a_deep;
        if (a.getName().equals("*")) {
            a_deep = true;
            a_path = a.getParent() == null ? "" : a.getParent().toString();
        } else {
            a_deep = false;
            a_path = a.toString();
        }
        if (b.getName().equals("*")) {
            b_deep = true;
            b_path = b.getParent() == null ? "" : b.getParent().toString();
        } else {
            b_deep = false;
            b_path = a.toString();
        }
        String[] aa = a_path.split("[.]");
        String[] bb = b_path.split("[.]");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < Math.min(aa.length, bb.length); ++i) {
            if (!aa[i].equals(bb[i])) continue;
            if (sb.length() > 0) {
                sb.append(".");
            }
            sb.append(aa[i]);
        }
        if (a_deep || b_deep) {
            return NutsPath.of((String)sb.toString(), (NutsSession)session).resolve("*");
        }
        return NutsPath.of((String)sb.toString(), (NutsSession)session);
    }

    private static Set<NutsPath> resolveRootId(String groupId, String artifactId, String version, NutsSession session) {
        String g = groupId;
        if (g == null) {
            g = "";
        }
        if ((g = g.trim()).isEmpty() || g.equals("*")) {
            return new HashSet<NutsPath>(Collections.singletonList(NutsPath.of((String)"*", (NutsSession)session)));
        }
        int i = g.indexOf("*");
        if (i >= 0) {
            int j = (g = g.substring(0, i)).indexOf(".");
            if (j >= 0) {
                g = g.substring(0, j);
            }
            if (g.isEmpty()) {
                g = "*";
            } else {
                if (!(g = g.replace('.', '/')).endsWith("/")) {
                    g = g + "/";
                }
                g = g + "*";
            }
            return new HashSet<NutsPath>(Collections.singletonList(NutsPath.of((String)g, (NutsSession)session)));
        }
        if (artifactId.length() > 0 && !artifactId.contains("*")) {
            if (!(version.length() <= 0 || version.contains("*") || version.contains("[") || version.contains("]"))) {
                return new HashSet<NutsPath>(Collections.singletonList(NutsPath.of((String)(g.replace('.', '/') + "/" + artifactId + "/" + version), (NutsSession)session)));
            }
            return new HashSet<NutsPath>(Collections.singletonList(NutsPath.of((String)(g.replace('.', '/') + "/" + artifactId), (NutsSession)session)));
        }
        return new HashSet<NutsPath>(Collections.singletonList(NutsPath.of((String)g.replace('.', '/'), (NutsSession)session)));
    }

    public static List<NutsPath> resolveRootPaths(NutsIdFilter filter, NutsSession session) {
        return new ArrayList<NutsPath>(CommonRootsByPathHelper.resolveRootIds(filter, session));
    }

    public static Set<NutsPath> resolveRootIds(NutsIdFilter filter, NutsSession session) {
        Set<NutsPath> v = CommonRootsByPathHelper.resolveRootId0(filter, session);
        if (v == null) {
            HashSet<NutsPath> s = new HashSet<NutsPath>();
            s.add(NutsPath.of((String)"*", (NutsSession)session));
            return s;
        }
        return v;
    }

    public static Set<NutsPath> resolveRootId0(NutsIdFilter filter, NutsSession session) {
        if (filter == null) {
            return null;
        }
        if (filter instanceof NutsIdFilterAnd) {
            NutsIdFilterAnd f = (NutsIdFilterAnd)filter;
            Set<NutsPath> xx = null;
            for (NutsIdFilter g : f.getChildren()) {
                xx = CommonRootsByPathHelper.resolveRootIdAnd(xx, CommonRootsByPathHelper.resolveRootId0(g, session), session);
            }
            return xx;
        }
        if (filter instanceof NutsIdFilterOr) {
            NutsIdFilterOr f = (NutsIdFilterOr)filter;
            NutsIdFilter[] y = f.getChildren();
            if (y.length == 0) {
                return null;
            }
            Set<NutsPath> xx = CommonRootsByPathHelper.resolveRootId0(y[0], session);
            for (int i = 1; i < y.length; ++i) {
                xx = CommonRootsByPathHelper.resolveRootIdOr(xx, CommonRootsByPathHelper.resolveRootId0(y[i], session));
            }
            return xx;
        }
        if (filter instanceof NutsPatternIdFilter) {
            NutsPatternIdFilter f = (NutsPatternIdFilter)filter;
            return CommonRootsByPathHelper.resolveRootId(f.getId().getGroupId(), f.getId().getArtifactId(), f.getId().getVersion().toString(), session);
        }
        return null;
    }
}

