/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdBuilder;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.id.filter.NutsIdFilterAnd;
import net.thevpc.nuts.runtime.standalone.id.filter.NutsIdFilterOr;
import net.thevpc.nuts.runtime.standalone.id.filter.NutsPatternIdFilter;

public class CommonRootsByIdHelper {
    private static Set<NutsId> resolveRootIdAnd(Set<NutsId> a, Set<NutsId> b, NutsSession session) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.isEmpty()) {
            return Collections.emptySet();
        }
        if (b.isEmpty()) {
            return Collections.emptySet();
        }
        NutsId[] aa = a.toArray(new NutsId[0]);
        NutsId[] bb = b.toArray(new NutsId[0]);
        HashSet<NutsId> h = new HashSet<NutsId>();
        for (NutsId path : aa) {
            for (NutsId nutsPath : bb) {
                h.add(CommonRootsByIdHelper.commonRoot(path, nutsPath, session));
            }
        }
        return CommonRootsByIdHelper.compact(h);
    }

    private static Set<NutsId> compact(Set<NutsId> a) {
        HashMap<String, NutsId> x = new HashMap<String, NutsId>();
        if (a != null) {
            for (NutsId t : a) {
                String ts = CommonRootsByIdHelper.pathOf(t);
                NutsId o = (NutsId)x.get(ts);
                if (o != null && (CommonRootsByIdHelper.deepOf(o) || !CommonRootsByIdHelper.deepOf(t))) continue;
                x.put(ts, t);
            }
        }
        return new HashSet<NutsId>(x.values());
    }

    private static boolean deepOf(NutsId p) {
        String g = p.getGroupId();
        String a = p.getArtifactId();
        return g.contains("*") || a.contains("*");
    }

    private static String pathOf(NutsId p) {
        String a = p.getArtifactId();
        String g = p.getGroupId();
        if (a.equals("*")) {
            if (g.equals("*")) {
                return "*";
            }
            int x = g.lastIndexOf(46);
            if (x >= 0) {
                String pp = g.substring(0, x);
                if (pp.isEmpty()) {
                    return "*";
                }
                return pp;
            }
            return "*";
        }
        return g;
    }

    private static Set<NutsId> resolveRootIdOr(Set<NutsId> a, Set<NutsId> b) {
        NutsId o;
        String ts;
        HashMap<String, NutsId> x = new HashMap<String, NutsId>();
        if (a != null) {
            for (NutsId t : a) {
                ts = CommonRootsByIdHelper.pathOf(t);
                o = (NutsId)x.get(ts);
                if (o != null && (CommonRootsByIdHelper.deepOf(o) || !CommonRootsByIdHelper.deepOf(t))) continue;
                x.put(ts, t);
            }
        }
        if (b != null) {
            for (NutsId t : b) {
                ts = CommonRootsByIdHelper.pathOf(t);
                o = (NutsId)x.get(ts);
                if (o != null && (CommonRootsByIdHelper.deepOf(o) || !CommonRootsByIdHelper.deepOf(t))) continue;
                x.put(ts, t);
            }
        }
        return new HashSet<NutsId>(x.values());
    }

    private static NutsId commonRoot(NutsId a, NutsId b, NutsSession session) {
        if (a.getShortName().equals(b.getShortName())) {
            return a;
        }
        String[] aa = a.getGroupId().split("[.]");
        String[] bb = b.getGroupId().split("[.]");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < Math.min(aa.length, bb.length); ++i) {
            if (!aa[i].equals(bb[i])) continue;
            if (sb.length() > 0) {
                sb.append(".");
            }
            sb.append(aa[i]);
        }
        return NutsId.of((String)(sb.toString() + ":*"), (NutsSession)session);
    }

    private static Set<NutsId> resolveRootId(String groupId, String artifactId, String version, NutsSession session) {
        return new HashSet<NutsId>(Collections.singletonList(NutsIdBuilder.of((NutsSession)session).setGroupId(NutsBlankable.isBlank((String)groupId) ? "*" : groupId).setArtifactId(NutsBlankable.isBlank((String)artifactId) ? "*" : artifactId).build()));
    }

    public static List<NutsId> resolveRootPaths(NutsIdFilter filter, NutsSession session) {
        return new ArrayList<NutsId>(CommonRootsByIdHelper.resolveRootIds(filter, session));
    }

    public static Set<NutsId> resolveRootIds(NutsIdFilter filter, NutsSession session) {
        Set<NutsId> v = CommonRootsByIdHelper.resolveRootId0(filter, session);
        if (v == null) {
            HashSet<NutsId> s = new HashSet<NutsId>();
            s.add(NutsId.of((String)"*:*", (NutsSession)session));
            return s;
        }
        return v;
    }

    public static Set<NutsId> resolveRootId0(NutsIdFilter filter, NutsSession session) {
        if (filter == null) {
            return null;
        }
        if (filter instanceof NutsIdFilterAnd) {
            NutsIdFilterAnd f = (NutsIdFilterAnd)filter;
            Set<NutsId> xx = null;
            for (NutsIdFilter g : f.getChildren()) {
                xx = CommonRootsByIdHelper.resolveRootIdAnd(xx, CommonRootsByIdHelper.resolveRootId0(g, session), session);
            }
            return xx;
        }
        if (filter instanceof NutsIdFilterOr) {
            NutsIdFilterOr f = (NutsIdFilterOr)filter;
            NutsIdFilter[] y = f.getChildren();
            if (y.length == 0) {
                return null;
            }
            Set<NutsId> xx = CommonRootsByIdHelper.resolveRootId0(y[0], session);
            for (int i = 1; i < y.length; ++i) {
                xx = CommonRootsByIdHelper.resolveRootIdOr(xx, CommonRootsByIdHelper.resolveRootId0(y[i], session));
            }
            return xx;
        }
        if (filter instanceof NutsPatternIdFilter) {
            NutsPatternIdFilter f = (NutsPatternIdFilter)filter;
            return CommonRootsByIdHelper.resolveRootId(f.getId().getGroupId(), f.getId().getArtifactId(), f.getId().getVersion().toString(), session);
        }
        return null;
    }
}

