/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl.nuts;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.logging.Level;
import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsContent;
import net.thevpc.nuts.NutsCp;
import net.thevpc.nuts.NutsDefaultContent;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorParser;
import net.thevpc.nuts.NutsDigest;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsFetchModeNotSupportedException;
import net.thevpc.nuts.NutsFilter;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsIdFilters;
import net.thevpc.nuts.NutsIterator;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPathOption;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSpeedQualifier;
import net.thevpc.nuts.NutsTmp;
import net.thevpc.nuts.NutsUser;
import net.thevpc.nuts.NutsUserConfig;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.standalone.id.filter.NutsExprIdFilter;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.io.util.CoreSecurityUtils;
import net.thevpc.nuts.runtime.standalone.repository.impl.NutsCachedRepository;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.runtime.standalone.util.iter.IteratorBuilder;
import net.thevpc.nuts.runtime.standalone.util.iter.NutsIteratorBase;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsRepositoryConfigManagerExt;
import net.thevpc.nuts.runtime.standalone.xtra.digest.NutsDigestUtils;
import net.thevpc.nuts.spi.NutsPushRepositoryCommand;
import net.thevpc.nuts.spi.NutsTransportParamBinaryFilePart;
import net.thevpc.nuts.spi.NutsTransportParamBinaryStreamPart;
import net.thevpc.nuts.spi.NutsTransportParamParamPart;
import net.thevpc.nuts.spi.NutsTransportParamPart;
import net.thevpc.nuts.spi.NutsTransportParamTextReaderPart;

public class NutsHttpSrvRepository
extends NutsCachedRepository {
    private final NutsLogger LOG;
    private NutsId remoteId;

    public NutsHttpSrvRepository(NutsAddRepositoryOptions options, NutsSession session, NutsRepository parentRepository) {
        super(options, session, parentRepository, NutsSpeedQualifier.SLOW, false, "nuts");
        this.LOG = NutsLogger.of(NutsHttpSrvRepository.class, (NutsSession)session);
        try {
            this.remoteId = this.getRemoteId(session);
        }
        catch (Exception ex) {
            this.LOG.with().session(session).level(Level.WARNING).verb(NutsLogVerb.FAIL).log(NutsMessage.jstyle((String)"unable to initialize Repository NutsId for repository {0}", (Object[])new Object[]{options.getLocation()}));
        }
    }

    public String getUrl(String path) {
        return this.config().getLocationPath().resolve(path).toString();
    }

    public NutsId getRemoteId(NutsSession session) {
        if (this.remoteId == null) {
            try {
                this.remoteId = NutsId.of((String)this.httpGetString(this.getUrl("/version"), session), (NutsSession)session);
            }
            catch (Exception ex) {
                this.LOG.with().session(session).level(Level.WARNING).verb(NutsLogVerb.FAIL).log(NutsMessage.jstyle((String)"unable to resolve Repository NutsId for remote repository {0}", (Object[])new Object[]{this.config().getLocation()}));
            }
        }
        return this.remoteId;
    }

    @Override
    public void pushImpl(NutsPushRepositoryCommand command) {
        NutsSession session = command.getSession();
        NutsContent content = this.lib.fetchContentImpl(command.getId(), null, session);
        NutsDescriptor desc = this.lib.fetchDescriptorImpl(command.getId(), session);
        if (content == null || desc == null) {
            throw new NutsNotFoundException(session, command.getId());
        }
        NutsWorkspaceUtils.checkSession(this.getWorkspace(), session);
        ByteArrayOutputStream descStream = new ByteArrayOutputStream();
        desc.formatter().setSession(session).print((Writer)new OutputStreamWriter(descStream));
        this.httpUpload(CoreIOUtils.buildUrl(this.config().getLocationPath().toString(), "/deploy?" + this.resolveAuthURLPart(session)), session, new NutsTransportParamPart[]{new NutsTransportParamBinaryStreamPart("descriptor", "Project.nuts", (InputStream)new ByteArrayInputStream(descStream.toByteArray())), new NutsTransportParamBinaryFilePart("content", content.getPath().getName(), content.getFile()), new NutsTransportParamParamPart("descriptor-hash", NutsDigest.of((NutsSession)session).sha1().setSource(desc).computeString()), new NutsTransportParamParamPart("content-hash", NutsDigestUtils.evalSHA1Hex(content.getPath(), session)), new NutsTransportParamParamPart("force", String.valueOf(session.isYes()))});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public NutsDescriptor fetchDescriptorCore(NutsId id, NutsFetchMode fetchMode, NutsSession session) {
        if (fetchMode != NutsFetchMode.REMOTE) {
            throw new NutsNotFoundException(session, id, (Throwable)new NutsFetchModeNotSupportedException(session, (NutsRepository)this, fetchMode, id.toString(), null));
        }
        boolean transitive = session.isTransitive();
        session.getTerminal().printProgress("loading descriptor for ", new Object[]{id.getLongId()});
        try (InputStream stream = NutsPath.of((String)this.getUrl("/fetch-descriptor?id=" + CoreIOUtils.urlEncodeString(id.toString(), session) + (transitive ? "&transitive" : "") + "&" + this.resolveAuthURLPart(session)), (NutsSession)session).getInputStream();){
            NutsDescriptor descriptor = NutsDescriptorParser.of((NutsSession)session).parse(stream);
            if (descriptor == null) return null;
            String hash = this.httpGetString(this.getUrl("/fetch-descriptor-hash?id=" + CoreIOUtils.urlEncodeString(id.toString(), session) + (transitive ? "&transitive" : "") + "&" + this.resolveAuthURLPart(session)), session);
            if (!hash.equals(descriptor.toString())) return null;
            NutsDescriptor nutsDescriptor = descriptor;
            return nutsDescriptor;
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public NutsIterator<NutsId> searchVersionsCore(NutsId id, NutsIdFilter idFilter, NutsFetchMode fetchMode, NutsSession session) {
        if (fetchMode != NutsFetchMode.REMOTE) {
            throw new NutsNotFoundException(session, id, (Throwable)new NutsFetchModeNotSupportedException(session, (NutsRepository)this, fetchMode, id.toString(), null));
        }
        boolean transitive = session.isTransitive();
        InputStream ret = null;
        try {
            session.getTerminal().printProgress("search version for %s", new Object[]{id.getLongId(), session});
            ret = NutsPath.of((String)this.getUrl("/find-versions?id=" + CoreIOUtils.urlEncodeString(id.toString(), session) + (transitive ? "&transitive" : "") + "&" + this.resolveAuthURLPart(session)), (NutsSession)session).getInputStream();
        }
        catch (UncheckedIOException | NutsIOException e) {
            return IteratorBuilder.emptyIterator();
        }
        NutsIterator<NutsId> it = new NutsIterator<NutsId>(ret, session);
        NutsIdFilter filter2 = ((NutsIdFilter)NutsIdFilters.of((NutsSession)session).nonnull((NutsFilter)idFilter)).and(NutsIdFilters.of((NutsSession)session).byName(new String[]{id.getShortName()}));
        if (filter2 != null) {
            it = IteratorBuilder.of(it, session).filter(CoreFilterUtils.createFilter(filter2, session)).iterator();
        }
        return it;
    }

    @Override
    public NutsIterator<NutsId> searchCore(NutsIdFilter filter, NutsPath[] basePaths, NutsId[] baseIds, NutsFetchMode fetchMode, NutsSession session) {
        if (fetchMode != NutsFetchMode.REMOTE) {
            return null;
        }
        session.getTerminal().printProgress("search into %s ", new Object[]{Arrays.toString(basePaths)});
        boolean transitive = session.isTransitive();
        InputStream ret = null;
        String[] ulp = this.resolveEncryptedAuth(session);
        if (filter instanceof NutsExprIdFilter) {
            String js = ((NutsExprIdFilter)filter).toExpr();
            if (js != null) {
                ret = this.httpUpload(this.getUrl("/find?" + (transitive ? "transitive" : "") + "&" + this.resolveAuthURLPart(session)), session, new NutsTransportParamPart[]{new NutsTransportParamParamPart("root", "/"), new NutsTransportParamParamPart("ul", ulp[0]), new NutsTransportParamParamPart("up", ulp[1]), new NutsTransportParamTextReaderPart("js", "search.js", (Reader)new StringReader(js))});
                return IteratorBuilder.of(new NamedNutIdFromStreamIterator(ret, session), session).filter(CoreFilterUtils.createFilter(filter, session)).iterator();
            }
        } else {
            ret = this.httpUpload(this.getUrl("/find?" + (transitive ? "transitive" : "") + "&" + this.resolveAuthURLPart(session)), session, new NutsTransportParamPart[]{new NutsTransportParamParamPart("root", "/"), new NutsTransportParamParamPart("ul", ulp[0]), new NutsTransportParamParamPart("up", ulp[1]), new NutsTransportParamParamPart("pattern", "*"), new NutsTransportParamParamPart("transitive", String.valueOf(transitive))});
        }
        if (filter == null) {
            return new NamedNutIdFromStreamIterator(ret, session);
        }
        return IteratorBuilder.of(new NamedNutIdFromStreamIterator(ret, session), session).filter(CoreFilterUtils.createFilter(filter, session)).iterator();
    }

    @Override
    public NutsContent fetchContentCore(NutsId id, NutsDescriptor descriptor, String localPath, NutsFetchMode fetchMode, NutsSession session) {
        if (fetchMode != NutsFetchMode.REMOTE) {
            throw new NutsNotFoundException(session, id, (Throwable)new NutsFetchModeNotSupportedException(session, (NutsRepository)this, fetchMode, id.toString(), null));
        }
        boolean transitive = session.isTransitive();
        boolean temp = false;
        if (localPath == null) {
            temp = true;
            String p = this.getIdFilename(id, session);
            localPath = NutsTmp.of((NutsSession)session).setRepositoryId(this.getUuid()).createTempFile(new File(p).getName()).toString();
        }
        try {
            String location = this.getUrl("/fetch?id=" + CoreIOUtils.urlEncodeString(id.toString(), session) + (transitive ? "&transitive" : "") + "&" + this.resolveAuthURLPart(session));
            NutsCp.of((NutsSession)session).from(location).to(localPath).addOptions(new NutsPathOption[]{NutsPathOption.SAFE, NutsPathOption.LOG, NutsPathOption.TRACE}).run();
            String rhash = this.httpGetString(this.getUrl("/fetch-hash?id=" + CoreIOUtils.urlEncodeString(id.toString(), session) + (transitive ? "&transitive" : "") + "&" + this.resolveAuthURLPart(session)), session);
            String lhash = NutsDigestUtils.evalSHA1Hex(NutsPath.of((String)localPath, (NutsSession)session), session);
            if (rhash.equalsIgnoreCase(lhash)) {
                return new NutsDefaultContent(NutsPath.of((String)localPath, (NutsSession)session), false, temp);
            }
        }
        catch (UncheckedIOException | NutsIOException ex) {
            throw new NutsNotFoundException(session, id, ex);
        }
        return null;
    }

    private String httpGetString(String url, NutsSession session) {
        this.LOG.with().session(session).level(Level.FINEST).verb(NutsLogVerb.START).log(NutsMessage.jstyle((String)"get URL{0}", (Object[])new Object[]{url}));
        return CoreIOUtils.loadString(NutsPath.of((String)url, (NutsSession)session).getInputStream(), true, session);
    }

    private InputStream httpUpload(String url, NutsSession session, NutsTransportParamPart ... parts) {
        this.LOG.with().session(session).level(Level.FINEST).verb(NutsLogVerb.START).log(NutsMessage.jstyle((String)"uploading URL {0}", (Object[])new Object[]{url}));
        return CoreIOUtils.getHttpClientFacade(session, url).upload(parts);
    }

    @Override
    public String toString() {
        return super.toString() + (this.remoteId == null ? "" : " ; desc=" + this.remoteId);
    }

    private String[] resolveEncryptedAuth(NutsSession session) {
        String login = session.security().setSession(session).getCurrentUsername();
        NutsUserConfig security = NutsRepositoryConfigManagerExt.of(this.config()).getModel().getUser(login, session);
        String newLogin = "";
        char[] credentials = new char[]{};
        if (security == null) {
            newLogin = "anonymous";
            credentials = "anonymous".toCharArray();
        } else {
            NutsUser security2;
            newLogin = security.getRemoteIdentity();
            if (NutsBlankable.isBlank((String)newLogin) && (security2 = session.security().findUser(login)) != null) {
                newLogin = security2.getRemoteIdentity();
            }
            if (NutsBlankable.isBlank((String)newLogin)) {
                newLogin = login;
            } else {
                security = NutsRepositoryConfigManagerExt.of(this.config()).getModel().getUser(newLogin, session);
                if (security == null) {
                    newLogin = "anonymous";
                    credentials = "anonymous".toCharArray();
                }
            }
            if (security != null) {
                credentials = security.getRemoteCredentials() == null ? null : security.getRemoteCredentials().toCharArray();
                credentials = session.security().getCredentials(credentials);
            }
        }
        String passphrase = this.config().getConfigProperty("passphrase", CoreSecurityUtils.DEFAULT_PASSPHRASE);
        newLogin = new String(CoreSecurityUtils.defaultEncryptChars(NutsUtilStrings.trim((String)newLogin).toCharArray(), passphrase, session));
        credentials = CoreSecurityUtils.defaultEncryptChars(credentials, passphrase, session);
        return new String[]{newLogin, new String(credentials)};
    }

    private String resolveAuthURLPart(NutsSession session) {
        String[] auth = this.resolveEncryptedAuth(session);
        return "ul=" + CoreIOUtils.urlEncodeString(auth[0], session) + "&up=" + CoreIOUtils.urlEncodeString(auth[0], session);
    }

    @Override
    public boolean isAcceptFetchMode(NutsFetchMode mode, NutsSession session) {
        return true;
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    private class NamedNutIdFromStreamIterator
    extends NutsIteratorBase<NutsId> {
        private final BufferedReader br;
        private String line;
        private NutsSession session;
        private InputStream source0;

        public NamedNutIdFromStreamIterator(InputStream ret, NutsSession session) {
            this.br = new BufferedReader(new InputStreamReader(ret));
            this.line = null;
            this.session = session;
        }

        public NutsElement describe(NutsElements elems) {
            return elems.ofObject().set("type", "ScanArchetypeCatalog").set("source", this.source0.toString()).build();
        }

        public boolean hasNext() {
            do {
                try {
                    this.line = this.br.readLine();
                }
                catch (IOException e) {
                    this.close();
                    return false;
                }
                if (this.line == null) {
                    this.close();
                    return false;
                }
                this.line = this.line.trim();
            } while (this.line.length() <= 0);
            return true;
        }

        private void close() {
            try {
                this.br.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public NutsId next() {
            NutsId nutsId = NutsId.of((String)this.line, (NutsSession)this.session);
            return nutsId.builder().setRepository(NutsHttpSrvRepository.this.getName()).build();
        }
    }
}

