/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl.nuts;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.logging.Level;
import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsContent;
import net.thevpc.nuts.NutsCp;
import net.thevpc.nuts.NutsDefaultContent;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorParser;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsFetchModeNotSupportedException;
import net.thevpc.nuts.NutsFilter;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsIdFilters;
import net.thevpc.nuts.NutsIdLocation;
import net.thevpc.nuts.NutsInputStreamMonitor;
import net.thevpc.nuts.NutsIterator;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPathOption;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSpeedQualifier;
import net.thevpc.nuts.NutsUnsupportedOperationException;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.repository.NutsIdPathIterator;
import net.thevpc.nuts.runtime.standalone.repository.NutsIdPathIteratorBase;
import net.thevpc.nuts.runtime.standalone.repository.NutsIdPathIteratorModel;
import net.thevpc.nuts.runtime.standalone.repository.impl.NutsCachedRepository;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.runtime.standalone.util.iter.IteratorBuilder;
import net.thevpc.nuts.runtime.standalone.util.iter.IteratorUtils;

public class NutsHttpFolderRepository
extends NutsCachedRepository {
    private final NutsLogger LOG;
    private final NutsIdPathIteratorModel findModel = new NutsIdPathIteratorBase(){

        @Override
        public void undeploy(NutsId id, NutsSession session) throws NutsExecutionException {
            throw new NutsUnsupportedOperationException(session, NutsMessage.cstyle((String)"not supported undeploy.", (Object[])new Object[0]));
        }

        @Override
        public boolean isDescFile(NutsPath pathname) {
            return NutsHttpFolderRepository.this.isDescFile0(pathname);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NutsDescriptor parseDescriptor(NutsPath pathname, InputStream in, NutsFetchMode fetchMode, NutsRepository repository, NutsSession session, NutsPath rootURL) throws IOException {
            try {
                NutsDescriptor nutsDescriptor = NutsDescriptorParser.of((NutsSession)session).parse(in);
                return nutsDescriptor;
            }
            finally {
                in.close();
            }
        }
    };

    public NutsHttpFolderRepository(NutsAddRepositoryOptions options, NutsSession session, NutsRepository parentRepository) {
        super(options, session, parentRepository, NutsSpeedQualifier.SLOW, false, "nuts");
        this.LOG = NutsLogger.of(NutsHttpFolderRepository.class, (NutsSession)session);
    }

    private boolean isDescFile0(NutsPath path) {
        String pathname = path.toString();
        return pathname.equals("nuts.json") || pathname.endsWith("/nuts.json") || pathname.endsWith(".nuts");
    }

    protected InputStream getDescStream(NutsId id, NutsSession session) {
        String url = this.getDescPath(id, session);
        return this.openStream(url, id, "artifact descriptor", session);
    }

    protected NutsPath getPath(NutsId id, NutsSession session) {
        return this.getIdRemotePath(id, session);
    }

    protected String getDescPath(NutsId id, NutsSession session) {
        String groupId = id.getGroupId();
        String artifactId = id.getArtifactId();
        String version = id.getVersion().getValue();
        return CoreIOUtils.buildUrl(this.config().getLocationPath().toString(), groupId.replace('.', '/') + "/" + artifactId + "/" + version + "/" + "nuts.json");
    }

    protected InputStream openStream(String path, Object source, String sourceTypeName, NutsSession session) {
        return NutsInputStreamMonitor.of((NutsSession)session).setSource(path).setOrigin(source).setSourceTypeName(sourceTypeName).create();
    }

    protected InputStream openStream(NutsId id, String path, Object source, String sourceTypeName, NutsSession session) {
        return NutsInputStreamMonitor.of((NutsSession)session).setSource(path).setOrigin(source).setSourceTypeName(sourceTypeName).create();
    }

    public NutsIterator<NutsId> findVersionsImplFilesFolders(NutsId id, NutsIdFilter idFilter, NutsSession session) {
        String groupId = id.getGroupId();
        String artifactId = id.getArtifactId();
        try {
            return IteratorBuilder.ofSupplier(() -> {
                NutsPath artifactUrl = this.config().getLocationPath().resolve(groupId.replace('.', '/') + "/" + artifactId);
                NutsPath[] all = (NutsPath[])artifactUrl.list().toArray(NutsPath[]::new);
                ArrayList<NutsId> n = new ArrayList<NutsId>();
                for (NutsPath versionFilesUrl : all) {
                    if (versionFilesUrl.isDirectory() && versionFilesUrl.getName().equals("LATEST")) continue;
                    NutsPath[] versionFiles = (NutsPath[])versionFilesUrl.list().toArray(NutsPath[]::new);
                    boolean validVersion = false;
                    for (NutsPath v : versionFiles) {
                        if (!"nuts.properties".equals(v.getName())) continue;
                        validVersion = true;
                        break;
                    }
                    if (!validVersion) continue;
                    NutsId id2 = id.builder().setVersion(versionFilesUrl.getName()).build();
                    if (idFilter != null && !idFilter.acceptId(id2, session)) continue;
                    n.add(id2);
                }
                return n.iterator();
            }, e -> e.ofString("findVersionsImplFilesFolders"), session).build();
        }
        catch (Exception ex) {
            this.LOG.with().session(session).level(Level.SEVERE).error((Throwable)ex).log(NutsMessage.jstyle((String)"error find versions : {0}", (Object[])new Object[]{ex}));
            return IteratorBuilder.emptyIterator();
        }
    }

    @Override
    public NutsIterator<NutsId> searchVersionsCore(NutsId id, NutsIdFilter idFilter, NutsFetchMode fetchMode, NutsSession session) {
        if (fetchMode != NutsFetchMode.REMOTE) {
            throw new NutsNotFoundException(session, id, (Throwable)new NutsFetchModeNotSupportedException(session, (NutsRepository)this, fetchMode, id.toString(), null));
        }
        if (id.getVersion().isSingleValue()) {
            String groupId = id.getGroupId();
            String artifactId = id.getArtifactId();
            ArrayList ret = new ArrayList();
            NutsPath locationPath = this.config().getLocationPath();
            if (locationPath == null) {
                return IteratorBuilder.emptyIterator();
            }
            String metadataURL = CoreIOUtils.buildUrl(locationPath.toString(), groupId.replace('.', '/') + "/" + artifactId + "/" + id.getVersion().toString() + "/" + this.getIdFilename(id.builder().setFaceDescriptor().build(), session));
            return IteratorBuilder.ofSupplier(() -> {
                try (InputStream metadataStream = this.openStream(id, metadataURL, id.builder().setFace("catalog").build(), "artifact catalog", session);){
                    ret.add(id);
                }
                catch (IOException | UncheckedIOException exception) {
                    // empty catch block
                }
                return ret.iterator();
            }, e -> e.ofObject().set("type", "ScanURL").set("url", metadataURL).build(), session).build();
        }
        NutsIdFilter filter2 = ((NutsIdFilter)NutsIdFilters.of((NutsSession)session).nonnull((NutsFilter)idFilter)).and(NutsIdFilters.of((NutsSession)session).byName(new String[]{id.getShortName()}));
        return this.findVersionsImplFilesFolders(id, filter2, session);
    }

    @Override
    public NutsId searchLatestVersionCore(NutsId id, NutsIdFilter filter, NutsFetchMode fetchMode, NutsSession session) {
        if (fetchMode != NutsFetchMode.REMOTE) {
            throw new NutsNotFoundException(session, id, (Throwable)new NutsFetchModeNotSupportedException(session, (NutsRepository)this, fetchMode, id.toString(), null));
        }
        NutsIterator<NutsId> allVersions = this.searchVersionsCore(id, filter, fetchMode, session);
        NutsId a = null;
        while (allVersions != null && allVersions.hasNext()) {
            NutsId next = (NutsId)allVersions.next();
            if (a != null && next.getVersion().compareTo(a.getVersion()) <= 0) continue;
            a = next;
        }
        return a;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public NutsDescriptor fetchDescriptorCore(NutsId id, NutsFetchMode fetchMode, NutsSession session) {
        if (fetchMode != NutsFetchMode.REMOTE) {
            throw new NutsNotFoundException(session, id, (Throwable)new NutsFetchModeNotSupportedException(session, (NutsRepository)this, fetchMode, id.toString(), null));
        }
        try (InputStream stream = this.getDescStream(id, session);){
            NutsDescriptor nutsDescriptor = NutsDescriptorParser.of((NutsSession)session).parse(stream);
            return nutsDescriptor;
        }
        catch (IOException | UncheckedIOException | NutsIOException ex) {
            throw new NutsNotFoundException(session, id, ex);
        }
    }

    @Override
    public NutsContent fetchContentCore(NutsId id, NutsDescriptor descriptor, String localFile, NutsFetchMode fetchMode, NutsSession session) {
        if (fetchMode != NutsFetchMode.REMOTE) {
            throw new NutsNotFoundException(session, id, (Throwable)new NutsFetchModeNotSupportedException(session, (NutsRepository)this, fetchMode, id.toString(), null));
        }
        if (descriptor.getLocations().length == 0) {
            NutsPath path = this.getPath(id, session);
            NutsCp.of((NutsSession)session).from(path).to(localFile).addOptions(new NutsPathOption[]{NutsPathOption.SAFE, NutsPathOption.LOG, NutsPathOption.TRACE}).run();
            return new NutsDefaultContent(NutsPath.of((String)localFile, (NutsSession)session), false, false);
        }
        for (NutsIdLocation location : descriptor.getLocations()) {
            if (!CoreFilterUtils.acceptClassifier(location, id.getClassifier())) continue;
            try {
                NutsCp.of((NutsSession)session).from(location.getUrl()).to(localFile).addOptions(new NutsPathOption[]{NutsPathOption.SAFE, NutsPathOption.LOG, NutsPathOption.TRACE}).run();
                return new NutsDefaultContent(NutsPath.of((String)localFile, (NutsSession)session), false, false);
            }
            catch (Exception ex) {
                this.LOG.with().session(session).level(Level.SEVERE).error((Throwable)ex).log(NutsMessage.jstyle((String)"unable to download location for id {0} in location {1} : {2}", (Object[])new Object[]{id, location.getUrl(), ex}));
            }
        }
        return null;
    }

    @Override
    public NutsIterator<NutsId> searchCore(NutsIdFilter filter, NutsPath[] basePaths, NutsId[] baseIds, NutsFetchMode fetchMode, NutsSession session) {
        if (fetchMode != NutsFetchMode.REMOTE) {
            return null;
        }
        ArrayList list = new ArrayList();
        NutsPath repoRoot = this.config().getLocationPath();
        if (repoRoot == null) {
            return IteratorBuilder.emptyIterator();
        }
        for (NutsPath basePath : basePaths) {
            list.add(IteratorBuilder.ofRunnable(() -> session.getTerminal().printProgress("%-8s %s", new Object[]{"browse", (basePath == null ? repoRoot : repoRoot.resolve(basePath)).toCompressedForm()}), "Log", session).build());
            if (basePath.getName().equals("*")) {
                list.add(new NutsIdPathIterator(this, repoRoot, basePath.getParent(), filter, session, this.findModel, Integer.MAX_VALUE, "core", null));
                continue;
            }
            list.add(new NutsIdPathIterator(this, repoRoot, basePath, filter, session, this.findModel, 2, "core", null));
        }
        return IteratorUtils.concat(list);
    }

    @Override
    public boolean isAcceptFetchMode(NutsFetchMode mode, NutsSession session) {
        return true;
    }

    @Override
    public boolean isRemote() {
        return true;
    }
}

