/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl.nuts;

import java.io.IOException;
import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsContent;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsFetchModeNotSupportedException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsIterator;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSpeedQualifier;
import net.thevpc.nuts.runtime.standalone.repository.impl.NutsCachedRepository;

public class NutsFolderRepository
extends NutsCachedRepository {
    public NutsFolderRepository(NutsAddRepositoryOptions options, NutsSession session, NutsRepository parentRepository) {
        super(options, session, parentRepository, NutsSpeedQualifier.FASTER, true, "nuts");
        this.extensions.put("src", "-src.zip");
    }

    @Override
    protected boolean isSupportedDeployImpl(NutsSession session) {
        return true;
    }

    @Override
    protected boolean isAvailableImpl(NutsSession session) {
        try {
            if (this.lib.getStoreLocation().isDirectory()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.cache.getStoreLocation().isDirectory()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    protected boolean isAllowedOverrideNut(NutsId id) {
        return true;
    }

    @Override
    public NutsDescriptor fetchDescriptorCore(NutsId id, NutsFetchMode fetchMode, NutsSession session) {
        if (fetchMode == NutsFetchMode.REMOTE) {
            throw new NutsNotFoundException(session, id, (Throwable)new NutsFetchModeNotSupportedException(session, (NutsRepository)this, fetchMode, id.toString(), null));
        }
        NutsId id2 = id.builder().setFaceDescriptor().build();
        throw new NutsNotFoundException(session, id, (Throwable)new IOException("artifact descriptor not found : " + this.lib.getGoodPath(id2, session)));
    }

    @Override
    public NutsContent fetchContentCore(NutsId id, NutsDescriptor descriptor, String localPath, NutsFetchMode fetchMode, NutsSession session) {
        if (fetchMode == NutsFetchMode.REMOTE) {
            throw new NutsNotFoundException(session, id, (Throwable)new NutsFetchModeNotSupportedException(session, (NutsRepository)this, fetchMode, id.toString(), null));
        }
        NutsId id2 = id.builder().setFaceContent().build();
        throw new NutsNotFoundException(session, id, (Throwable)new IOException("file not found : " + this.lib.getGoodPath(id2, session)));
    }

    @Override
    public NutsIterator<NutsId> searchCore(NutsIdFilter filter, NutsPath[] basePaths, NutsId[] baseIds, NutsFetchMode fetchMode, NutsSession session) {
        return null;
    }

    @Override
    public NutsId searchLatestVersionCore(NutsId id, NutsIdFilter filter, NutsFetchMode fetchMode, NutsSession session) {
        return null;
    }

    @Override
    public void updateStatistics2(NutsSession session) {
    }

    @Override
    public NutsIterator<NutsId> searchVersionsCore(NutsId id, NutsIdFilter idFilter, NutsFetchMode fetchMode, NutsSession session) {
        return null;
    }

    @Override
    public boolean isAcceptFetchMode(NutsFetchMode mode, NutsSession session) {
        return mode == NutsFetchMode.LOCAL;
    }

    @Override
    public boolean isRemote() {
        return false;
    }
}

