/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl.maven.util;

import java.util.logging.Level;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsExecCommand;
import net.thevpc.nuts.NutsFetchStrategy;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;

public class MvnClient {
    private final NutsLogger LOG;
    public static final String NET_VPC_APP_NUTS_MVN = "net.thevpc.nuts.toolbox:mvn";
    private NutsSession session;
    private Status status = Status.INIT;

    public MvnClient(NutsSession session) {
        this.session = session;
        this.LOG = NutsLogger.of(MvnClient.class, (NutsSession)session);
    }

    public boolean get(NutsId id, String repoURL, NutsSession session) {
        if (id.getShortName().equals(NET_VPC_APP_NUTS_MVN)) {
            return false;
        }
        switch (this.status) {
            case INIT: {
                this.status = Status.DIRTY;
                try {
                    NutsDefinition ff = (NutsDefinition)session.search().addId(NET_VPC_APP_NUTS_MVN).setSession(session.copy().setFetchStrategy(NutsFetchStrategy.ONLINE)).setOptional(Boolean.valueOf(false)).setInlineDependencies(true).setLatest(true).getResultDefinitions().required();
                    for (NutsId nutsId : this.session.search().addId(ff.getId()).setInlineDependencies(true).getResultIds()) {
                        this.session.fetch().setId(nutsId).setSession(session.copy().setFetchStrategy(NutsFetchStrategy.ONLINE)).setOptional(Boolean.valueOf(false)).setDependencies(true).getResultDefinition();
                    }
                    this.status = Status.SUCCESS;
                    break;
                }
                catch (Exception ex) {
                    this.LOG.with().session(session).level(Level.SEVERE).error((Throwable)ex).log(NutsMessage.jstyle((String)"failed to load {0} : {1}", (Object[])new Object[]{NET_VPC_APP_NUTS_MVN, ex}));
                    ex.printStackTrace();
                    this.status = Status.FAIL;
                    return false;
                }
            }
            case FAIL: {
                return false;
            }
            case SUCCESS: {
                break;
            }
            case DIRTY: {
                return false;
            }
        }
        try {
            NutsExecCommand b = this.session.exec().setFailFast(true).addCommand(new String[]{NET_VPC_APP_NUTS_MVN, "--json", "get", id.toString(), repoURL == null ? "" : repoURL}).setSession(session).run();
            return b.getResult() == 0;
        }
        catch (Exception ex) {
            this.LOG.with().session(session).level(Level.SEVERE).error((Throwable)ex).log(NutsMessage.jstyle((String)"failed to invoke {0} : {1}", (Object[])new Object[]{NET_VPC_APP_NUTS_MVN, ex}));
            return false;
        }
    }

    public static enum Status {
        INIT,
        DIRTY,
        SUCCESS,
        FAIL;

    }
}

