/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl.maven.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Stack;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsArchFamily;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyBuilder;
import net.thevpc.nuts.NutsDependencyScope;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorBuilder;
import net.thevpc.nuts.NutsDescriptorFlag;
import net.thevpc.nuts.NutsDescriptorProperty;
import net.thevpc.nuts.NutsDescriptorPropertyBuilder;
import net.thevpc.nuts.NutsEnvCondition;
import net.thevpc.nuts.NutsEnvConditionBuilder;
import net.thevpc.nuts.NutsException;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsFetchStrategy;
import net.thevpc.nuts.NutsFunction;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdBuilder;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsIterator;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsParseException;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.standalone.descriptor.util.NutsDescriptorUtils;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.repository.NutsRepositorySelectorHelper;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.Pom;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.PomDependency;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.PomId;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.PomIdFilter;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.PomIdResolver;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.PomProfile;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.PomProfileActivation;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.PomXmlParser;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.util.ArchetypeCatalogParser;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.util.MavenMetadata;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.util.MavenMetadataParser;
import net.thevpc.nuts.runtime.standalone.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.util.MapToFunction;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.runtime.standalone.util.iter.IteratorBuilder;
import net.thevpc.nuts.runtime.standalone.version.DefaultNutsVersion;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringTokenizerUtils;
import net.thevpc.nuts.spi.NutsRepositoryLocation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MavenUtils {
    private final NutsLogger LOG;
    private final NutsSession session;

    private MavenUtils(NutsSession session) {
        this.session = session;
        this.LOG = NutsLogger.of(MavenUtils.class, (NutsSession)session);
    }

    public static MavenUtils of(NutsSession session) {
        MavenUtils wp = (MavenUtils)session.env().getProperties().get(MavenUtils.class.getName());
        if (wp == null) {
            wp = new MavenUtils(session);
            session.env().setProperty(MavenUtils.class.getName(), (Object)wp);
        }
        return wp;
    }

    public static PomIdResolver createPomIdResolver(NutsSession session) {
        PomIdResolver wp = (PomIdResolver)session.env().getProperties().get(PomIdResolver.class.getName());
        if (wp == null) {
            wp = new PomIdResolver(session);
            session.env().setProperty(PomIdResolver.class.getName(), (Object)wp);
        }
        return wp;
    }

    public NutsId[] toNutsId(PomId[] ids) {
        NutsId[] a = new NutsId[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            a[i] = this.toNutsId(ids[i]);
        }
        return a;
    }

    public NutsDependency[] toNutsDependencies(PomDependency[] deps, NutsSession session, Pom pom, PomProfileActivation ac, String profile) {
        NutsDependency[] a = new NutsDependency[deps.length];
        for (int i = 0; i < deps.length; ++i) {
            a[i] = this.toNutsDependency(deps[i], session, pom, ac, profile);
        }
        return a;
    }

    public NutsId toNutsId(PomId d) {
        return NutsIdBuilder.of((NutsSession)this.session).setGroupId(d.getGroupId()).setArtifactId(d.getArtifactId()).setVersion(this.toNutsVersion(d.getVersion())).build();
    }

    public NutsEnvCondition toCondition(NutsSession session, String os0, String arch0, PomProfileActivation a, String profile) {
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3;
        String[] stringArray4;
        NutsOsFamily os = NutsOsFamily.parseLenient((String)os0, null, null);
        NutsArchFamily arch = NutsArchFamily.parseLenient((String)arch0, null, null);
        String osVersion = null;
        String platform = null;
        if (a != null) {
            NutsOsFamily os2;
            if (!NutsBlankable.isBlank((String)a.getOsVersion())) {
                osVersion = a.getOsVersion();
            }
            if (!NutsBlankable.isBlank((String)a.getOsArch())) {
                arch = NutsArchFamily.parseLenient((String)a.getOsArch(), null, null);
            }
            if (!NutsBlankable.isBlank((String)a.getOsName())) {
                os2 = NutsOsFamily.parseLenient((String)a.getOsName(), null, null);
                if (os2 != null) {
                    os = os2;
                }
            } else if (!NutsBlankable.isBlank((String)a.getOsFamily()) && (os2 = NutsOsFamily.parseLenient((String)a.getOsFamily(), null, null)) != null) {
                os = os2;
            }
            if (!NutsBlankable.isBlank((String)a.getJdk())) {
                platform = "java#" + a.getJdk();
            }
        }
        String oss = null;
        if (os != null) {
            oss = osVersion == null ? os.id() : os.id() + "#" + osVersion;
        }
        String ars = null;
        if (arch != null) {
            ars = arch.id();
        }
        NutsEnvConditionBuilder nutsEnvConditionBuilder = NutsEnvConditionBuilder.of((NutsSession)session);
        if (oss == null) {
            stringArray4 = new String[]{};
        } else {
            String[] stringArray5 = new String[1];
            stringArray4 = stringArray5;
            stringArray5[0] = oss;
        }
        NutsEnvConditionBuilder nutsEnvConditionBuilder2 = nutsEnvConditionBuilder.setOs(stringArray4);
        if (ars == null) {
            stringArray3 = new String[]{};
        } else {
            String[] stringArray6 = new String[1];
            stringArray3 = stringArray6;
            stringArray6[0] = ars;
        }
        NutsEnvConditionBuilder nutsEnvConditionBuilder3 = nutsEnvConditionBuilder2.setArch(stringArray3);
        if (platform == null) {
            stringArray2 = new String[]{};
        } else {
            String[] stringArray7 = new String[1];
            stringArray2 = stringArray7;
            stringArray7[0] = platform;
        }
        NutsEnvConditionBuilder nutsEnvConditionBuilder4 = nutsEnvConditionBuilder3.setPlatform(stringArray2);
        if (profile == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray8 = new String[1];
            stringArray = stringArray8;
            stringArray8[0] = profile;
        }
        return nutsEnvConditionBuilder4.setProfile(stringArray).build();
    }

    public NutsDependency toNutsDependency(PomDependency d, NutsSession session, Pom pom, PomProfileActivation a, String profile) {
        String s = d.getScope();
        if (s == null) {
            s = "";
        }
        s = s.trim();
        NutsDependencyScope dependencyScope = NutsDependencyScope.API;
        switch (s) {
            case "": 
            case "compile": {
                dependencyScope = NutsDependencyScope.API;
                break;
            }
            case "test": {
                dependencyScope = NutsDependencyScope.TEST_API;
                break;
            }
            case "system": {
                dependencyScope = NutsDependencyScope.SYSTEM;
                break;
            }
            case "runtime": {
                dependencyScope = NutsDependencyScope.RUNTIME;
                break;
            }
            case "provided": {
                dependencyScope = NutsDependencyScope.PROVIDED;
                break;
            }
            case "import": {
                dependencyScope = NutsDependencyScope.IMPORT;
                break;
            }
            default: {
                dependencyScope = NutsDependencyScope.parseLenient((String)s, (NutsDependencyScope)NutsDependencyScope.API, (NutsDependencyScope)NutsDependencyScope.API);
                if (dependencyScope != null) break;
                this.LOG.with().session(session).level(Level.FINER).verb(NutsLogVerb.FAIL).log(NutsMessage.jstyle((String)"unable to parse maven scope {0} for {1}", (Object[])new Object[]{s, d}));
                dependencyScope = NutsDependencyScope.API;
            }
        }
        return NutsDependencyBuilder.of((NutsSession)session).setGroupId(d.getGroupId()).setArtifactId(d.getArtifactId()).setClassifier(d.getClassifier()).setVersion(this.toNutsVersion(d.getVersion())).setOptional(d.getOptional()).setScope(dependencyScope.id()).setCondition(this.toCondition(session, d.getOs(), d.getArch(), a, profile)).setType(d.getType()).setExclusions(this.toNutsId(d.getExclusions())).build();
    }

    private boolean testNode(Node n, Predicate<Node> tst) {
        if (tst.test(n)) {
            return true;
        }
        if (n instanceof Element) {
            Element e = (Element)n;
            NodeList nl = e.getChildNodes();
            int len = nl.getLength();
            for (int i = 0; i < len; ++i) {
                if (!this.testNode(nl.item(i), tst)) continue;
                return true;
            }
        }
        return false;
    }

    public NutsDescriptor parsePomXml(InputStream stream, NutsFetchMode fetchMode, String urlDesc, NutsRepository repository) {
        long startTime = System.currentTimeMillis();
        try {
            NutsId[] nutsIdArray;
            String categories;
            if (stream == null) {
                return null;
            }
            byte[] bytes = CoreIOUtils.loadByteArray(stream, this.session);
            InputStream bytesStream = CoreIOUtils.createBytesStream(bytes, urlDesc == null ? NutsMessage.formatted((String)"pom.xml") : NutsMessage.formatted((String)urlDesc), "text/xml", urlDesc == null ? "pom.xml" : urlDesc, this.session);
            Pom pom = new PomXmlParser(this.session).parse(bytesStream, this.session);
            LinkedHashSet<NutsDescriptorFlag> flags = new LinkedHashSet<NutsDescriptorFlag>();
            if (NutsUtilStrings.parseBoolean((String)pom.getProperties().get("nuts.executable"), (Boolean)false, (Boolean)false).booleanValue()) {
                flags.add(NutsDescriptorFlag.EXEC);
            } else {
                Element ee = pom.getXml().getDocumentElement();
                if (this.testNode(ee, x -> {
                    if (x instanceof Element) {
                        Node p6;
                        Node p5;
                        Node p4;
                        Node p3;
                        Node p2;
                        Node p1;
                        Element e = (Element)x;
                        if (e.getNodeName().equals("mainClass") && (p1 = e.getParentNode()) != null && (p2 = p1.getParentNode()) != null && (p3 = p2.getParentNode()) != null && (p4 = p3.getParentNode()) != null && (p5 = p4.getParentNode()) != null && (p6 = p5.getParentNode()) != null && p6.getNodeName().equals("build") && p5.getNodeName().equals("plugins") && p4.getNodeName().equals("plugin") && p3.getNodeName().equals("configuration") && p2.getNodeName().equals("archive") && p1.getNodeName().equals("manifest")) {
                            return true;
                        }
                        if (e.getNodeName().equals("goal") && NutsUtilStrings.trim((String)e.getTextContent()).equals("exec-war-only") && (p1 = e.getParentNode()) != null && (p2 = p1.getParentNode()) != null && (p3 = p2.getParentNode()) != null && (p4 = p3.getParentNode()) != null && (p5 = p4.getParentNode()) != null && (p6 = p5.getParentNode()) != null && p6.getNodeName().equals("build") && p5.getNodeName().equals("plugins") && p4.getNodeName().equals("plugin") && p3.getNodeName().equals("executions") && p2.getNodeName().equals("execution") && p1.getNodeName().equals("goals")) {
                            return true;
                        }
                    }
                    return false;
                })) {
                    flags.add(NutsDescriptorFlag.EXEC);
                }
            }
            if (NutsUtilStrings.parseBoolean((String)pom.getProperties().get("nuts.application"), (Boolean)false, (Boolean)false).booleanValue()) {
                flags.add(NutsDescriptorFlag.APP);
                flags.add(NutsDescriptorFlag.EXEC);
            }
            if (NutsUtilStrings.parseBoolean((String)pom.getProperties().get("nuts.gui"), (Boolean)false, (Boolean)false).booleanValue()) {
                flags.add(NutsDescriptorFlag.GUI);
                flags.add(NutsDescriptorFlag.EXEC);
            }
            if (NutsUtilStrings.parseBoolean((String)pom.getProperties().get("nuts.term"), (Boolean)false, (Boolean)false).booleanValue()) {
                flags.add(NutsDescriptorFlag.TERM);
                flags.add(NutsDescriptorFlag.EXEC);
            }
            if (pom.getPackaging().isEmpty()) {
                pom.setPackaging("jar");
            }
            long time = System.currentTimeMillis() - startTime;
            if (fetchMode == null) {
                fetchMode = NutsFetchMode.REMOTE;
            }
            String fetchString = "[" + CoreStringUtils.alignLeft(fetchMode.id(), 7) + "] ";
            this.LOG.with().session(this.session).level(Level.FINEST).verb(NutsLogVerb.SUCCESS).time(time).log(NutsMessage.jstyle((String)"{0}{1} parse pom    {2}", (Object[])new Object[]{fetchString, CoreStringUtils.alignLeft(repository == null ? "<no-repo>" : repository.getName(), 20), NutsTexts.of((NutsSession)this.session).ofStyled(urlDesc, NutsTextStyle.path())}));
            String icons = pom.getProperties().get("nuts.icons");
            if (icons == null) {
                icons = "";
            }
            if ((categories = pom.getProperties().get("nuts.categories")) == null) {
                categories = "";
            }
            PomProfile[] profiles = pom.getProfiles();
            ArrayList<NutsDependency> deps = new ArrayList<NutsDependency>(Arrays.asList(this.toNutsDependencies(pom.getDependencies(), this.session, pom, null, null)));
            for (PomProfile profile : profiles) {
                deps.addAll(Arrays.asList(this.toNutsDependencies(profile.getDependencies(), this.session, pom, profile.getActivation(), profile.getId())));
            }
            ArrayList<NutsDependency> depsM = new ArrayList<NutsDependency>(Arrays.asList(this.toNutsDependencies(pom.getDependenciesManagement(), this.session, pom, null, null)));
            for (PomProfile profile : profiles) {
                depsM.addAll(Arrays.asList(this.toNutsDependencies(profile.getDependenciesManagement(), this.session, pom, profile.getActivation(), profile.getId())));
            }
            ArrayList<NutsDescriptorProperty> props = new ArrayList<NutsDescriptorProperty>();
            for (Map.Entry<String, String> e : pom.getProperties().entrySet()) {
                props.add(NutsDescriptorPropertyBuilder.of((NutsSession)this.session).setName(e.getKey()).setValue(e.getValue()).build());
            }
            for (PomProfile profile : profiles) {
                for (Map.Entry<String, String> e : profile.getProperties().entrySet()) {
                    props.add(NutsDescriptorPropertyBuilder.of((NutsSession)this.session).setName(e.getKey()).setValue(e.getValue()).setCondition(this.toCondition(this.session, null, null, profile.getActivation(), profile.getId())).build());
                }
            }
            String mavenCompilerTarget = pom.getProperties().get("maven.compiler.target");
            mavenCompilerTarget = !NutsBlankable.isBlank((String)mavenCompilerTarget) ? "#" + mavenCompilerTarget.trim() : "";
            NutsDescriptorBuilder nutsDescriptorBuilder = NutsDescriptorBuilder.of((NutsSession)this.session).setId(this.toNutsId(pom.getPomId()));
            if (pom.getParent() == null) {
                nutsIdArray = new NutsId[]{};
            } else {
                NutsId[] nutsIdArray2 = new NutsId[1];
                nutsIdArray = nutsIdArray2;
                nutsIdArray2[0] = this.toNutsId(pom.getParent());
            }
            return nutsDescriptorBuilder.setParents(nutsIdArray).setPackaging(pom.getPackaging()).setFlags(flags).setName(pom.getName()).setDescription(pom.getDescription()).setCondition(NutsEnvConditionBuilder.of((NutsSession)this.session).setPlatform(new String[]{"java" + mavenCompilerTarget})).setDependencies(deps.toArray(new NutsDependency[0])).setStandardDependencies(depsM.toArray(new NutsDependency[0])).setCategories(Arrays.stream(categories.split("[\n\r;,]")).map(String::trim).filter(x -> !x.isEmpty()).collect(Collectors.toList())).setIcons(Arrays.stream(icons.split("[\n\r]")).map(String::trim).filter(x -> !x.isEmpty()).collect(Collectors.toList())).setGenericName(pom.getProperties().get("nuts.genericName")).setProperties(props.toArray(new NutsDescriptorProperty[0])).build();
        }
        catch (Exception e) {
            long time = System.currentTimeMillis() - startTime;
            this.LOG.with().session(this.session).level(Level.FINEST).verb(NutsLogVerb.FAIL).time(time).log(NutsMessage.jstyle((String)"caching pom file {0}", (Object[])new Object[]{urlDesc}));
            throw new NutsParseException(this.session, NutsMessage.cstyle((String)"error parsing %s", (Object[])new Object[]{urlDesc}), (Throwable)e);
        }
    }

    public String toNutsVersion(String version) {
        return version == null ? null : version.replace("(", "]").replace(")", "[");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NutsDescriptor parsePomXmlAndResolveParents(NutsPath path, NutsFetchMode fetchMode, NutsRepository repository) throws IOException {
        try {
            this.session.getTerminal().printProgress("%-8s %s", new Object[]{"parse", path.toCompressedForm()});
            try (InputStream is = path.getInputStream();){
                NutsDescriptor nutsDescriptor = this.parsePomXmlAndResolveParents(is, fetchMode, path.toString(), repository);
                if (nutsDescriptor.getId().getArtifactId() == null) {
                    if (this.LOG.isLoggable(Level.FINE)) {
                        this.LOG.with().session(this.session).level(Level.FINE).verb(NutsLogVerb.FAIL).log(NutsMessage.jstyle((String)"unable to fetch Valid Nuts from {0} : resolved id was {1}", (Object[])new Object[]{path, nutsDescriptor.getId()}));
                    }
                    NutsDescriptor nutsDescriptor2 = null;
                    return nutsDescriptor2;
                }
                NutsDescriptor nutsDescriptor3 = nutsDescriptor;
                return nutsDescriptor3;
            }
        }
        catch (IOException ex) {
            throw new NutsIOException(this.session, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NutsDescriptor parsePomXmlAndResolveParents(InputStream stream, NutsFetchMode fetchMode, String urlDesc, NutsRepository repository) {
        NutsDescriptor nutsDescriptor = null;
        try {
            try {
                NutsDescriptorProperty nutsPackaging;
                NutsId thisId;
                nutsDescriptor = this.parsePomXml(stream, fetchMode, urlDesc, repository);
                HashMap<String, String> properties = new HashMap<String, String>();
                NutsId parentId = null;
                NutsId[] nutsIdArray = nutsDescriptor.getParents();
                int n = nutsIdArray.length;
                for (int i = 0; i < n; ++i) {
                    NutsId nutsId;
                    parentId = nutsId = nutsIdArray[i];
                }
                NutsDescriptor parentDescriptor = null;
                if (parentId != null && !CoreNutsUtils.isEffectiveId(parentId)) {
                    try {
                        parentDescriptor = this.session.fetch().setId(parentId).setEffective(true).setSession(this.session.copy().setTransitive(Boolean.valueOf(true)).setFetchStrategy(fetchMode == NutsFetchMode.REMOTE ? NutsFetchStrategy.ONLINE : NutsFetchStrategy.OFFLINE)).getResultDescriptor();
                    }
                    catch (NutsException ex) {
                        throw ex;
                    }
                    catch (Exception ex) {
                        throw new NutsNotFoundException(this.session, nutsDescriptor.getId(), NutsMessage.cstyle((String)"unable to resolve %s parent %s", (Object[])new Object[]{nutsDescriptor.getId(), parentId, ex}));
                    }
                    parentId = parentDescriptor.getId();
                }
                if (parentId != null) {
                    properties.put("parent.groupId", parentId.getGroupId());
                    properties.put("parent.artifactId", parentId.getArtifactId());
                    properties.put("parent.version", parentId.getVersion().getValue());
                    properties.put("project.parent.groupId", parentId.getGroupId());
                    properties.put("project.parent.artifactId", parentId.getArtifactId());
                    properties.put("project.parent.version", parentId.getVersion().getValue());
                    nutsDescriptor = nutsDescriptor.builder().applyProperties(properties).build();
                }
                if (!CoreNutsUtils.isEffectiveId(thisId = nutsDescriptor.getId())) {
                    if (parentId != null) {
                        if (NutsBlankable.isBlank((String)thisId.getGroupId())) {
                            thisId = thisId.builder().setGroupId(parentId.getGroupId()).build();
                        }
                        if (NutsBlankable.isBlank((String)thisId.getVersion().getValue())) {
                            thisId = thisId.builder().setVersion(parentId.getVersion().getValue()).build();
                        }
                    }
                    HashMap<NutsId, NutsDescriptor> cache = new HashMap<NutsId, NutsDescriptor>();
                    HashSet<String> done = new HashSet<String>();
                    Stack<NutsId> todo = new Stack<NutsId>();
                    todo.push(nutsDescriptor.getId());
                    cache.put(nutsDescriptor.getId(), nutsDescriptor);
                    while (todo.isEmpty()) {
                        NutsId pid = (NutsId)todo.pop();
                        NutsDescriptor d = (NutsDescriptor)cache.get(pid);
                        if (d == null) {
                            try {
                                d = this.session.fetch().setId(pid).setEffective(true).setSession(this.session).getResultDescriptor();
                            }
                            catch (NutsException ex) {
                                throw ex;
                            }
                            catch (Exception ex) {
                                throw new NutsNotFoundException(this.session, nutsDescriptor.getId(), NutsMessage.cstyle((String)"unable to resolve %s parent %s", (Object[])new Object[]{nutsDescriptor.getId(), pid, ex}));
                            }
                        }
                        done.add(pid.getShortName());
                        if (!CoreNutsUtils.containsVars(thisId)) break;
                        thisId.builder().apply(new MapToFunction<String, String>(NutsDescriptorUtils.getPropertiesMap(d.getProperties(), this.session))).build();
                        for (NutsId nutsId : d.getParents()) {
                            if (done.contains(nutsId.getShortName())) continue;
                            todo.push(nutsId);
                        }
                    }
                    if (CoreNutsUtils.containsVars(thisId)) {
                        throw new NutsNotFoundException(this.session, nutsDescriptor.getId(), NutsMessage.cstyle((String)"unable to resolve %s parent %s", (Object[])new Object[]{nutsDescriptor.getId(), parentId}));
                    }
                    nutsDescriptor = nutsDescriptor.builder().setId(thisId).build();
                }
                if ((nutsPackaging = nutsDescriptor.getProperty("nuts-packaging")) != null && !NutsBlankable.isBlank((String)nutsPackaging.getValue())) {
                    nutsDescriptor = nutsDescriptor.builder().setPackaging(nutsDescriptor.getProperty("nuts-packaging").getValue()).build();
                }
                properties.put("pom.groupId", thisId.getGroupId());
                properties.put("pom.version", thisId.getVersion().getValue());
                properties.put("pom.artifactId", thisId.getArtifactId());
                properties.put("project.groupId", thisId.getGroupId());
                properties.put("project.artifactId", thisId.getArtifactId());
                properties.put("project.version", thisId.getVersion().getValue());
                properties.put("version", thisId.getVersion().getValue());
                nutsDescriptor = nutsDescriptor.builder().applyProperties(properties).build();
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException ex) {
            throw new NutsIOException(this.session, (Throwable)ex);
        }
        catch (Exception ex) {
            throw new NutsParseException(this.session, NutsMessage.cstyle((String)"error Parsing %s", (Object[])new Object[]{urlDesc}), (Throwable)ex);
        }
        return nutsDescriptor;
    }

    public Iterator<NutsId> createArchetypeCatalogIterator(InputStream stream, final NutsIdFilter filter, boolean autoClose, final NutsSession session) {
        Iterator<PomId> it = ArchetypeCatalogParser.createArchetypeCatalogIterator(stream, filter == null ? null : new PomIdFilter(){

            @Override
            public boolean accept(PomId id) {
                return filter.acceptId(MavenUtils.this.toNutsId(id), session);
            }
        }, autoClose);
        return IteratorBuilder.of(NutsIterator.of(it, (String)stream.toString()), session).map(NutsFunction.of(this::toNutsId, (String)"PomId->NutsId")).build();
    }

    public MavenMetadata parseMavenMetaData(InputStream metadataStream, NutsSession session) {
        MavenMetadata s = new MavenMetadataParser(session).parseMavenMetaData(metadataStream);
        if (s == null) {
            return s;
        }
        Iterator<String> iterator = s.getVersions().iterator();
        while (iterator.hasNext()) {
            String version = iterator.next();
            if (s.getLatest().length() <= 0 || DefaultNutsVersion.compareVersions(version, s.getLatest()) <= 0) continue;
            iterator.remove();
        }
        return s;
    }

    public DepsAndRepos loadDependenciesAndRepositoriesFromPomPath(NutsId rid, NutsRepositoryLocation[] bootRepositories, NutsSession session) {
        String urlPath = CoreNutsUtils.idToPath(rid) + "/" + rid.getArtifactId() + "-" + rid.getVersion() + ".pom";
        return this.loadDependenciesAndRepositoriesFromPomPath(urlPath, bootRepositories, session);
    }

    public DepsAndRepos loadDependenciesAndRepositoriesFromPomPath(String urlPath, NutsRepositoryLocation[] bootRepositories, NutsSession session) {
        NutsWorkspaceUtils.checkSession(this.session.getWorkspace(), session);
        DepsAndRepos depsAndRepos = null;
        File mavenNutsCorePom = new File(System.getProperty("user.home"), (".m2/repository/" + urlPath).replace("/", File.separator));
        if (mavenNutsCorePom.isFile()) {
            depsAndRepos = this.loadDependenciesAndRepositoriesFromPomUrl(mavenNutsCorePom.getPath(), session);
        }
        if (depsAndRepos == null || depsAndRepos.deps.isEmpty()) {
            for (NutsRepositoryLocation baseUrl : bootRepositories) {
                NutsAddRepositoryOptions opt = NutsRepositorySelectorHelper.createRepositoryOptions(baseUrl, false, session);
                String location = opt.getConfig() == null || NutsBlankable.isBlank((NutsBlankable)opt.getConfig().getLocation()) || NutsBlankable.isBlank((String)opt.getConfig().getLocation().getPath()) ? opt.getLocation() : opt.getConfig().getLocation().getPath();
                depsAndRepos = this.loadDependenciesAndRepositoriesFromPomUrl(location + "/" + urlPath, session);
                if (!depsAndRepos.deps.isEmpty()) break;
            }
        }
        return depsAndRepos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DepsAndRepos loadDependenciesAndRepositoriesFromPomUrl(String url, NutsSession session) {
        NutsPath ppath = NutsPath.of((String)url, (NutsSession)session);
        session.getTerminal().printProgress("%-8s %s", new Object[]{"load", ppath.toCompressedForm()});
        DepsAndRepos depsAndRepos = new DepsAndRepos();
        InputStream xml = null;
        try {
            if (ppath.isHttp()) {
                xml = NutsPath.of((String)url, (NutsSession)session).getInputStream();
            } else {
                File file = new File(url);
                if (file.isFile()) {
                    xml = Files.newInputStream(file.toPath(), new OpenOption[0]);
                } else {
                    DepsAndRepos depsAndRepos2 = depsAndRepos;
                    return depsAndRepos2;
                }
            }
            NutsDescriptor descr = this.parsePomXml(xml, session.getFetchStrategy() == NutsFetchStrategy.OFFLINE ? NutsFetchMode.LOCAL : NutsFetchMode.REMOTE, null, null);
            NutsDescriptorProperty t = descr.getProperty("nuts-runtime-repositories");
            if (t != null && CoreFilterUtils.acceptCondition(t.getCondition(), true, session)) {
                depsAndRepos.deps.addAll(StringTokenizerUtils.split(t.getValue(), ";", true));
            }
            for (NutsDependency dependency : descr.getDependencies()) {
                if (!CoreFilterUtils.acceptCondition(dependency.getCondition(), true, session)) continue;
                String groupId = dependency.getGroupId();
                String version = dependency.getVersion().getValue();
                String artifactId = dependency.getArtifactId();
                String scope = dependency.getScope();
                if (NutsBlankable.isBlank((String)groupId)) {
                    throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unexpected empty groupId", (Object[])new Object[0]));
                }
                if (groupId.contains("$")) {
                    throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unexpected maven variable in groupId=%s", (Object[])new Object[]{groupId}));
                }
                if (NutsBlankable.isBlank((String)artifactId)) {
                    throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unexpected empty artifactId", (Object[])new Object[0]));
                }
                if (artifactId.contains("$")) {
                    throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unexpected maven variable in artifactId=%s", (Object[])new Object[]{artifactId}));
                }
                if (NutsBlankable.isBlank((String)version)) {
                    throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unexpected empty version", (Object[])new Object[0]));
                }
                if (version.contains("$")) {
                    throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unexpected maven version in version=%s", (Object[])new Object[]{version}));
                }
                if (!NutsBlankable.isBlank((String)scope) && groupId.contains("$")) {
                    throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unexpected maven variable in scope=%s", (Object[])new Object[]{scope}));
                }
                if (NutsDependencyScope.parseLenient((String)dependency.getScope(), (NutsDependencyScope)NutsDependencyScope.API, (NutsDependencyScope)NutsDependencyScope.API) != NutsDependencyScope.API) continue;
                depsAndRepos.deps.add(groupId + ":" + artifactId + "#" + version);
            }
        }
        catch (Exception ex) {
            this.LOG.with().session(session).level(Level.SEVERE).error((Throwable)ex).log(NutsMessage.jstyle((String)"failed to loadDependenciesAndRepositoriesFromPomUrl {0} : {1}", (Object[])new Object[]{url, ex}));
        }
        finally {
            if (xml != null) {
                try {
                    xml.close();
                }
                catch (IOException iOException) {}
            }
        }
        return depsAndRepos;
    }

    public NutsId resolveLatestMavenId(NutsId zId, Predicate<String> filter, NutsSession session) {
        File[] children;
        String path = zId.getGroupId().replace('.', '/') + '/' + zId.getArtifactId();
        String bestVersion = null;
        File mavenNutsCoreFolder = new File(System.getProperty("user.home"), ".m2/repository/" + path + "/".replace("/", File.separator));
        if (mavenNutsCoreFolder.isDirectory() && (children = mavenNutsCoreFolder.listFiles()) != null) {
            File[] fileArray = children;
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                String[] goodChildren;
                File file = fileArray[i];
                if (!file.isDirectory() || (goodChildren = file.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".pom");
                    }
                })) == null || goodChildren.length <= 0) continue;
                String p = file.getName();
                if (filter != null && !filter.test(p) || bestVersion != null && DefaultNutsVersion.compareVersions(bestVersion, p) >= 0) continue;
                bestVersion = p;
            }
        }
        for (String repoUrl : new String[]{"https://repo.maven.apache.org/maven2"}) {
            if (!repoUrl.endsWith("/")) {
                repoUrl = repoUrl + "/";
            }
            boolean found = false;
            String mavenMetadataXml = repoUrl + path + "/maven-metadata.xml";
            try {
                URL runtimeMetadata = new URL(mavenMetadataXml);
                found = true;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(NutsPath.of((URL)runtimeMetadata, (NutsSession)session).getInputStream());
                Element c = doc.getDocumentElement();
                for (int i = 0; i < c.getChildNodes().getLength(); ++i) {
                    if (!(c.getChildNodes().item(i) instanceof Element) || !c.getChildNodes().item(i).getNodeName().equals("versioning")) continue;
                    Element c2 = (Element)c.getChildNodes().item(i);
                    for (int j = 0; j < c2.getChildNodes().getLength(); ++j) {
                        if (!(c2.getChildNodes().item(j) instanceof Element) || !c2.getChildNodes().item(j).getNodeName().equals("versions")) continue;
                        Element c3 = (Element)c2.getChildNodes().item(j);
                        for (int k = 0; k < c3.getChildNodes().getLength(); ++k) {
                            if (!(c3.getChildNodes().item(k) instanceof Element) || !c3.getChildNodes().item(k).getNodeName().equals("version")) continue;
                            Element c4 = (Element)c3.getChildNodes().item(k);
                            String p = c4.getTextContent();
                            if (filter != null && !filter.test(p) || bestVersion != null && DefaultNutsVersion.compareVersions(bestVersion, p) >= 0) continue;
                            bestVersion = p;
                        }
                    }
                }
            }
            catch (Exception ex) {
                this.LOG.with().session(session).level(Level.SEVERE).error((Throwable)ex).log(NutsMessage.jstyle((String)"failed to load and parse {0} : {1}", (Object[])new Object[]{mavenMetadataXml, ex}));
            }
            if (found) break;
        }
        if (bestVersion == null) {
            return null;
        }
        return zId.builder().setVersion(bestVersion).build();
    }

    public static class DepsAndRepos {
        public LinkedHashSet<String> deps = new LinkedHashSet();
        public LinkedHashSet<String> repos = new LinkedHashSet();
    }
}

