/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl.maven.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.TreeSet;
import java.util.logging.Level;
import net.thevpc.nuts.NutsContent;
import net.thevpc.nuts.NutsDefaultContent;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.repository.NutsIdPathIterator;
import net.thevpc.nuts.runtime.standalone.repository.NutsIdPathIteratorBase;
import net.thevpc.nuts.runtime.standalone.repository.impl.NutsRepositoryExt;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.util.MavenMetadata;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.util.MavenMetadataParser;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.util.MavenUtils;
import net.thevpc.nuts.runtime.standalone.version.DefaultNutsVersion;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.xtra.digest.NutsDigestUtils;

public class MavenRepositoryFolderHelper {
    private NutsLogger LOG;
    private NutsRepository repo;
    private NutsWorkspace ws;
    private NutsPath rootPath;

    public MavenRepositoryFolderHelper(NutsRepository repo, NutsSession session, NutsPath rootPath) {
        this.repo = repo;
        Object object = session != null ? session.getWorkspace() : (this.ws = repo == null ? null : repo.getWorkspace());
        if (repo == null && session == null) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"both workspace and repo are null", (Object[])new Object[0]));
        }
        this.rootPath = rootPath;
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = NutsLogger.of(MavenRepositoryFolderHelper.class, (NutsSession)session);
        }
        return this.LOG;
    }

    public NutsPath getIdLocalFile(NutsId id, NutsSession session) {
        return this.getStoreLocation().resolve(NutsRepositoryExt.of(this.repo).getIdBasedir(id, session)).resolve(session.locations().getDefaultIdFilename(id));
    }

    public NutsContent fetchContentImpl(NutsId id, Path localPath, NutsSession session) {
        NutsPath cacheContent = this.getIdLocalFile(id, session);
        if (cacheContent != null && cacheContent.exists()) {
            return new NutsDefaultContent(cacheContent, true, false);
        }
        return null;
    }

    public NutsWorkspace getWorkspace() {
        return this.ws;
    }

    protected String getIdFilename(NutsId id, NutsSession session) {
        if (this.repo == null) {
            return session.locations().getDefaultIdFilename(id);
        }
        return NutsRepositoryExt.of(this.repo).getIdFilename(id, session);
    }

    public NutsPath getLocalGroupAndArtifactFile(NutsId id, NutsSession session) {
        NutsWorkspaceUtils.of(session).checkShortId(id);
        NutsPath groupFolder = this.getStoreLocation().resolve(id.getGroupId().replace('.', File.separatorChar));
        return groupFolder.resolve(id.getArtifactId());
    }

    public Iterator<NutsId> searchVersions(NutsId id, NutsIdFilter filter, boolean deep, NutsSession session) {
        if (id.getVersion().isSingleValue()) {
            NutsId id1 = id.builder().setFaceDescriptor().build();
            NutsPath localFile = this.getIdLocalFile(id1, session);
            if (localFile != null && localFile.isRegularFile()) {
                return Collections.singletonList(id.builder().setRepository(this.repo == null ? null : this.repo.getName()).build()).iterator();
            }
            return null;
        }
        return this.searchInFolder(this.getLocalGroupAndArtifactFile(id, session), filter, deep ? Integer.MAX_VALUE : 1, session);
    }

    public Iterator<NutsId> searchInFolder(NutsPath folder, NutsIdFilter filter, int maxDepth, NutsSession session) {
        return new NutsIdPathIterator(this.repo, this.rootPath.normalize(), folder, filter, session, new NutsIdPathIteratorBase(){

            @Override
            public void undeploy(NutsId id, NutsSession session) {
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unsupported undeploy", (Object[])new Object[0]));
            }

            @Override
            public boolean isDescFile(NutsPath pathname) {
                return pathname.getName().equals("pom.xml");
            }

            @Override
            public NutsDescriptor parseDescriptor(NutsPath pathname, InputStream in, NutsFetchMode fetchMode, NutsRepository repository, NutsSession session, NutsPath rootURL) throws IOException {
                return MavenUtils.of(session).parsePomXmlAndResolveParents(pathname, NutsFetchMode.LOCAL, MavenRepositoryFolderHelper.this.repo);
            }
        }, maxDepth, "core", null);
    }

    public NutsPath getStoreLocation() {
        return this.rootPath;
    }

    public NutsId searchLatestVersion(NutsId id, NutsIdFilter filter, NutsSession session) {
        NutsId bestId = null;
        NutsPath file = this.getLocalGroupAndArtifactFile(id, session);
        if (file.exists()) {
            NutsPath[] versionFolders;
            for (NutsPath versionFolder : versionFolders = (NutsPath[])file.list().filter(NutsPath::isDirectory, "isDirectory").toArray(NutsPath[]::new)) {
                NutsId id2 = id.builder().setVersion(versionFolder.getName()).build();
                if (bestId != null && id2.getVersion().compareTo(bestId.getVersion()) <= 0) continue;
                bestId = id2;
            }
        }
        return bestId;
    }

    public void reindexFolder(NutsSession session) {
        this.reindexFolder(this.getStoreLocation(), true, session);
    }

    private void reindexFolder(final NutsPath path, final boolean applyRawNavigation, final NutsSession session) {
        try {
            Files.walkFileTree(path.toFile(), (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    File folder = dir.toFile();
                    File[] children = folder.listFiles();
                    TreeSet<String> files = new TreeSet<String>();
                    TreeSet<String> folders = new TreeSet<String>();
                    String subPath = dir.toString().equals(path.toString()) ? "" : dir.toString().substring(path.toString().length() + 1).replace('\\', '/');
                    int iii = subPath.lastIndexOf(47);
                    String artifactId = null;
                    String groupId = null;
                    if (iii > 0) {
                        artifactId = subPath.substring(iii + 1);
                        groupId = subPath.substring(0, iii).replace('/', '.');
                    } else {
                        artifactId = subPath;
                        groupId = "";
                    }
                    if (children != null && children.length > 0) {
                        ArrayList<File> versions = new ArrayList<File>();
                        for (File c : children) {
                            File[] pomFiles = c.listFiles(x -> x.getName().endsWith(".pom"));
                            if (pomFiles == null || pomFiles.length <= 0) continue;
                            versions.add(c);
                        }
                        if (versions.size() > 0) {
                            Path metadataxml = dir.resolve("maven-metadata.xml");
                            MavenMetadata old = null;
                            try {
                                if (Files.exists(metadataxml, new LinkOption[0])) {
                                    old = new MavenMetadataParser(session).parseMavenMetaData(metadataxml);
                                }
                            }
                            catch (Exception ex) {
                                MavenRepositoryFolderHelper.this._LOGOP(session).level(Level.SEVERE).error((Throwable)ex).log(NutsMessage.jstyle((String)"failed to parse metadata xml for {0} : {1}", (Object[])new Object[]{metadataxml, ex}));
                            }
                            MavenMetadata m = new MavenMetadata();
                            m.setArtifactId(artifactId);
                            m.setGroupId(groupId);
                            m.setLastUpdated(old == null ? null : old.getLastUpdated());
                            m.setRelease(old == null ? null : old.getRelease());
                            m.setLatest(old == null ? null : old.getLatest());
                            LinkedHashSet<String> sversions = new LinkedHashSet<String>();
                            if (old != null) {
                                sversions.addAll(old.getVersions());
                            }
                            for (File version : versions) {
                                sversions.add(version.getName());
                            }
                            ArrayList<String> ll = new ArrayList<String>(sversions);
                            ll.sort(new Comparator<String>(){

                                @Override
                                public int compare(String o1, String o2) {
                                    return -DefaultNutsVersion.compareVersions(o1, o2);
                                }
                            });
                            m.setVersions(ll);
                            if (m.getLastUpdated() == null) {
                                m.setLastUpdated(new Date());
                            }
                            new MavenMetadataParser(session).writeMavenMetaData(m, metadataxml);
                            String md5 = NutsDigestUtils.evalMD5Hex(metadataxml, session).toLowerCase();
                            Files.write(metadataxml.resolveSibling("maven-metadata.xml.md5"), md5.getBytes(), new OpenOption[0]);
                            String sha1 = NutsDigestUtils.evalSHA1Hex(NutsPath.of((Path)metadataxml, (NutsSession)session), session).toLowerCase();
                            Files.write(metadataxml.resolveSibling("maven-metadata.xml.sha1"), sha1.getBytes(), new OpenOption[0]);
                        }
                        if (applyRawNavigation) {
                            for (File child : children) {
                                if (child.getName().startsWith(".")) continue;
                                if (child.isDirectory()) {
                                    folders.add(child.getName());
                                    continue;
                                }
                                if (!child.isFile()) continue;
                                files.add(child.getName());
                            }
                        }
                    }
                    if (applyRawNavigation) {
                        try {
                            PrintStream p = new PrintStream(new File(folder, ".files"));
                            Object object = null;
                            try {
                                p.println("#version=" + MavenRepositoryFolderHelper.this.ws.getApiVersion());
                                for (String file : folders) {
                                    p.println(file + "/");
                                }
                                for (String file : files) {
                                    p.println(file);
                                }
                            }
                            catch (Throwable throwable) {
                                object = throwable;
                                throw throwable;
                            }
                            finally {
                                if (p != null) {
                                    if (object != null) {
                                        try {
                                            p.close();
                                        }
                                        catch (Throwable throwable) {
                                            ((Throwable)object).addSuppressed(throwable);
                                        }
                                    } else {
                                        p.close();
                                    }
                                }
                            }
                        }
                        catch (FileNotFoundException e) {
                            throw new NutsIOException(session, (Throwable)e);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ex) {
            throw new NutsIOException(session, (Throwable)ex);
        }
    }
}

