/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl.maven.util;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Stack;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.format.xml.NutsXmlUtils;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.util.MavenMetadata;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MavenMetadataParser {
    private final NutsLogger LOG;
    private NutsSession session;

    public MavenMetadataParser(NutsSession session) {
        this.session = session;
        this.LOG = NutsLogger.of(MavenMetadataParser.class, (NutsSession)session);
    }

    public String toXmlString(MavenMetadata m) {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        try (OutputStreamWriter w = new OutputStreamWriter(s);){
            this.writeMavenMetaData(m, new StreamResult(s));
            ((Writer)w).flush();
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            throw new NutsIOException(this.session, (Throwable)e);
        }
        return new String(s.toByteArray());
    }

    public void writeMavenMetaData(MavenMetadata m, Path path) {
        try (BufferedWriter w = Files.newBufferedWriter(path, new OpenOption[0]);){
            this.writeMavenMetaData(m, new StreamResult(path.toFile()));
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            throw new NutsIOException(this.session, (Throwable)e);
        }
    }

    public void writeMavenMetaData(MavenMetadata m, StreamResult writer) throws TransformerException, ParserConfigurationException {
        Document document = NutsXmlUtils.createDocument(this.session);
        Element metadata = document.createElement("metadata");
        document.appendChild(metadata);
        if (!NutsBlankable.isBlank((String)m.getGroupId())) {
            Element groupId = document.createElement("groupId");
            groupId.appendChild(document.createTextNode(m.getGroupId()));
            metadata.appendChild(groupId);
        }
        if (!NutsBlankable.isBlank((String)m.getArtifactId())) {
            Element artifactId = document.createElement("artifactId");
            artifactId.appendChild(document.createTextNode(m.getArtifactId()));
            metadata.appendChild(artifactId);
        }
        Element versioning = document.createElement("versioning");
        metadata.appendChild(versioning);
        if (!NutsBlankable.isBlank((String)m.getRelease())) {
            Element release = document.createElement("release");
            release.appendChild(document.createTextNode(m.getRelease()));
            versioning.appendChild(release);
        }
        if (!NutsBlankable.isBlank((String)m.getLatest())) {
            Element latest = document.createElement("latest");
            latest.appendChild(document.createTextNode(m.getLatest()));
            versioning.appendChild(latest);
        }
        Element versions = document.createElement("versions");
        versioning.appendChild(versions);
        if (m.getVersions() != null) {
            for (String sversion : m.getVersions()) {
                if (NutsBlankable.isBlank((String)sversion)) continue;
                Element version = document.createElement("version");
                version.appendChild(document.createTextNode(sversion));
                versions.appendChild(version);
            }
        }
        if (m.getLastUpdated() != null) {
            Element lastUpdated = document.createElement("lastUpdated");
            lastUpdated.appendChild(document.createTextNode(new SimpleDateFormat("yyyyMMddHHmmss").format(m.getLastUpdated())));
            versioning.appendChild(lastUpdated);
        }
        NutsXmlUtils.writeDocument(document, writer, false, true, this.session);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MavenMetadata parseMavenMetaData(Path stream) {
        try (InputStream s = Files.newInputStream(stream, new OpenOption[0]);){
            MavenMetadata mavenMetadata = this.parseMavenMetaData(s);
            return mavenMetadata;
        }
        catch (IOException ex) {
            throw new NutsIOException(this.session, (Throwable)ex);
        }
    }

    public MavenMetadata parseMavenMetaData(InputStream stream) {
        MavenMetadata info = new MavenMetadata();
        StringBuilder ver = new StringBuilder();
        StringBuilder latest = new StringBuilder();
        StringBuilder release = new StringBuilder();
        StringBuilder lastUpdated = new StringBuilder();
        StringBuilder groupId = new StringBuilder();
        StringBuilder artifactId = new StringBuilder();
        ArrayList<String> versions = new ArrayList<String>();
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
            XMLEventReader eventReader = factory.createXMLEventReader(new InputStreamReader(stream));
            Stack<String> nodePath = new Stack<String>();
            while (eventReader.hasNext()) {
                XMLEvent event = eventReader.nextEvent();
                switch (event.getEventType()) {
                    case 1: {
                        StartElement startElement = event.asStartElement();
                        String qName = startElement.getName().getLocalPart();
                        nodePath.push(qName);
                        ver.delete(0, ver.length());
                        break;
                    }
                    case 4: {
                        if (this.isStackPath(nodePath, "metadata", "groupId")) {
                            groupId.append(event.asCharacters().getData());
                            break;
                        }
                        if (this.isStackPath(nodePath, "metadata", "artifactId")) {
                            artifactId.append(event.asCharacters().getData());
                            break;
                        }
                        if (this.isStackPath(nodePath, "metadata", "versioning", "versions", "version")) {
                            ver.append(event.asCharacters().getData());
                            break;
                        }
                        if (this.isStackPath(nodePath, "metadata", "versioning", "release")) {
                            release.append(event.asCharacters().getData());
                            break;
                        }
                        if (this.isStackPath(nodePath, "metadata", "versioning", "latest")) {
                            latest.append(event.asCharacters().getData());
                            break;
                        }
                        if (!this.isStackPath(nodePath, "metadata", "versioning", "lastUpdated")) break;
                        lastUpdated.append(event.asCharacters().getData());
                        break;
                    }
                    case 2: {
                        if (this.isStackPath(nodePath, "metadata", "versioning", "versions", "version")) {
                            nodePath.pop();
                            if (ver.length() <= 0) break;
                            versions.add(ver.toString());
                            break;
                        }
                        nodePath.pop();
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        info.setGroupId(groupId.toString().trim());
        info.setArtifactId(artifactId.toString().trim());
        info.setLatest(latest.toString().trim());
        info.setRelease(release.toString().trim());
        try {
            info.setLastUpdated(lastUpdated.toString().trim().isEmpty() ? null : new SimpleDateFormat("yyyyMMddHHmmss").parse(lastUpdated.toString().trim()));
        }
        catch (Exception ex) {
            this.LOG.with().session(this.session).level(Level.SEVERE).error((Throwable)ex).log(NutsMessage.jstyle((String)"failed to parse date {0} : {1}", (Object[])new Object[]{lastUpdated, ex}));
        }
        for (String version : versions) {
            info.getVersions().add(version.trim());
        }
        return info;
    }

    private boolean isStackPath(Stack<String> stack, String ... path) {
        if (stack.size() != path.length) {
            return false;
        }
        for (int i = 0; i < path.length; ++i) {
            if (((String)stack.get(stack.size() - path.length + i)).equals(path[i])) continue;
            return false;
        }
        return true;
    }
}

