/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl.maven.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Stack;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.PomId;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.PomIdFilter;
import net.thevpc.nuts.runtime.standalone.util.iter.NutsIteratorBase;

public class ArchetypeCatalogParser {
    public static Iterator<PomId> createArchetypeCatalogIterator(InputStream stream, PomIdFilter filter, boolean autoCloseStream) {
        return new ArchetypeCatalogPomIdIterator(stream, filter, autoCloseStream);
    }

    private static StringBuilder clear(StringBuilder c) {
        return c.delete(0, c.length());
    }

    private static boolean isStackPath(Stack<String> stack, String ... path) {
        if (stack.size() != path.length) {
            return false;
        }
        for (int i = 0; i < path.length; ++i) {
            if (((String)stack.get(stack.size() - path.length + i)).equals(path[i])) continue;
            return false;
        }
        return true;
    }

    private static class ArchetypeCatalogPomIdIterator
    extends NutsIteratorBase<PomId> {
        private final InputStream stream;
        private final PomIdFilter filter;
        private final boolean autoCloseStream;
        PomId last;
        InputStream stream2;
        XMLInputFactory factory;
        XMLEventReader eventReader;
        Stack<String> nodePath;
        StringBuilder groupId;
        StringBuilder artifactId;
        StringBuilder version;

        public ArchetypeCatalogPomIdIterator(InputStream stream, PomIdFilter filter, boolean autoCloseStream) {
            this.stream = stream;
            this.filter = filter;
            this.autoCloseStream = autoCloseStream;
            this.stream2 = stream;
            this.nodePath = new Stack();
            this.groupId = new StringBuilder();
            this.artifactId = new StringBuilder();
            this.version = new StringBuilder();
            this.factory = XMLInputFactory.newInstance();
            this.factory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
            try {
                this.eventReader = this.factory.createXMLEventReader(new InputStreamReader(this.stream2));
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
        }

        public NutsElement describe(NutsElements elems) {
            return elems.ofObject().set("type", "ScanArchetypeCatalog").set("source", this.stream.toString()).build();
        }

        public boolean hasNext() {
            if (this.eventReader == null || this.stream2 == null) {
                this.autoCloseStream();
                return false;
            }
            try {
                while (this.eventReader.hasNext()) {
                    XMLEvent event = this.eventReader.nextEvent();
                    switch (event.getEventType()) {
                        case 1: {
                            StartElement startElement = event.asStartElement();
                            String qName = startElement.getName().getLocalPart();
                            this.nodePath.push(qName);
                            if (!ArchetypeCatalogParser.isStackPath(this.nodePath, new String[]{"archetype-catalog", "archetypes", "archetype"})) break;
                            ArchetypeCatalogParser.clear(this.groupId);
                            ArchetypeCatalogParser.clear(this.artifactId);
                            ArchetypeCatalogParser.clear(this.version);
                            break;
                        }
                        case 4: {
                            if (ArchetypeCatalogParser.isStackPath(this.nodePath, new String[]{"archetype-catalog", "archetypes", "archetype", "groupId"})) {
                                this.groupId.append(event.asCharacters().getData());
                                break;
                            }
                            if (ArchetypeCatalogParser.isStackPath(this.nodePath, new String[]{"archetype-catalog", "archetypes", "archetype", "artifactId"})) {
                                this.artifactId.append(event.asCharacters().getData());
                                break;
                            }
                            if (!ArchetypeCatalogParser.isStackPath(this.nodePath, new String[]{"archetype-catalog", "archetypes", "archetype", "version"})) break;
                            this.version.append(event.asCharacters().getData());
                            break;
                        }
                        case 2: {
                            if (ArchetypeCatalogParser.isStackPath(this.nodePath, new String[]{"archetype-catalog", "archetypes", "archetype"})) {
                                this.last = new PomId(this.groupId.toString(), this.artifactId.toString(), this.version.toString());
                                if (this.filter == null || this.filter.accept(this.last)) {
                                    this.nodePath.pop();
                                    return true;
                                }
                            }
                            this.nodePath.pop();
                        }
                    }
                }
            }
            catch (XMLStreamException ex) {
                this.autoCloseStream();
                return false;
            }
            this.autoCloseStream();
            return false;
        }

        public PomId next() {
            return this.last;
        }

        public void remove() {
            throw new UnsupportedOperationException("unsupported operation: remove");
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.autoCloseStream();
        }

        private void autoCloseStream() {
            if (this.autoCloseStream && this.stream2 != null) {
                try {
                    this.stream2.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.stream2 = null;
            }
        }
    }
}

