/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl.maven.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.logging.Level;
import net.thevpc.nuts.NutsCp;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsInputStreamMonitor;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPathOption;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStreamMetadata;
import net.thevpc.nuts.NutsUnsupportedArgumentException;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.util.MavenUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.xtra.digest.NutsDigestUtils;

public abstract class AbstractMavenRepositoryHelper {
    private NutsLogger LOG;
    private final NutsRepository repository;

    public AbstractMavenRepositoryHelper(NutsRepository repository) {
        this.repository = repository;
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = NutsLogger.of(AbstractMavenRepositoryHelper.class, (NutsSession)session);
        }
        return this.LOG;
    }

    public abstract NutsPath getIdPath(NutsId var1, NutsSession var2);

    public InputStream getStream(NutsId id, String typeName, String action, NutsSession session) {
        NutsPath url = this.getIdPath(id, session);
        return this.openStream(id, url, id, typeName, action, session);
    }

    public String getStreamAsString(NutsId id, String typeName, String action, NutsSession session) {
        byte[] barr = NutsCp.of((NutsSession)session).addOptions(new NutsPathOption[]{NutsPathOption.LOG, NutsPathOption.TRACE, NutsPathOption.SAFE}).from(this.getIdPath(id, session)).setSourceOrigin((Object)id).setActionMessage(action == null ? null : NutsMessage.plain((String)action)).setSourceTypeName(action).getByteArrayResult();
        return new String(barr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSHA1Hash(NutsId id, InputStream stream, String typeName, NutsSession session) throws IOException {
        if (!this.repository.isRemote()) {
            stream.close();
            return;
        }
        switch (NutsUtilStrings.trim((String)id.getFace())) {
            case "content-hash": 
            case "descriptor-hash": {
                break;
            }
            default: {
                this._LOGOP(session).level(Level.SEVERE).error((Throwable)new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unsupported Hash Type %s", (Object[])new Object[]{id.getFace()}))).log(NutsMessage.jstyle((String)"[BUG] unsupported Hash Type {0}", (Object[])new Object[]{id.getFace()}));
                throw new IOException("unsupported hash type " + id.getFace());
            }
        }
        try {
            String rhash = null;
            try {
                rhash = this.getStreamSHA1(id, session, typeName);
            }
            catch (UncheckedIOException | NutsIOException ex) {
                stream.close();
                return;
            }
            String lhash = NutsDigestUtils.evalSHA1Hex(stream, true, session);
            if (!rhash.equalsIgnoreCase(lhash)) {
                throw new IOException("invalid file hash " + id);
            }
        }
        finally {
            stream.close();
        }
    }

    protected String getStreamSHA1(NutsId id, NutsSession session, String typeName) {
        String hash = this.getStreamAsString(id, typeName + " SHA1", "verify", session).toUpperCase();
        for (String s : hash.split("[ \n\r]")) {
            if (s.length() <= 0) continue;
            return s;
        }
        return hash.split("[ \n\r]")[0];
    }

    public InputStream openStream(NutsId id, NutsPath path, Object source, String typeName, String action, NutsSession session) {
        session.getTerminal().printProgress("%-14s %-8s %s", new Object[]{this.repository.getName(), action, path.toCompressedForm()});
        return NutsInputStreamMonitor.of((NutsSession)session).setSource(path).setOrigin(source).setSourceTypeName(typeName).create();
    }

    private void checkSession(NutsSession session) {
        NutsWorkspaceUtils.checkSession(this.repository.getWorkspace(), session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NutsDescriptor fetchDescriptorImpl(NutsId id, NutsFetchMode fetchMode, NutsSession session) {
        this.checkSession(session);
        InputStream stream = null;
        try {
            NutsDescriptor nutsDescriptor = null;
            byte[] bytes = null;
            String name = null;
            NutsId idDesc = id.builder().setFaceDescriptor().build();
            try {
                stream = this.getStream(idDesc, "artifact descriptor", "retrieve", session);
                bytes = CoreIOUtils.loadByteArray(stream, true, session);
                name = NutsStreamMetadata.of((Object)stream).getName();
                nutsDescriptor = MavenUtils.of(session).parsePomXmlAndResolveParents(CoreIOUtils.createBytesStream(bytes, name == null ? null : NutsMessage.formatted((String)name), "text/xml", "pom.xml", session), fetchMode, this.getIdPath(id, session).toString(), this.repository);
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
            this.checkSHA1Hash(id.builder().setFace("descriptor-hash").build(), CoreIOUtils.createBytesStream(bytes, name == null ? null : NutsMessage.formatted((String)name), "text/xml", "pom.xml", session), "artifact descriptor", session);
            return nutsDescriptor;
        }
        catch (IOException | UncheckedIOException | NutsIOException ex) {
            throw new NutsNotFoundException(session, id, ex);
        }
    }

    public String getIdExtension(NutsId id, NutsSession session) {
        String f;
        this.checkSession(session);
        Map q = id.getProperties();
        switch (f = NutsUtilStrings.trim((String)((String)q.get("face")))) {
            case "descriptor": {
                return ".pom";
            }
            case "descriptor-hash": {
                return ".pom.sha1";
            }
            case "catalog": {
                return ".catalog";
            }
            case "content-hash": {
                return this.getIdExtension(id.builder().setFaceContent().build(), session) + ".sha1";
            }
            case "content": {
                String packaging = (String)q.get("packaging");
                return session.locations().getDefaultIdContentExtension(packaging);
            }
        }
        throw new NutsUnsupportedArgumentException(session, NutsMessage.cstyle((String)"unsupported fact %s", (Object[])new Object[]{f}));
    }
}

