/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl.maven.solrsearch;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;
import net.thevpc.nuts.NutsArrayElement;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdBuilder;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsIterator;
import net.thevpc.nuts.NutsObjectElement;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.MavenFolderRepository;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.solrsearch.MavenSolrSearchRequest;
import net.thevpc.nuts.runtime.standalone.util.iter.IteratorBuilder;
import net.thevpc.nuts.runtime.standalone.util.iter.IteratorUtils;

public class MavenSolrSearchCommand {
    private MavenFolderRepository repo;

    public MavenSolrSearchCommand(MavenFolderRepository repo) {
        this.repo = repo;
    }

    public boolean isSolrSearchEnabled(NutsSession session) {
        NutsPath solrSearchUrl = this.getSolrSearchUrl(session);
        return solrSearchUrl != null && NutsUtilStrings.parseBoolean((String)this.repo.config().setSession(session).getConfigProperty("maven.solrsearch.enable", null), (Boolean)true, (Boolean)false) != false;
    }

    public NutsIterator<NutsId> search(NutsIdFilter filter, NutsId[] baseIds, NutsFetchMode fetchMode, NutsSession session) {
        if (fetchMode == NutsFetchMode.REMOTE && this.isSolrSearchEnabled(session)) {
            boolean someCorrect = false;
            boolean someIncorrect = false;
            ArrayList list2 = new ArrayList();
            NutsPath solrSearchUrl = this.getSolrSearchUrl(session);
            for (NutsId baseId : baseIds) {
                MavenSolrSearchRequest r = new MavenSolrSearchRequest(baseId.getGroupId(), baseId.getArtifactId());
                Iterator<NutsId> ii = this.search(r, solrSearchUrl, filter, session);
                if (ii == null) {
                    return null;
                }
                list2.add((NutsIterator)ii);
                someCorrect = true;
            }
            if (someCorrect && !someIncorrect) {
                return IteratorUtils.concat(list2);
            }
        }
        return null;
    }

    public NutsPath getSolrSearchUrl(NutsSession session) {
        String a = this.repo.config().setSession(session).getConfigProperty("maven.solrsearch.url", null);
        if (a != null) {
            return NutsPath.of((String)a, (NutsSession)session);
        }
        return null;
    }

    public Iterator<NutsId> search(MavenSolrSearchRequest r, NutsPath url, NutsIdFilter idFilter, final NutsSession session) {
        if (r != null) {
            Map<String, String> m;
            String urlString = url.toString();
            if (urlString.startsWith("htmlfs:")) {
                urlString = urlString.substring("htmlfs:".length());
            }
            if ((m = r.toQueryMap()) != null) {
                StringBuilder q2 = new StringBuilder(urlString).append("?");
                int index = 0;
                for (Map.Entry<String, String> entry : m.entrySet()) {
                    if (index > 0) {
                        q2.append("&");
                    }
                    try {
                        q2.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        return null;
                    }
                    ++index;
                }
                final NutsPath query = NutsPath.of((String)q2.toString(), (NutsSession)session);
                IteratorBuilder<NutsId> it = IteratorBuilder.ofSupplier(new Supplier<Iterator<NutsId>>(){

                    @Override
                    public Iterator<NutsId> get() {
                        return new Iterator<NutsId>(){
                            NutsArrayElement arr;
                            int index = 0;

                            @Override
                            public boolean hasNext() {
                                NutsObjectElement o;
                                String status;
                                NutsElement e;
                                if (this.arr == null && (e = NutsElements.of((NutsSession)session).setLogProgress(true).parse(query)).isObject() && "0".equals(status = (o = e.asObject()).getSafeObject("responseHeader").getSafeString("status"))) {
                                    this.arr = o.getSafeObject("response").getSafeArray("docs");
                                }
                                return this.index < this.arr.size();
                            }

                            @Override
                            public NutsId next() {
                                if (this.arr != null && this.index < this.arr.size()) {
                                    NutsObjectElement d = this.arr.getObject(this.index);
                                    String g = d.getSafeString("g");
                                    String a = d.getSafeString("a");
                                    String v = d.getSafeString("v");
                                    ++this.index;
                                    return NutsIdBuilder.of((NutsSession)session).setGroupId(g).setArtifactId(a).setVersion(v).build();
                                }
                                return null;
                            }
                        };
                    }
                }, elems -> elems.ofObject().set("url", query.toString()).build(), session);
                return it.filter(y -> idFilter == null || idFilter.acceptId(y, session), elems -> elems.ofObject().set("filterBy", (NutsElement)elems.ofString(idFilter == null ? "true" : idFilter.toString())).build()).build();
            }
        }
        return null;
    }
}

