/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl.maven.lucene;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import net.thevpc.nuts.NutsCp;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdParser;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTmp;
import net.thevpc.nuts.NutsUncompress;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.lucene.DirtyLuceneIndexParser;
import net.thevpc.nuts.runtime.standalone.repository.index.ArtifactsIndexDB;

public class LuceneIndexImporter {
    private NutsSession session;

    public LuceneIndexImporter(NutsSession session) {
        this.session = session;
    }

    public long importGzURL(URL url, String repository, NutsSession session) {
        String tempGzFile = NutsTmp.of((NutsSession)session).createTempFile("lucene-repository.gz").toString();
        NutsCp.of((NutsSession)session).setSession(session).from(url).to(tempGzFile).run();
        String tempFolder = NutsTmp.of((NutsSession)session).createTempFolder("lucene-repository").toString();
        NutsUncompress.of((NutsSession)session).from(tempGzFile).to(tempFolder).setFormat("gz").run();
        try {
            long[] ref = new long[1];
            Files.list(Paths.get(tempFolder, new String[0])).forEach(x -> {
                ref[0] = ref[0] + this.importFile(x.toString(), repository, session);
            });
            return ref[0];
        }
        catch (IOException ex) {
            throw new NutsIOException(session, (Throwable)ex);
        }
    }

    public long importFile(String filePath, String repository, NutsSession session) {
        ArtifactsIndexDB adb = ArtifactsIndexDB.of(session);
        NutsIdParser idParser = NutsIdParser.of((NutsSession)session);
        int addedCount = 0;
        int allCount = 0;
        try (DirtyLuceneIndexParser p = new DirtyLuceneIndexParser(new FileInputStream(filePath), session);){
            while (p.hasNext()) {
                NutsId id = idParser.parse(p.next()).builder().setRepository(repository).build();
                if (!adb.contains(id, session)) {
                    ++addedCount;
                    adb.add(id, session);
                }
                ++allCount;
            }
        }
        catch (IOException ex) {
            throw new NutsIOException(session, (Throwable)ex);
        }
        finally {
            adb.flush(session);
        }
        return addedCount;
    }
}

