/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl.maven;

import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryConfig;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.standalone.repository.NutsRepositorySelectorHelper;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.MavenFolderRepository;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.MavenRemoteXmlRepository;
import net.thevpc.nuts.runtime.standalone.repository.util.NutsRepositoryUtils;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.spi.NutsRepositoryDB;
import net.thevpc.nuts.spi.NutsRepositoryFactoryComponent;
import net.thevpc.nuts.spi.NutsRepositoryLocation;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class MavenRepositoryFactoryComponent
implements NutsRepositoryFactoryComponent {
    public NutsAddRepositoryOptions[] getDefaultRepositories(NutsSession session) {
        return new NutsAddRepositoryOptions[]{NutsRepositorySelectorHelper.createRepositoryOptions(NutsRepositoryLocation.of((String)"maven-local", (NutsRepositoryDB)NutsRepositoryDB.of((NutsSession)session), (NutsSession)session), true, session), NutsRepositorySelectorHelper.createRepositoryOptions(NutsRepositoryLocation.of((String)"maven-central", (NutsRepositoryDB)NutsRepositoryDB.of((NutsSession)session), (NutsSession)session), true, session)};
    }

    public NutsRepository create(NutsAddRepositoryOptions options, NutsSession session, NutsRepository parentRepository) {
        String pr;
        NutsRepositoryConfig config = options.getConfig();
        String type = NutsRepositoryUtils.getRepoType(config);
        if (NutsBlankable.isBlank((String)type)) {
            return null;
        }
        NutsPath p = NutsPath.of((String)config.getLocation().getPath(), (NutsSession)session);
        switch (pr = NutsUtilStrings.trim((String)p.getProtocol())) {
            case "http": 
            case "https": {
                return new MavenRemoteXmlRepository(options, session, parentRepository);
            }
        }
        return new MavenFolderRepository(options, session, parentRepository);
    }

    public int getSupportLevel(NutsSupportLevelContext criteria) {
        if (criteria == null) {
            return -1;
        }
        NutsRepositoryConfig r = (NutsRepositoryConfig)criteria.getConstraints(NutsRepositoryConfig.class);
        if (r != null) {
            String type = NutsRepositoryUtils.getRepoType(r);
            if (NutsBlankable.isBlank((String)type)) {
                return -1;
            }
            if ("maven".equals(type)) {
                return 20;
            }
            if (NutsBlankable.isBlank((String)type)) {
                return 15;
            }
        }
        return -1;
    }
}

