/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl.maven;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdBuilder;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsIterator;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.MavenFolderRepository;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.util.MavenMetadata;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.util.MavenUtils;
import net.thevpc.nuts.runtime.standalone.util.iter.IteratorBuilder;

public class MavenRemoteXmlRepository
extends MavenFolderRepository {
    public MavenRemoteXmlRepository(NutsAddRepositoryOptions options, NutsSession session, NutsRepository parentRepository) {
        super(options, session, parentRepository);
    }

    @Override
    public NutsIterator<NutsId> searchCore(NutsIdFilter filter, NutsPath[] basePaths, NutsId[] baseIds, NutsFetchMode fetchMode, NutsSession session) {
        return super.searchCore(filter, basePaths, baseIds, fetchMode, session);
    }

    @Override
    public NutsIterator<NutsId> findNonSingleVersionImpl(NutsId id, NutsIdFilter idFilter, NutsFetchMode fetchMode, NutsSession session) {
        if (!this.acceptedFetchNoCache(fetchMode)) {
            return IteratorBuilder.emptyIterator();
        }
        String groupId = id.getGroupId();
        String artifactId = id.getArtifactId();
        NutsPath metadataURL = this.config().setSession(session).getLocationPath().resolve(groupId.replace('.', '/') + "/" + artifactId + "/maven-metadata.xml");
        return IteratorBuilder.ofSupplier(() -> {
            ArrayList<NutsId> ret = new ArrayList<NutsId>();
            InputStream metadataStream = null;
            session.getTerminal().printProgress("looking for versions of %s at %s", new Object[]{id, metadataURL.toCompressedForm()});
            try {
                try {
                    metadataStream = this.repoHelper.openStream(id, metadataURL, id.builder().setFace("catalog").build(), "artifact catalog", "retrieve", session);
                }
                catch (UncheckedIOException | NutsIOException ex) {
                    NutsIterator nutsIterator = IteratorBuilder.emptyIterator();
                    if (metadataStream != null) {
                        try {
                            metadataStream.close();
                        }
                        catch (IOException e) {
                            return IteratorBuilder.emptyIterator();
                        }
                    }
                    return nutsIterator;
                }
                MavenMetadata info = MavenUtils.of(session).parseMavenMetaData(metadataStream, session);
                if (info != null) {
                    for (String version : info.getVersions()) {
                        NutsId nutsId = id.builder().setVersion(version).build();
                        if (idFilter != null && !idFilter.acceptId(nutsId, session)) continue;
                        ret.add(NutsIdBuilder.of((NutsSession)session).setGroupId(groupId).setArtifactId(artifactId).setVersion(version).build());
                    }
                }
            }
            catch (UncheckedIOException | NutsIOException ex) {
                NutsIterator nutsIterator = IteratorBuilder.emptyIterator();
                return nutsIterator;
            }
            finally {
                if (metadataStream != null) {
                    try {
                        metadataStream.close();
                    }
                    catch (IOException e) {
                        return IteratorBuilder.emptyIterator();
                    }
                }
            }
            return ret.iterator();
        }, e -> e.ofObject().set("type", "ScanMavenMetadataXml").set("path", metadataURL.toString()).build(), session).build();
    }
}

