/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl.maven;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.logging.Level;
import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsContent;
import net.thevpc.nuts.NutsCp;
import net.thevpc.nuts.NutsDefaultContent;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsFetchModeNotSupportedException;
import net.thevpc.nuts.NutsFilter;
import net.thevpc.nuts.NutsIOCopyValidator;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdBuilder;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsIdFilters;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsIterator;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPathOption;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSpeedQualifier;
import net.thevpc.nuts.NutsStoreLocationStrategy;
import net.thevpc.nuts.NutsTmp;
import net.thevpc.nuts.NutsTreeVisitResult;
import net.thevpc.nuts.NutsTreeVisitor;
import net.thevpc.nuts.runtime.standalone.repository.NutsIdPathIterator;
import net.thevpc.nuts.runtime.standalone.repository.NutsIdPathIteratorBase;
import net.thevpc.nuts.runtime.standalone.repository.impl.NutsCachedRepository;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.solrsearch.MavenSolrSearchCommand;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.util.AbstractMavenRepositoryHelper;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.util.MavenUtils;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.util.MvnClient;
import net.thevpc.nuts.runtime.standalone.util.iter.IteratorBuilder;
import net.thevpc.nuts.runtime.standalone.util.iter.IteratorUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsRepositorySPI;

public class MavenFolderRepository
extends NutsCachedRepository {
    protected final AbstractMavenRepositoryHelper repoHelper = new RepoHelper();
    protected final NutsIdPathIteratorBase repoIter = new RepoIter();
    private final NutsLogger LOG;
    private MvnClient wrapper;

    public MavenFolderRepository(NutsAddRepositoryOptions options, NutsSession session, NutsRepository parentRepository) {
        super(options, session, parentRepository, NutsPath.of((String)options.getConfig().getLocation().getPath(), (NutsSession)session).isRemote() ? NutsSpeedQualifier.SLOW : NutsSpeedQualifier.FASTER, false, "maven");
        this.LOG = NutsLogger.of(this.getClass(), (NutsSession)session);
        if (!this.isRemote() && options.getConfig().getStoreLocationStrategy() != NutsStoreLocationStrategy.STANDALONE) {
            this.cache.setWriteEnabled(false);
            this.cache.setReadEnabled(false);
        }
    }

    @Override
    protected boolean isSupportedDeployImpl(NutsSession session) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isAvailableImpl(NutsSession session) {
        boolean bl;
        long now = System.currentTimeMillis();
        NutsPath loc = this.config().setSession(this.initSession).getLocationPath();
        try {
            bl = loc.exists();
        }
        catch (Throwable throwable) {
            try {
                this.LOG.with().level(Level.FINEST).verb(NutsLogVerb.SUCCESS).time(System.currentTimeMillis() - now).log(NutsMessage.cstyle((String)"check available %s : success", (Object[])new Object[]{this.getName()}));
                throw throwable;
            }
            catch (Exception e) {
                this.LOG.with().level(Level.FINEST).verb(NutsLogVerb.FAIL).time(System.currentTimeMillis() - now).log(NutsMessage.cstyle((String)"check available %s : failed", (Object[])new Object[]{this.getName()}));
                return false;
            }
        }
        this.LOG.with().level(Level.FINEST).verb(NutsLogVerb.SUCCESS).time(System.currentTimeMillis() - now).log(NutsMessage.cstyle((String)"check available %s : success", (Object[])new Object[]{this.getName()}));
        return bl;
    }

    @Override
    public NutsIterator<NutsId> searchVersionsCore(NutsId id, NutsIdFilter idFilter, NutsFetchMode fetchMode, NutsSession session) {
        if (!this.acceptedFetchNoCache(fetchMode)) {
            return null;
        }
        NutsIdFilter filter2 = ((NutsIdFilter)NutsIdFilters.of((NutsSession)session).nonnull((NutsFilter)idFilter)).and(NutsIdFilters.of((NutsSession)session).byName(new String[]{id.getShortName()}));
        if (id.getVersion().isSingleValue()) {
            return this.findSingleVersionImpl(id, filter2, fetchMode, session);
        }
        return this.findNonSingleVersionImpl(id, filter2, fetchMode, session);
    }

    @Override
    public NutsDescriptor fetchDescriptorCore(NutsId id, NutsFetchMode fetchMode, NutsSession session) {
        if (!this.acceptedFetchNoCache(fetchMode)) {
            throw new NutsNotFoundException(session, id, (Throwable)new NutsFetchModeNotSupportedException(session, (NutsRepository)this, fetchMode, id.toString(), null));
        }
        return this.repoHelper.fetchDescriptorImpl(id, fetchMode, session);
    }

    @Override
    public NutsContent fetchContentCore(NutsId id, NutsDescriptor descriptor, String localPath, NutsFetchMode fetchMode, NutsSession session) {
        if (!this.acceptedFetchNoCache(fetchMode)) {
            throw new NutsNotFoundException(session, id, (Throwable)new NutsFetchModeNotSupportedException(session, (NutsRepository)this, fetchMode, id.toString(), null));
        }
        NutsContent cc = this.fetchContentCoreUsingWrapper(id, descriptor, localPath, fetchMode, session);
        if (cc != null) {
            return cc;
        }
        return this.fetchContentCoreUsingRepoHelper(id, descriptor, localPath, fetchMode, session);
    }

    @Override
    public NutsIterator<NutsId> searchCore(NutsIdFilter filter, NutsPath[] basePaths, NutsId[] baseIds, NutsFetchMode fetchMode, NutsSession session) {
        if (!this.acceptedFetchNoCache(fetchMode)) {
            return null;
        }
        NutsPath repoRoot = this.config().setSession(session).getLocationPath();
        MavenSolrSearchCommand cmd = new MavenSolrSearchCommand(this);
        NutsIterator<NutsId> aa = cmd.search(filter, baseIds, fetchMode, session);
        if (aa != null) {
            return aa;
        }
        ArrayList list = new ArrayList();
        for (NutsPath basePath : basePaths) {
            list.add(IteratorBuilder.ofRunnable(() -> session.getTerminal().printProgress("%-14s %-8s %s", new Object[]{this.getName(), "browse", (basePath == null ? repoRoot : repoRoot.resolve(basePath)).toCompressedForm()}), "Log", session).build());
            if (basePath.getName().equals("*")) {
                list.add(new NutsIdPathIterator(this, repoRoot, basePath.getParent(), filter, session, this.repoIter, Integer.MAX_VALUE, "core", null));
                continue;
            }
            list.add(new NutsIdPathIterator(this, repoRoot, basePath, filter, session, this.repoIter, 2, "core", null));
        }
        return IteratorUtils.concat(list);
    }

    @Override
    public void updateStatistics2(NutsSession session) {
        this.config().setSession(session).getLocationPath().walkDfs((NutsTreeVisitor)new NutsTreeVisitor<NutsPath>(){

            public NutsTreeVisitResult preVisitDirectory(NutsPath dir, NutsSession session) {
                return NutsTreeVisitResult.CONTINUE;
            }

            public NutsTreeVisitResult visitFile(NutsPath file, NutsSession session) {
                throw new NutsIOException(session, NutsMessage.cstyle((String)"updateStatistics Not supported.", (Object[])new Object[0]));
            }

            public NutsTreeVisitResult visitFileFailed(NutsPath file, Exception exc, NutsSession session) {
                throw new NutsIOException(session, NutsMessage.cstyle((String)"updateStatistics Not supported.", (Object[])new Object[0]));
            }

            public NutsTreeVisitResult postVisitDirectory(NutsPath dir, Exception exc, NutsSession session) {
                throw new NutsIOException(session, NutsMessage.cstyle((String)"updateStatistics Not supported.", (Object[])new Object[0]));
            }
        }, new NutsPathOption[0]);
    }

    @Override
    public boolean isAcceptFetchMode(NutsFetchMode mode, NutsSession session) {
        return this.isRemote() || mode == NutsFetchMode.LOCAL;
    }

    @Override
    public boolean isRemote() {
        return this.config().setSession(this.initSession).getLocationPath().isRemote();
    }

    public NutsContent fetchContentCoreUsingWrapper(NutsId id, NutsDescriptor descriptor, String localPath, NutsFetchMode fetchMode, NutsSession session) {
        if (this.wrapper == null) {
            this.wrapper = this.getWrapper(session);
        }
        if (this.wrapper != null && this.wrapper.get(id, this.config().setSession(session).getLocationPath().toString(), session)) {
            NutsRepository repo = this.getLocalMavenRepo(session);
            if (repo != null) {
                NutsRepositorySPI repoSPI = NutsWorkspaceUtils.of(session).repoSPI(repo);
                return repoSPI.fetchContent().setId(id).setDescriptor(descriptor).setLocalPath(localPath).setSession(session).setFetchMode(NutsFetchMode.LOCAL).run().getResult();
            }
            NutsPath content = this.getMavenLocalFolderContent(id, session);
            if (content != null && content.exists()) {
                if (localPath == null) {
                    return new NutsDefaultContent(content, true, false);
                }
                String tempFile = NutsTmp.of((NutsSession)session).setRepositoryId(this.getUuid()).createTempFile(content.getName()).toString();
                NutsCp.of((NutsSession)session).from(content).to(tempFile).addOptions(new NutsPathOption[]{NutsPathOption.SAFE}).run();
                return new NutsDefaultContent(NutsPath.of((String)tempFile, (NutsSession)session), true, false);
            }
        }
        return null;
    }

    public NutsContent fetchContentCoreUsingRepoHelper(final NutsId id, NutsDescriptor descriptor, String localPath, NutsFetchMode fetchMode, final NutsSession session) {
        if (localPath == null) {
            NutsPath p = this.repoHelper.getIdPath(id, session);
            if (p.isLocal()) {
                return new NutsDefaultContent(p, false, false);
            }
            String tempFile = NutsTmp.of((NutsSession)session).setRepositoryId(this.getUuid()).createTempFile(p.getName()).toString();
            try {
                NutsCp.of((NutsSession)session).from(this.repoHelper.getStream(id, "artifact binaries", "retrieve", session)).to(tempFile).setValidator(new NutsIOCopyValidator(){

                    public void validate(InputStream in) throws IOException {
                        MavenFolderRepository.this.repoHelper.checkSHA1Hash(id.builder().setFace("content-hash").build(), in, "artifact binaries", session);
                    }
                }).run();
            }
            catch (UncheckedIOException | NutsIOException ex) {
                throw new NutsNotFoundException(session, id, null, ex);
            }
            return new NutsDefaultContent(NutsPath.of((String)tempFile, (NutsSession)session), true, true);
        }
        try {
            NutsCp.of((NutsSession)session).from(this.repoHelper.getIdPath(id, session)).to(localPath).setValidator(in -> this.repoHelper.checkSHA1Hash(id.builder().setFace("content-hash").build(), in, "artifact binaries", session)).addOptions(new NutsPathOption[]{NutsPathOption.LOG, NutsPathOption.TRACE, NutsPathOption.SAFE}).run();
        }
        catch (UncheckedIOException | NutsIOException ex) {
            throw new NutsNotFoundException(session, id, null, ex);
        }
        return new NutsDefaultContent(NutsPath.of((String)localPath, (NutsSession)session), true, false);
    }

    protected boolean acceptedFetchNoCache(NutsFetchMode fetchMode) {
        return fetchMode == NutsFetchMode.REMOTE == this.isRemote();
    }

    public NutsIterator<NutsId> findNonSingleVersionImpl(NutsId id, NutsIdFilter idFilter, NutsFetchMode fetchMode, NutsSession session) {
        String groupId = id.getGroupId();
        String artifactId = id.getArtifactId();
        NutsPath foldersFileUrl = this.config().setSession(session).getLocationPath().resolve(groupId.replace('.', '/') + "/" + artifactId + "/");
        MavenSolrSearchCommand cmd = new MavenSolrSearchCommand(this);
        NutsIterator<NutsId> aa = cmd.search(idFilter, new NutsId[]{id}, fetchMode, session);
        if (aa != null) {
            return aa;
        }
        return IteratorBuilder.ofSupplier(() -> {
            NutsPath[] all;
            ArrayList<NutsId> ret = new ArrayList<NutsId>();
            session.getTerminal().printProgress("looking for versions of %s at %s", new Object[]{id, foldersFileUrl.toCompressedForm()});
            for (NutsPath version : all = (NutsPath[])foldersFileUrl.list().filter(NutsPath::isDirectory, "isDirectory").toArray(NutsPath[]::new)) {
                NutsId nutsId = id.builder().setVersion(version.getName()).build();
                if (idFilter != null && !idFilter.acceptId(nutsId, session)) continue;
                ret.add(NutsIdBuilder.of((NutsSession)session).setGroupId(groupId).setArtifactId(artifactId).setVersion(version.getName()).build());
            }
            return NutsIterator.of(ret.iterator(), (String)"findNonSingleVersion");
        }, e -> e.ofObject().set("type", "NonSingleVersion").set("path", foldersFileUrl.toString()).build(), session).build();
    }

    public NutsIterator<NutsId> findSingleVersionImpl(NutsId id, NutsIdFilter idFilter, NutsFetchMode fetchMode, NutsSession session) {
        if (id.getVersion().isSingleValue()) {
            String groupId = id.getGroupId();
            String artifactId = id.getArtifactId();
            NutsPath metadataURL = this.config().setSession(session).getLocationPath().resolve(groupId.replace('.', '/') + "/" + artifactId + "/" + id.getVersion().toString() + "/" + this.getIdFilename(id.builder().setFaceDescriptor().build(), session));
            return IteratorBuilder.ofSupplier(() -> {
                ArrayList<NutsId> ret = new ArrayList<NutsId>();
                session.getTerminal().printProgress("%-14s %-8s %s", new Object[]{this.getName(), "search", metadataURL.toCompressedForm()});
                if (metadataURL.isRegularFile()) {
                    ret.add(id);
                }
                return ret.iterator();
            }, e -> e.ofObject().set("type", "SingleVersion").set("path", metadataURL.toString()).build(), session).build();
        }
        throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"expected single version in %s", (Object[])new Object[]{id}));
    }

    private NutsRepository getLocalMavenRepo(NutsSession session) {
        for (NutsRepository nutsRepository : session.repos().setSession(session).getRepositories()) {
            if (!nutsRepository.getRepositoryType().equals("maven") || nutsRepository.config().getLocationPath() == null || !nutsRepository.config().getLocationPath().toString().equals(Paths.get(NutsPath.of((String)"~/.m2", (NutsSession)session).toAbsolute(session.locations().getWorkspaceLocation()).toString(), new String[0]).toString())) continue;
            return nutsRepository;
        }
        return null;
    }

    protected NutsPath getMavenLocalFolderContent(NutsId id, NutsSession session) {
        NutsPath p = this.getIdRelativePath(id, session);
        if (p != null) {
            return NutsPath.ofUserHome((NutsSession)session).resolve(".m2").resolve(p);
        }
        return null;
    }

    private MvnClient getWrapper(NutsSession session) {
        return null;
    }

    @Override
    protected String getIdExtension(NutsId id, NutsSession session) {
        return this.repoHelper.getIdExtension(id, session);
    }

    private class RepoHelper
    extends AbstractMavenRepositoryHelper {
        public RepoHelper() {
            super(MavenFolderRepository.this);
        }

        @Override
        public NutsPath getIdPath(NutsId id, NutsSession session) {
            return MavenFolderRepository.this.getIdRemotePath(id, session);
        }
    }

    private class RepoIter
    extends NutsIdPathIteratorBase {
        private RepoIter() {
        }

        @Override
        public void undeploy(NutsId id, NutsSession session) throws NutsExecutionException {
            MavenFolderRepository.this.undeploy().setId(id).setSession(session).run();
        }

        @Override
        public boolean isDescFile(NutsPath pathname) {
            return pathname.getName().endsWith(".pom");
        }

        @Override
        public NutsDescriptor parseDescriptor(NutsPath pathname, InputStream in, NutsFetchMode fetchMode, NutsRepository repository, NutsSession session, NutsPath rootURL) throws IOException {
            session.getTerminal().printProgress("%-8s %s", new Object[]{"parse", pathname.toCompressedForm()});
            return MavenUtils.of(session).parsePomXmlAndResolveParents(in, fetchMode, pathname.toString(), repository);
        }

        @Override
        public NutsId parseId(NutsPath pomFile, NutsPath rootPath, NutsIdFilter filter, NutsRepository repository, NutsSession session) throws IOException {
            NutsPath versionFolder;
            String fn = pomFile.getName();
            if (fn.endsWith(".pom") && (versionFolder = pomFile.getParent()) != null) {
                NutsPath groupFolder;
                String an;
                String vn = versionFolder.getName();
                NutsPath artifactFolder = versionFolder.getParent();
                if (artifactFolder != null && fn.equals((an = artifactFolder.getName()) + "-" + vn + ".pom") && (groupFolder = artifactFolder.getParent()) != null) {
                    NutsPath gg = groupFolder.subpath(rootPath.getPathCount(), groupFolder.getPathCount());
                    StringBuilder gn = new StringBuilder();
                    for (int i = 0; i < gg.getPathCount(); ++i) {
                        String ns = gg.getItem(i);
                        if (i > 0) {
                            gn.append('.');
                        }
                        gn.append(ns);
                    }
                    return this.validate(NutsIdBuilder.of((NutsSession)session).setGroupId(gn.toString()).setArtifactId(an).setVersion(vn).build(), null, pomFile, rootPath, filter, repository, session);
                }
            }
            return null;
        }
    }
}

