/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl.main;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.thevpc.nuts.NutsConfigItem;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.InstallDepConfig;

public class InstallInfoConfig
extends NutsConfigItem
implements Cloneable {
    private static final long serialVersionUID = 3L;
    private NutsId id;
    private boolean installed;
    private boolean required;
    private Instant creationDate;
    private Instant lastModificationDate;
    private String creationUser;
    private String lastModificationUser;
    private String sourceRepoName;
    private String sourceRepoUUID;
    private List<InstallDepConfig> requiredBy;
    private List<InstallDepConfig> requires;

    public List<InstallDepConfig> getRequiredBy() {
        return this.requiredBy;
    }

    public InstallInfoConfig setRequiredBy(List<InstallDepConfig> requiredBy) {
        this.requiredBy = requiredBy;
        return this;
    }

    public List<InstallDepConfig> getRequires() {
        return this.requires;
    }

    public InstallInfoConfig setRequires(List<InstallDepConfig> requires) {
        this.requires = requires;
        return this;
    }

    public String getSourceRepoName() {
        return this.sourceRepoName;
    }

    public void setSourceRepoName(String sourceRepoName) {
        this.sourceRepoName = sourceRepoName;
    }

    public String getSourceRepoUUID() {
        return this.sourceRepoUUID;
    }

    public void setSourceRepoUUID(String sourceRepoUUID) {
        this.sourceRepoUUID = sourceRepoUUID;
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public void setInstalled(boolean installed) {
        this.installed = installed;
    }

    public boolean isRequired() {
        return this.required;
    }

    public InstallInfoConfig setRequired(boolean required) {
        this.required = required;
        return this;
    }

    public NutsId getId() {
        return this.id;
    }

    public void setId(NutsId id) {
        this.id = id;
    }

    public String getCreationUser() {
        return this.creationUser;
    }

    public void setCreationUser(String creationUser) {
        this.creationUser = creationUser;
    }

    public Instant getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Instant creationDate) {
        this.creationDate = creationDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstallInfoConfig that = (InstallInfoConfig)o;
        return this.installed == that.installed && this.required == that.required && Objects.equals(this.id, that.id) && Objects.equals(this.creationDate, that.creationDate) && Objects.equals(this.lastModificationDate, that.lastModificationDate) && Objects.equals(this.creationUser, that.creationUser) && Objects.equals(this.lastModificationUser, that.lastModificationUser) && Objects.equals(this.sourceRepoName, that.sourceRepoName) && Objects.equals(this.sourceRepoUUID, that.sourceRepoUUID) && Objects.equals(this.requiredBy, that.requiredBy) && Objects.equals(this.requires, that.requires);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.installed, this.required, this.creationDate, this.lastModificationDate, this.creationUser, this.lastModificationUser, this.sourceRepoName, this.sourceRepoUUID, this.requiredBy, this.requires);
    }

    public String toString() {
        return "InstallInfoConfig{id=" + this.id + ", installed=" + this.installed + ", required=" + this.required + ", installDate=" + this.creationDate + ", lastModifiedUser=" + this.lastModificationUser + ", lastModifiedDate=" + this.lastModificationDate + ", installUser='" + this.creationUser + '\'' + '}';
    }

    public Instant getLastModificationDate() {
        return this.lastModificationDate;
    }

    public InstallInfoConfig setLastModificationDate(Instant lastModificationDate) {
        this.lastModificationDate = lastModificationDate;
        return this;
    }

    public String getLastModificationUser() {
        return this.lastModificationUser;
    }

    public InstallInfoConfig setLastModificationUser(String lastModificationUser) {
        this.lastModificationUser = lastModificationUser;
        return this;
    }

    public InstallInfoConfig copy() {
        InstallInfoConfig cloned = null;
        try {
            cloned = (InstallInfoConfig)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException(e);
        }
        if (this.requiredBy != null) {
            cloned.requiredBy = new ArrayList<InstallDepConfig>();
            for (InstallDepConfig installDepConfig : this.requiredBy) {
                cloned.requiredBy.add(installDepConfig.copy());
            }
        }
        if (this.requires != null) {
            cloned.requires = new ArrayList<InstallDepConfig>();
            for (InstallDepConfig installDepConfig : this.requires) {
                cloned.requires.add(installDepConfig.copy());
            }
        }
        return cloned;
    }
}

