/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl.main;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsConfirmationMode;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDependencyScope;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsFunction;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdBuilder;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsIdFilters;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsInstallException;
import net.thevpc.nuts.NutsInstallInformation;
import net.thevpc.nuts.NutsInstallStatus;
import net.thevpc.nuts.NutsInstallStatusFilters;
import net.thevpc.nuts.NutsIterator;
import net.thevpc.nuts.NutsLocks;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotInstallableException;
import net.thevpc.nuts.NutsNotInstalledException;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositorySecurityManager;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsStream;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.NutsVersionFilter;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.definition.DefaultNutsInstallInfo;
import net.thevpc.nuts.runtime.standalone.io.util.FolderObjectIterator;
import net.thevpc.nuts.runtime.standalone.io.util.NutsInstallStatusIdFilter;
import net.thevpc.nuts.runtime.standalone.repository.cmd.deploy.AbstractNutsDeployRepositoryCommand;
import net.thevpc.nuts.runtime.standalone.repository.cmd.fetch.AbstractNutsFetchContentRepositoryCommand;
import net.thevpc.nuts.runtime.standalone.repository.cmd.fetch.AbstractNutsFetchDescriptorRepositoryCommand;
import net.thevpc.nuts.runtime.standalone.repository.cmd.push.AbstractNutsPushRepositoryCommand;
import net.thevpc.nuts.runtime.standalone.repository.cmd.search.AbstractNutsSearchRepositoryCommand;
import net.thevpc.nuts.runtime.standalone.repository.cmd.search.AbstractNutsSearchVersionsRepositoryCommand;
import net.thevpc.nuts.runtime.standalone.repository.cmd.undeploy.AbstractNutsRepositoryUndeployCommand;
import net.thevpc.nuts.runtime.standalone.repository.cmd.updatestats.AbstractNutsUpdateRepositoryStatisticsCommand;
import net.thevpc.nuts.runtime.standalone.repository.impl.AbstractNutsRepository;
import net.thevpc.nuts.runtime.standalone.repository.impl.NutsRepositoryExt0;
import net.thevpc.nuts.runtime.standalone.repository.impl.NutsRepositoryFolderHelper;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.InstallDepConfig;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.InstallInfoConfig;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.InstallLogItemTable;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.InstalledRepositoryConfigModel;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.NutsInstallLogAction;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.NutsInstallLogRecord;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.NutsInstalledRepository;
import net.thevpc.nuts.runtime.standalone.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.standalone.util.collections.CoreCollectionUtils;
import net.thevpc.nuts.runtime.standalone.util.collections.LRUMap;
import net.thevpc.nuts.runtime.standalone.util.filters.NutsIdFilterToPredicate;
import net.thevpc.nuts.runtime.standalone.util.iter.IteratorBuilder;
import net.thevpc.nuts.runtime.standalone.workspace.CoreNutsBootOptions;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringTokenizerUtils;
import net.thevpc.nuts.spi.NutsDeployRepositoryCommand;
import net.thevpc.nuts.spi.NutsFetchContentRepositoryCommand;
import net.thevpc.nuts.spi.NutsFetchDescriptorRepositoryCommand;
import net.thevpc.nuts.spi.NutsPushRepositoryCommand;
import net.thevpc.nuts.spi.NutsRepositoryUndeployCommand;
import net.thevpc.nuts.spi.NutsSearchRepositoryCommand;
import net.thevpc.nuts.spi.NutsSearchVersionsRepositoryCommand;
import net.thevpc.nuts.spi.NutsUpdateRepositoryStatisticsCommand;

public class DefaultNutsInstalledRepository
extends AbstractNutsRepository
implements NutsInstalledRepository,
NutsRepositoryExt0 {
    public static final String INSTALLED_REPO_UUID = "<main>";
    private static final String NUTS_INSTALL_FILE = "nuts-install.json";
    private final NutsRepositoryFolderHelper deployments;
    private final Map<NutsId, String> cachedDefaultVersions = new LRUMap<NutsId, String>(200);
    private NutsLogger LOG;

    public DefaultNutsInstalledRepository(NutsWorkspace ws, CoreNutsBootOptions bOptions) {
        this.workspace = ws;
        this.initSession = NutsWorkspaceUtils.defaultSession(ws);
        this.deployments = new NutsRepositoryFolderHelper(this, NutsWorkspaceUtils.defaultSession(ws), NutsPath.of((String)bOptions.getStoreLocation(NutsStoreLocation.LIB), (NutsSession)this.initSession).resolve("id"), false, "lib", NutsElements.of((NutsSession)this.initSession).ofObject().set("repoKind", "lib").build());
        this.configModel = new InstalledRepositoryConfigModel(this.workspace, this);
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = NutsLogger.of(DefaultNutsInstalledRepository.class, (NutsSession)session);
        }
        return this.LOG;
    }

    @Override
    public boolean isDefaultVersion(NutsId id, NutsSession session) {
        String v = this.getDefaultVersion(id, session);
        return v.equals(id.getVersion().toString());
    }

    @Override
    public NutsIterator<NutsInstallInformation> searchInstallInformation(NutsSession session) {
        NutsPath rootFolder = session.locations().getStoreLocation(NutsStoreLocation.CONFIG).resolve("id");
        return new FolderObjectIterator<NutsInstallInformation>("NutsInstallInformation", rootFolder, null, -1, session, new FolderObjectIterator.FolderIteratorModel<NutsInstallInformation>(){

            @Override
            public boolean isObjectFile(NutsPath pathname) {
                return pathname.getName().equals(DefaultNutsInstalledRepository.NUTS_INSTALL_FILE);
            }

            @Override
            public NutsInstallInformation parseObject(NutsPath path, NutsSession session) throws IOException {
                try {
                    InstallInfoConfig c = DefaultNutsInstalledRepository.this.getInstallInfoConfig(null, path, session);
                    if (c != null) {
                        return DefaultNutsInstalledRepository.this.getInstallInformation(c, session);
                    }
                }
                catch (Exception ex) {
                    DefaultNutsInstalledRepository.this._LOGOP(session).error((Throwable)ex).log(NutsMessage.jstyle((String)"unable to parse {0}", (Object[])new Object[]{path}));
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDefaultVersion(NutsId id, NutsSession session) {
        NutsId baseVersion = id.getShortId();
        Map<NutsId, String> map = this.cachedDefaultVersions;
        synchronized (map) {
            String p = this.cachedDefaultVersions.get(baseVersion);
            if (p != null) {
                return p;
            }
        }
        NutsPath pp = session.locations().getStoreLocation(id.builder().setVersion("ANY").build(), NutsStoreLocation.CONFIG).resolveSibling("default-version");
        String defaultVersion = "";
        if (pp.isRegularFile()) {
            try {
                defaultVersion = new String(pp.readAllBytes()).trim();
            }
            catch (Exception ex) {
                defaultVersion = "";
            }
        }
        Map<NutsId, String> map2 = this.cachedDefaultVersions;
        synchronized (map2) {
            this.cachedDefaultVersions.put(baseVersion, defaultVersion);
        }
        return defaultVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultVersion(NutsId id, NutsSession session) {
        NutsId baseVersion = id.getShortId();
        String version = id.getVersion().getValue();
        NutsPath pp = session.locations().getStoreLocation(id.builder().setVersion("ANY").build(), NutsStoreLocation.CONFIG).resolveSibling("default-version");
        if (NutsBlankable.isBlank((String)version)) {
            if (pp.isRegularFile()) {
                pp.delete();
            }
        } else {
            pp.mkParentDirs();
            pp.writeBytes(version.trim().getBytes());
        }
        Map<NutsId, String> map = this.cachedDefaultVersions;
        synchronized (map) {
            this.cachedDefaultVersions.put(baseVersion, version);
        }
    }

    @Override
    public NutsInstallInformation getInstallInformation(NutsId id, NutsSession session) {
        InstallInfoConfig c = this.getInstallInfoConfig(id, null, session);
        return c != null ? this.getInstallInformation(c, session) : DefaultNutsInstallInfo.notInstalled(id);
    }

    @Override
    public NutsInstallStatus getInstallStatus(NutsId id, NutsSession session) {
        NutsInstallInformation ii = this.getInstallInformation(id, session);
        if (ii == null) {
            return NutsInstallStatus.NONE;
        }
        return ii.getInstallStatus();
    }

    @Override
    public void install(NutsId id, NutsSession session, NutsId forId) {
        boolean succeeded = false;
        NutsWorkspaceUtils.of(session).checkReadOnly();
        InstallInfoConfig ii = this.getInstallInfoConfig(id, null, session);
        try {
            String repository = id.getRepository();
            NutsRepository r = session.repos().findRepository(repository);
            if (ii == null) {
                ii = new InstallInfoConfig();
                ii.setId(id);
                ii.setInstalled(forId == null);
                if (r != null) {
                    ii.setSourceRepoName(r.getName());
                    ii.setSourceRepoUUID(r.getUuid());
                }
                this.saveCreate(ii, session);
            } else {
                InstallInfoConfig ii0 = ii.copy();
                ii.setId(id);
                ii.setInstalled(forId == null);
                if (r != null) {
                    ii.setSourceRepoName(r.getName());
                    ii.setSourceRepoUUID(r.getUuid());
                }
                this.saveUpdate(ii, ii0, session);
            }
            succeeded = true;
        }
        catch (UncheckedIOException | NutsIOException ex) {
            throw new NutsNotInstallableException(session, id, NutsMessage.cstyle((String)"failed to install %s : %s", (Object[])new Object[]{id, ex}), (Exception)ex);
        }
        finally {
            this.addLog(NutsInstallLogAction.INSTALL, id, forId, null, succeeded, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NutsInstallInformation install(NutsDefinition def, NutsSession session) {
        boolean succeeded = false;
        try {
            NutsInstallInformation a = this.updateInstallInformation(def, true, null, true, session);
            succeeded = true;
            NutsInstallInformation nutsInstallInformation = a;
            return nutsInstallInformation;
        }
        finally {
            this.addLog(NutsInstallLogAction.INSTALL, def.getId(), null, null, succeeded, session);
        }
    }

    @Override
    public void uninstall(NutsDefinition def, NutsSession session) {
        boolean succeeded = false;
        NutsWorkspaceUtils.of(session).checkReadOnly();
        NutsWorkspaceUtils.checkSession(this.workspace, session);
        NutsId id = def.getId();
        NutsInstallStatus installStatus = this.getInstallStatus(id, session);
        if (!installStatus.isInstalled()) {
            throw new NutsNotInstalledException(session, id);
        }
        try {
            String pck = def.getDescriptor().getPackaging();
            this.undeploy().setId(id.builder().setPackaging(NutsBlankable.isBlank((String)pck) ? "jar" : pck).build()).setSession(session).run();
            this.remove(id, NUTS_INSTALL_FILE, session);
            String v = this.getDefaultVersion(id, session);
            if (v != null && v.equals(id.getVersion().getValue())) {
                NutsIterator versions = this.searchVersions().setId(id).setFilter(NutsIdFilters.of((NutsSession)session).byInstallStatus(NutsInstallStatusFilters.of((NutsSession)session).byInstalled(true))).setFetchMode(NutsFetchMode.LOCAL).setSession(session).getResult();
                List nutsIds = CoreCollectionUtils.toList(versions == null ? Collections.emptyIterator() : versions);
                nutsIds.sort(null);
                if (nutsIds.size() > 0) {
                    this.setDefaultVersion((NutsId)nutsIds.get(0), session);
                } else {
                    this.setDefaultVersion(id.builder().setVersion("").build(), session);
                }
            }
            succeeded = true;
        }
        catch (Exception ex) {
            throw new NutsNotInstalledException(session, id);
        }
        finally {
            this.addLog(NutsInstallLogAction.UNINSTALL, id, null, null, succeeded, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NutsInstallInformation require(NutsDefinition def, boolean deploy, NutsId[] forIds, NutsDependencyScope scope, NutsSession session) {
        boolean succeeded = false;
        NutsId requiredId = def.getId();
        NutsInstallInformation nutsInstallInformation = this.updateInstallInformation(def, null, true, deploy, session);
        if (forIds != null) {
            for (NutsId requestorId : forIds) {
                if (requestorId == null) continue;
                succeeded = false;
                try {
                    InstallInfoConfig ti0;
                    InstallInfoConfig fi;
                    if (scope == null) {
                        scope = NutsDependencyScope.API;
                    }
                    if ((fi = this.getInstallInfoConfig(requiredId = requiredId.builder().setRepository(null).build(), null, session)) == null) {
                        throw new NutsInstallException(session, requiredId);
                    }
                    InstallInfoConfig fi0 = fi.copy();
                    InstallInfoConfig ti = this.getInstallInfoConfig(requestorId, null, session);
                    InstallInfoConfig installInfoConfig = ti0 = ti == null ? null : ti.copy();
                    if (!fi.isRequired()) {
                        fi.setRequired(true);
                        fi.setRequiredBy(this.addDistinct(fi.getRequiredBy(), new InstallDepConfig(requestorId, scope)));
                        this.saveUpdate(fi, fi0, session);
                    }
                    this.saveUpdate(fi, fi0, session);
                    if (ti == null) {
                        ti = new InstallInfoConfig();
                        ti.setId(requestorId);
                        ti.setRequires(this.addDistinct(ti.getRequires(), new InstallDepConfig(requiredId, scope)));
                        this.saveCreate(ti, session);
                    } else {
                        ti.setRequires(this.addDistinct(ti.getRequires(), new InstallDepConfig(requiredId, scope)));
                        this.saveUpdate(ti, ti0, session);
                    }
                    succeeded = true;
                }
                finally {
                    this.addLog(NutsInstallLogAction.REQUIRE, requiredId, requestorId, null, succeeded, session);
                }
            }
        }
        return nutsInstallInformation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unrequire(NutsId requiredId, NutsId requestorId, NutsDependencyScope scope, NutsSession session) {
        Instant now = Instant.now();
        String user = session.security().getCurrentUsername();
        boolean succeeded = false;
        try {
            InstallInfoConfig fi;
            if (scope == null) {
                scope = NutsDependencyScope.API;
            }
            if ((fi = this.getInstallInfoConfig(requiredId, null, session)) == null) {
                throw new NutsInstallException(session, requiredId);
            }
            InstallInfoConfig ti = this.getInstallInfoConfig(requestorId, null, session);
            if (ti == null) {
                throw new NutsInstallException(session, requestorId);
            }
            InstallInfoConfig fi0 = fi.copy();
            InstallInfoConfig ti0 = ti.copy();
            fi.setRequiredBy(this.removeDistinct(fi.getRequiredBy(), new InstallDepConfig(requestorId, scope)));
            ti.setRequires(this.removeDistinct(ti.getRequires(), new InstallDepConfig(requiredId, scope)));
            if (fi.isRequired() != fi.getRequiredBy().size() > 0) {
                fi.setRequired(fi.getRequiredBy().size() > 0);
            }
            this.saveUpdate(fi, fi0, session);
            this.saveUpdate(ti, ti0, session);
            succeeded = true;
        }
        finally {
            this.addLog(NutsInstallLogAction.UNREQUIRE, requiredId, requestorId, null, succeeded, session);
        }
    }

    @Override
    public NutsStream<NutsInstallLogRecord> findLog(NutsSession session) {
        return InstallLogItemTable.of(session).stream(session);
    }

    public NutsId pathToId(NutsPath path, NutsSession session) {
        NutsPath rootFolder = session.locations().getStoreLocation(NutsStoreLocation.CONFIG).resolve("id");
        String p = path.toString().substring(rootFolder.toString().length());
        List<String> split = StringTokenizerUtils.split(p, "/\\");
        if (split.size() >= 4) {
            return NutsIdBuilder.of((NutsSession)session).setArtifactId(split.get(split.size() - 3)).setGroupId(String.join((CharSequence)".", split.subList(0, split.size() - 3))).setVersion(split.get(split.size() - 2)).build();
        }
        return null;
    }

    private <A> List<A> addDistinct(List<A> old, A v) {
        LinkedHashSet<A> s = new LinkedHashSet<A>();
        if (old != null) {
            s.addAll(old);
        }
        if (v != null) {
            s.add(v);
        }
        return new ArrayList(s);
    }

    private <A> List<A> removeDistinct(List<A> old, A v) {
        LinkedHashSet<A> s = new LinkedHashSet<A>();
        if (old != null) {
            s.addAll(old);
        }
        if (v != null) {
            s.remove(v);
        }
        return new ArrayList(s);
    }

    public InstallInfoConfig getInstallInfoConfig(NutsId id, NutsPath path, NutsSession session) {
        if (id == null && path == null) {
            NutsWorkspaceUtils.of(session).checkShortId(id);
        }
        if (path == null) {
            path = this.getPath(id, NUTS_INSTALL_FILE, session);
        }
        NutsPath finalPath = path;
        if (path.isRegularFile()) {
            NutsElements elem = NutsElements.of((NutsSession)session);
            InstallInfoConfig c = (InstallInfoConfig)NutsLocks.of((NutsSession)session).setSource((Object)path).call(() -> (InstallInfoConfig)elem.json().parse(finalPath, InstallInfoConfig.class), 3L, CoreNutsUtils.LOCK_TIME_UNIT);
            if (c != null) {
                NutsId idOk;
                boolean changeStatus = false;
                NutsVersion v = NutsVersion.of((String)c.getConfigVersion(), (NutsSession)session);
                if (v.isBlank()) {
                    c.setInstalled(true);
                    c.setConfigVersion("0.5.8");
                    changeStatus = true;
                }
                if ((idOk = c.getId()) == null) {
                    if (id != null) {
                        c.setId(id);
                        changeStatus = true;
                    } else {
                        NutsId idOk2 = this.pathToId(path, session);
                        if (idOk2 != null) {
                            c.setId(idOk2);
                            changeStatus = true;
                        } else {
                            return null;
                        }
                    }
                }
                if (changeStatus && !session.config().isReadOnly()) {
                    NutsLocks.of((NutsSession)session).setSource((Object)path).call(() -> {
                        this._LOGOP(session).level(Level.CONFIG).log(NutsMessage.jstyle((String)"install-info upgraded {0}", (Object[])new Object[]{finalPath}));
                        c.setConfigVersion(this.workspace.getApiVersion().toString());
                        elem.json().setValue((Object)c).setNtf(false).print(finalPath);
                        return null;
                    }, 3L, CoreNutsUtils.LOCK_TIME_UNIT);
                }
            }
            return c;
        }
        return null;
    }

    public NutsIterator<InstallInfoConfig> searchInstallConfig(NutsSession session) {
        NutsPath rootFolder = session.locations().getStoreLocation(NutsStoreLocation.CONFIG).resolve("id");
        return new FolderObjectIterator<InstallInfoConfig>("InstallInfoConfig", rootFolder, null, -1, session, new FolderObjectIterator.FolderIteratorModel<InstallInfoConfig>(){

            @Override
            public boolean isObjectFile(NutsPath pathname) {
                return pathname.getName().equals(DefaultNutsInstalledRepository.NUTS_INSTALL_FILE);
            }

            @Override
            public InstallInfoConfig parseObject(NutsPath path, NutsSession session) throws IOException {
                try {
                    InstallInfoConfig c = DefaultNutsInstalledRepository.this.getInstallInfoConfig(null, path, session);
                    if (c != null) {
                        return c;
                    }
                }
                catch (Exception ex) {
                    DefaultNutsInstalledRepository.this._LOGOP(session).error((Throwable)ex).log(NutsMessage.jstyle((String)"unable to parse {0}", (Object[])new Object[]{path}));
                }
                return null;
            }
        });
    }

    public NutsInstallInformation getInstallInformation(InstallInfoConfig ii, NutsSession session) {
        boolean obsolete = false;
        boolean defaultVersion = false;
        if (ii.isInstalled()) {
            defaultVersion = this.isDefaultVersion(ii.getId(), session);
        }
        if (session.getExpireTime() != null && (ii.isInstalled() || ii.isRequired()) && (ii.isInstalled() || ii.isRequired())) {
            Instant lastModifiedDate = ii.getLastModificationDate();
            if (lastModifiedDate == null) {
                lastModifiedDate = ii.getCreationDate();
            }
            if (lastModifiedDate == null || lastModifiedDate.isBefore(session.getExpireTime())) {
                obsolete = true;
            }
        }
        NutsInstallStatus s = NutsInstallStatus.of((boolean)ii.isInstalled(), (boolean)ii.isRequired(), (boolean)obsolete, (boolean)defaultVersion);
        return new DefaultNutsInstallInfo(ii.getId(), s, session.locations().getStoreLocation(ii.getId(), NutsStoreLocation.APPS), ii.getCreationDate(), ii.getLastModificationDate(), ii.getCreationUser(), ii.getSourceRepoName(), ii.getSourceRepoUUID(), false, false);
    }

    private NutsInstallInformation updateInstallInformation(NutsDefinition def, Boolean install, Boolean require, boolean deploy, NutsSession session) {
        NutsId id1 = def.getId();
        InstallInfoConfig ii = this.getInstallInfoConfig(id1, null, session);
        boolean wasInstalled = false;
        boolean wasRequired = false;
        if (deploy) {
            this.deploy().setId(id1).setSession(session.copy().setConfirm(NutsConfirmationMode.YES)).setContent(def.getFile()).setDescriptor(def.getDescriptor()).run();
        }
        if (ii == null) {
            NutsId id = id1;
            NutsWorkspaceUtils.of(session).checkReadOnly();
            try {
                boolean _install = false;
                boolean _require = false;
                if (install != null && require != null) {
                    _install = install;
                    _require = require;
                } else if (install != null) {
                    _install = install;
                    _require = !_install;
                } else if (require != null) {
                    _require = require;
                    _install = !_require;
                } else {
                    _install = true;
                    _require = false;
                }
                ii = new InstallInfoConfig();
                ii.setConfigVersion("0.8.0");
                ii.setId(id);
                ii.setInstalled(_install);
                ii.setRequired(_require);
                this.saveCreate(ii, session);
            }
            catch (UncheckedIOException | NutsIOException ex) {
                throw new NutsNotInstallableException(session, id, NutsMessage.cstyle((String)"failed to install %s : %s", (Object[])new Object[]{id, ex}), (Exception)ex);
            }
            DefaultNutsInstallInfo uu = (DefaultNutsInstallInfo)this.getInstallInformation(ii, session);
            uu.setWasInstalled(false);
            uu.setWasRequired(false);
            uu.setJustInstalled(install != null && install != false);
            uu.setJustRequired(require != null && require != false);
            return uu;
        }
        InstallInfoConfig ii0 = ii.copy();
        wasInstalled = ii.isInstalled();
        wasRequired = ii.isRequired();
        boolean _install = wasInstalled;
        boolean _require = wasRequired;
        if (install != null) {
            _install = install;
        }
        if (require != null) {
            _require = require;
        }
        ii.setInstalled(_install);
        ii.setRequired(_require);
        this.saveUpdate(ii, ii0, session);
        DefaultNutsInstallInfo uu = (DefaultNutsInstallInfo)this.getInstallInformation(ii, session);
        uu.setWasInstalled(wasInstalled);
        uu.setWasRequired(wasRequired);
        uu.setJustInstalled(install != null && install != false);
        uu.setJustRequired(require != null && require != false);
        return uu;
    }

    private void saveCreate(InstallInfoConfig ii, NutsSession session) {
        Instant now = Instant.now();
        String user = session.security().getCurrentUsername();
        if (ii.getCreationUser() == null) {
            ii.setCreationUser(user);
        }
        if (ii.getCreationDate() == null) {
            ii.setCreationDate(now);
        }
        ii.setConfigVersion("0.8.0");
        this.printJson(ii.getId(), NUTS_INSTALL_FILE, ii, session);
    }

    private void saveUpdate(InstallInfoConfig ii, InstallInfoConfig ii0, NutsSession session) {
        Instant now = Instant.now();
        String user = session.security().getCurrentUsername();
        if (ii.getCreationUser() == null) {
            ii.setCreationUser(user);
        }
        if (ii.getCreationDate() == null) {
            ii.setCreationDate(now);
        }
        if (!ii.equals(ii0)) {
            ii.setLastModificationDate(now);
            ii.setLastModificationUser(user);
            ii.setConfigVersion("0.8.0");
            this.printJson(ii.getId(), NUTS_INSTALL_FILE, ii, session);
        }
    }

    public void addString(NutsId id, String name, String value, NutsSession session) {
        this.getPath(id, name, session).writeBytes(value.getBytes());
    }

    public <T> T readJson(NutsId id, String name, Class<T> clazz, NutsSession session) {
        return (T)NutsElements.of((NutsSession)session).setSession(session).json().parse(this.getPath(id, name, session), clazz);
    }

    public void printJson(NutsId id, String name, InstallInfoConfig value, NutsSession session) {
        value.setConfigVersion(this.workspace.getApiVersion().toString());
        NutsElements.of((NutsSession)session).setNtf(false).setSession(session).json().setValue((Object)value).print(this.getPath(id, name, session));
    }

    public void remove(NutsId id, String name, NutsSession session) {
        NutsPath path = this.getPath(id, name, session);
        path.delete();
    }

    public boolean contains(NutsId id, String name, NutsSession session) {
        return this.getPath(id, name, session).isRegularFile();
    }

    public NutsPath getPath(NutsId id, String name, NutsSession session) {
        return session.locations().setSession(session).getStoreLocation(id, NutsStoreLocation.CONFIG).resolve(name);
    }

    @Override
    public NutsRepositorySecurityManager security() {
        throw new IllegalArgumentException("unsupported security() for " + this.getName() + " repository");
    }

    public NutsDeployRepositoryCommand deploy() {
        return new AbstractNutsDeployRepositoryCommand(this){

            @Override
            public NutsDeployRepositoryCommand run() {
                boolean succeeded = false;
                try {
                    NutsDescriptor rep = DefaultNutsInstalledRepository.this.deployments.deploy(this, NutsConfirmationMode.YES);
                    this.setDescriptor(rep);
                    this.setId(rep.getId());
                    succeeded = true;
                }
                finally {
                    DefaultNutsInstalledRepository.this.addLog(NutsInstallLogAction.DEPLOY, this.getId(), null, null, succeeded, this.getSession());
                }
                return this;
            }
        };
    }

    public NutsRepositoryUndeployCommand undeploy() {
        return new AbstractNutsRepositoryUndeployCommand(this){

            @Override
            public NutsRepositoryUndeployCommand run() {
                boolean succeeded = false;
                try {
                    DefaultNutsInstalledRepository.this.deployments.undeploy(this);
                    succeeded = true;
                }
                finally {
                    DefaultNutsInstalledRepository.this.addLog(NutsInstallLogAction.UNDEPLOY, this.getId(), null, null, succeeded, this.getSession());
                }
                return this;
            }
        };
    }

    public NutsPushRepositoryCommand push() {
        return new AbstractNutsPushRepositoryCommand(this){

            @Override
            public NutsPushRepositoryCommand run() {
                throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"unsupported push() for %s repository", (Object[])new Object[]{DefaultNutsInstalledRepository.this.getName()}));
            }
        };
    }

    public NutsFetchDescriptorRepositoryCommand fetchDescriptor() {
        return new AbstractNutsFetchDescriptorRepositoryCommand(this){

            @Override
            public NutsFetchDescriptorRepositoryCommand run() {
                this.result = DefaultNutsInstalledRepository.this.deployments.fetchDescriptorImpl(this.getId(), this.getSession());
                return this;
            }
        };
    }

    public NutsFetchContentRepositoryCommand fetchContent() {
        return new AbstractNutsFetchContentRepositoryCommand(this){

            @Override
            public NutsFetchContentRepositoryCommand run() {
                this.result = DefaultNutsInstalledRepository.this.deployments.fetchContentImpl(this.getId(), this.getLocalPath(), this.getSession());
                return this;
            }
        };
    }

    public NutsSearchRepositoryCommand search() {
        return new AbstractNutsSearchRepositoryCommand(this){

            @Override
            public NutsSearchRepositoryCommand run() {
                NutsIterator<InstallInfoConfig> installIter = DefaultNutsInstalledRepository.this.searchInstallConfig(this.getSession());
                NutsIterator idIter = IteratorBuilder.of(installIter, this.getSession()).map(NutsFunction.of(InstallInfoConfig::getId, (String)"NutsInstallInformation->Id")).build();
                NutsIdFilter ff = this.getFilter();
                if (ff != null) {
                    idIter = IteratorBuilder.of(idIter, this.getSession()).filter(new NutsIdFilterToPredicate(ff, this.getSession())).build();
                }
                this.result = idIter;
                if (this.result == null) {
                    this.result = IteratorBuilder.emptyIterator();
                }
                return this;
            }
        };
    }

    public NutsSearchVersionsRepositoryCommand searchVersions() {
        return new AbstractNutsSearchVersionsRepositoryCommand(this){

            @Override
            public NutsSearchVersionsRepositoryCommand run() {
                if (this.getFilter() instanceof NutsInstallStatusIdFilter) {
                    NutsPath installFolder = this.getSession().locations().getStoreLocation(this.getId().builder().setVersion("ANY").build(), NutsStoreLocation.CONFIG).getParent();
                    if (installFolder.isDirectory()) {
                        final NutsVersionFilter filter0 = this.getId().getVersion().filter();
                        this.result = IteratorBuilder.of(installFolder.list().iterator(), this.getSession()).map(NutsFunction.of((Function)new Function<NutsPath, NutsId>(){

                            @Override
                            public NutsId apply(NutsPath folder) {
                                if (folder.isDirectory() && folder.resolve(DefaultNutsInstalledRepository.NUTS_INSTALL_FILE).isRegularFile()) {
                                    NutsVersion vv = NutsVersion.of((String)folder.getName(), (NutsSession)this.getSession());
                                    NutsIdFilter filter = this.getFilter();
                                    NutsSession session = this.getSession();
                                    if (filter0.acceptVersion(vv, session) && (filter == null || filter.acceptId(this.getId().builder().setVersion(vv).build(), session))) {
                                        return this.getId().builder().setVersion(folder.getName()).build();
                                    }
                                }
                                return null;
                            }
                        }, (String)"FileToVersion")).notNull().iterator();
                    } else {
                        this.result = IteratorBuilder.emptyIterator();
                    }
                } else {
                    this.result = IteratorBuilder.of(DefaultNutsInstalledRepository.this.deployments.searchVersions(this.getId(), this.getFilter(), true, this.getSession()), this.getSession()).named("searchVersionsInMain()").build();
                }
                return this;
            }
        };
    }

    public NutsUpdateRepositoryStatisticsCommand updateStatistics() {
        return new AbstractNutsUpdateRepositoryStatisticsCommand(this){

            @Override
            public NutsUpdateRepositoryStatisticsCommand run() {
                DefaultNutsInstalledRepository.this.deployments.reindexFolder(this.getSession());
                return this;
            }
        };
    }

    public boolean isAcceptFetchMode(NutsFetchMode mode, NutsSession session) {
        return mode == NutsFetchMode.LOCAL;
    }

    public boolean isRemote() {
        return false;
    }

    public void addLog(NutsInstallLogAction action, NutsId id, NutsId requestor, String message, boolean succeeded, NutsSession session) {
        InstallLogItemTable.of(session).add(new NutsInstallLogRecord(Instant.now(), session.security().getCurrentUsername(), action, id, requestor, message, succeeded), session);
    }
}

